#ifndef _DIRVIEW_H_INCLUDED
#define _DIRVIEW_H_INCLUDED

#include <qlistview.h>
#include "scanthread.h"

class DirViewItem : public QListViewItem
{
public:
	DirViewItem(QListView *parent, QString text, bool is_dir);
	~DirViewItem();

	virtual QString key(int col, bool ascending) const;
	bool isDir();
	void setScanItem(ScanItem);
	ScanItem scanItem();
	void paintCell(QPainter *p, const QColorGroup & cg, int column, int width, int alignment);
	void setPlayed();
	void setCurrent();
	void setRecent();
	void setNormal();
	bool played();
	bool current();
	bool recent();
	bool normal();
protected:
	bool s_new;
	bool s_current;
	bool s_played;
	bool isdir;
	ScanItem scan;
};

#endif
