/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/dummy_test_case.ts.cpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta]
 */


#include <diagnostics/util/dummy_test_case.ts.hpp>

#include <diagnostics/macros/assert_annotation.hpp>
#include <diagnostics/macros/check_annotation.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;

Dummy_Test_Case::Dummy_Test_Case(::std::string const & name,
								 int const timeout,
								 bool const is_rerunable,
								 bool const testable_at_prod,
								 bool const testable_at_debug,
								 bool const testable_at_audit,
								 bool const invalid,
								 bool const failure) 
    : Super(name,
			timeout,
			is_rerunable,
			testable_at_prod,
			testable_at_debug,
			testable_at_audit),
      m_run_count(0),
	  m_invalid(invalid),
	  m_failure(failure)
{
}


void Dummy_Test_Case::run(::diagnostics::unittest::Test_Data & test_data) const 
{
    ++m_run_count;
	TEST_TRACE((m_invalid ? "invalid" : "valid"));
	TEST_TRACE((m_failure ? "failure" : "success"));
	if(m_failure)
		DIAGNOSTICS_BASE_ASSERT(::diagnostics::LEVEL_TEST,
								0,"Dummy_Test_Case which should fail",false,\
								((void)0));
	
	if(m_invalid)
		DIAGNOSTICS_BASE_CHECK(::diagnostics::LEVEL_TEST,
							   0,"Dummy_Test_Case which should be invalid",false,\
							   ((void)0));
}


Stupid_Test_Case::Stupid_Test_Case(::std::string const & name) 
    : Super(name,0,true,true,true,true)
{
}

TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

// vim:ts=4:sw=4
