/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/diff.t.cpp
 *
 * @brief [LEVEL: alpha] testing @ref diagnostics::internal::diff_text
 *
 * $Id: diff.t.cpp 786 2007-03-01 21:48:44Z tautschn $
 *
 * @author Piotr Esden-Tempski
 */

#include <diagnostics/unittest.hpp>

#include <diagnostics/unittest/std_test_case.hpp>

// used components
#include <diagnostics/util/diff.hpp>

#define TEST_COMPONENT_NAME diff
#define TEST_COMPONENT_NAMESPACE diagnostics::internal

DIAGNOSTICS_NAMESPACE_BEGIN;
INTERNAL_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;
TEST_COMPONENT_TEST_NAMESPACE_BEGIN;
using namespace unittest;

/**
 * @brief [PRO] fct/normal: test the call by value interface
 */
void diff_call_by_value(Test_Data & test_data)
{
    ::std::string result;
    diff_text("Blubb\nBlubber", "Blubb\nbalub\nBlubber", result, true);
    TEST_ASSERT(test_data.compare("one line added",result));
}

/**
 * @brief [PRO] fct/normal: test the return value interface
 */
void diff_return_value(Test_Data & test_data)
{
	TEST_ASSERT(test_data.compare("one line added",
				      diff_text("Blubb\nBlubber", "Blubb\nbalub\nBlubber", true)));
}

TEST_COMPONENT_TEST_NAMESPACE_END;
TEST_NAMESPACE_END;
INTERNAL_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;


TEST_SUITE_BEGIN;
TEST_NORMAL_CASE(&diff_call_by_value,LEVEL_PROD);
TEST_NORMAL_CASE(&diff_return_value,LEVEL_PROD);
TEST_SUITE_END;

STREAM_TEST_SYSTEM_MAIN;
// vim:ts=4:sw=4
