/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/test_system.hpp
 *
 * @brief [LEVEL: beta] @ref diagnostics::unittest::Test_System
 * interface
 *
 * $Id: test_system.hpp,v 1.8 2005/06/23 09:54:27 esdentem Exp $
 * 
 * @author Christian Schallhart
 *
 * @test none
 */
#ifndef DIAGNOSTICS__UNITTEST__TEST_SYSTEM__TEST_SYSTEM_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UNITTEST__TEST_SYSTEM__TEST_SYSTEM_HPP__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>
#include <diagnostics/unittest/namespace.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

// used in the interface by reference
// <diagnostics/unittest/test_suite.hpp>
class Test_Suite;

// used in the interface by reference
// <diagnostics/unittest/test_case.hpp>
class Test_Case;

/**
 * @class Test_System diagnostics/unittest/test_system/test_system.hpp
 *
 * @brief Provides the abstraction for the unittest enviroment -- with
 * this interface at hand, Test_Cases and Test_Suites can be added and
 * finally they all can be tested by calling @ref run.
 *
 * @nosubgrouping
 */
class Test_System
{
	////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Types
     * @{
     */
public:
	/**
     * @brief The result of run -- used as bitmask
     */ 
	enum {
		/**
		 * @brief a test failure occured
		 */ 
		TEST_SYSTEM_RESULT_FAILURE=1,
		/**
		 * @brief a test could not be executed and driven to a
		 * conclusion, e.g., a test input file was missing
		 */ 
		TEST_SYSTEM_RESULT_INVALID=2
	};
	
	// @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Creation
     * @{
     */
public:
    /**
     * @brief do nothing
     *
     * @throw never
     */
    virtual ~Test_System();
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Modifiers
     * @{
     */
public:
    /**
     * @brief adding a @ref Test_Suite 
     *
     * @pre @a test_suite != NULL
     * @pre @a test_suite->name() != ""
     * @pre there is no other already added Test_Suite with the same name
     *
     * @throw Test_System_Exception if a precondition is not met
     */
    virtual void add(Test_Suite * const test_suite)
	=0;

    /**
     * @brief adding a @ref Test_Case
     *
     * @pre @a test_case != NULL
     * @pre @a test_case->name() != ""
     * @pre there is no other already added Test_Case with the same name
     *
     * @throw Test_System_Exception if a precondition is not met
     */
    virtual void add(Test_Case * const test_case)
	=0;

    /**
     * @brief starting the Test_System -- depending on the concrete
     * Test_System, the added Test_Cases and Test_Suites will be
     * executed, interactively or non-interactively.
	 *
	 * @return a bit mask describing the error state. 
     *
     * @throw Test_System_Exception (implementation dependent -- any
     * internal error)
     */
    virtual int run()
	=0;

    // @}
};

UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;


#endif
// vim:ts=4:sw=4
