/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/frame/set_initial_loggers.hpp
 *
 * @brief [LEVEL: beta] The @ref diagnostics::set_initial_loggers static hook
 *
 * $Id: set_initial_loggers.hpp,v 1.4 2005/06/23 09:54:20 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @test none
 */

#ifndef DIAGNOSTICS__FRAME__SET_INITIAL_LOGGERS_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__FRAME__SET_INITIAL_LOGGERS_HPP__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>

// used in the interface by reference
#include <vector>

DIAGNOSTICS_NAMESPACE_BEGIN;

// used in the interface by reference
// <diagnostics/frame/logger.hpp>
class Logger;

/** @attention The user of this library has to supply a @ref
 * set_initial_loggers procedure. This procedure is called during the
 * initialization of the logging framework, which is either triggered
 * by a call to one method of @ref Logging_Config or by a call to @ref
 * Logging_Facility::log. The rationale for this construction is that
 * static initialization might require logging, and thus the framework
 * must be fed with the correpsonding Loggers.
 *
 * @brief Places in @a loggers the initial set of loggers
 * This methods is to be supplied by the user of this library.
 *
 * @attention If a problem occurs, this method can use the @ref
 * DIAGNOSTICS_PANIC_LOG macro -- but is not allowed to throw. If it
 * throws, ::std::abotr will be called.
 *
 * @throw never
 */
void set_initial_loggers(::std::vector<Logger *> & loggers);

DIAGNOSTICS_NAMESPACE_END;

#endif

// vim:ts=4:sw=4
