/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/frame/logging_facility.t.cpp
 *
 * @brief [LEVEL: beta] testing @ref diagnostics::Logging_Facility
 *
 * $Id: logging_facility.t.cpp,v 1.16 2005/06/23 09:54:20 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @attention If an error occurs in this test-suite, the whole thing
 * might crash away, or provoced errors (since the logging is in
 * disray) may arise.
 */
#include <diagnostics/unittest.hpp>

#include <diagnostics/frame/logging_facility.hpp>

// used components
#include <diagnostics/frame/logging_config.hpp>
#include <diagnostics/frame/record.hpp>

// test support
#include <diagnostics/util/dummy_logger.ts.hpp>

#include <vector>

#define TEST_COMPONENT_NAME Logging_Facility
#define TEST_COMPONENT_NAMESPACE diagnostics

DIAGNOSTICS_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;
TEST_COMPONENT_TEST_NAMESPACE_BEGIN;
using namespace unittest;

/**
 * @brief registering, two log messages, and unregistering a @ref Logger
 */
void register_send_unregister(Test_Data & test_data)
{
    Dummy_Logger * dummy_logger(new Dummy_Logger);
    TEST_ASSERT(dummy_logger->is_closed()==0);
    TEST_ASSERT(dummy_logger->records().size()==0);

    Logging_Facility::log(LEVEL_DEBUG,TYPE_TRACE_BINARY,0,"what2","base2","file2",3);
    TEST_ASSERT(dummy_logger->records().size()==0);

    Logging_Config::register_logger(dummy_logger);
    TEST_ASSERT(dummy_logger->is_closed()==0);
    TEST_ASSERT(dummy_logger->records().size()==1);
    TEST_ASSERT(dummy_logger->records()[0].type()==TYPE_LOG_OPEN);
    
    Logging_Facility::log(LEVEL_AUDIT,TYPE_TRACE,10,"what","base","file",1);
    TEST_ASSERT(dummy_logger->records().size()==2);
    {
		Record const & r(dummy_logger->records()[1]);
		TEST_ASSERT(r.level()==LEVEL_AUDIT);
		TEST_ASSERT(r.type()==TYPE_TRACE);
		TEST_ASSERT(r.nr_what()==10);
		TEST_ASSERT(r.str_what()== "what");
		TEST_ASSERT(r.base_file_name()=="base");
		TEST_ASSERT(r.file_name()=="file");
		TEST_ASSERT(r.line()==1);
    }
    

    Logging_Facility::log(LEVEL_DEBUG,TYPE_TRACE_BINARY,1,"what1","base1","file1",2);
    TEST_ASSERT(dummy_logger->records().size()==3);
    {
		Record const & r(dummy_logger->records()[2]);
		TEST_ASSERT(r.level()==LEVEL_DEBUG);
		TEST_ASSERT(r.type()==TYPE_TRACE_BINARY);
		TEST_ASSERT(r.nr_what()==1);
		TEST_ASSERT(r.str_what()== "what1");
		TEST_ASSERT(r.base_file_name()=="base1");
		TEST_ASSERT(r.file_name()=="file1");
		TEST_ASSERT(r.line()==2);
    }

    Logging_Config::unregister_logger(dummy_logger);
    TEST_ASSERT(dummy_logger->is_closed()==0);
    TEST_ASSERT(dummy_logger->records().size()==4);
    TEST_ASSERT(dummy_logger->records()[3].type()==TYPE_LOG_CLOSE);

    Logging_Facility::log(LEVEL_DEBUG,TYPE_TRACE_BINARY,0,"what2","base2","file2",3);
    TEST_ASSERT(dummy_logger->records().size()==4);
}


void log_1024_1024(Test_Data & data)
{
    for(int i=0;i<1024*1024;++i)
		DIAGNOSTICS_BASE_LOG(LEVEL_PROD,TYPE_TRACE,0,"xxxYY");
}


TEST_COMPONENT_TEST_NAMESPACE_END;
TEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

TEST_SUITE_BEGIN;
TEST_NORMAL_CASE(&register_send_unregister,LEVEL_PROD);
TEST_NONFCT_CASE(&log_1024_1024,30);
TEST_SUITE_END;

STREAM_TEST_SYSTEM_MAIN;

// vim:ts=4:sw=4
