/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Handlers
{
	public class StringHandlerTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public virtual void TestIndexMarshalling()
		{
			Db4objects.Db4o.Internal.Buffer reader = new Db4objects.Db4o.Internal.Buffer(2 * 
				Db4objects.Db4o.Internal.Const4.INT_LENGTH);
			Db4objects.Db4o.Internal.ObjectContainerBase stream = (Db4objects.Db4o.Internal.ObjectContainerBase
				)Db();
			Db4objects.Db4o.Internal.Handlers.StringHandler handler = new Db4objects.Db4o.Internal.Handlers.StringHandler
				(stream, stream.StringIO());
			Db4objects.Db4o.Internal.Slots.Slot original = new Db4objects.Db4o.Internal.Slots.Slot
				(unchecked((int)(0xdb)), unchecked((int)(0x40)));
			handler.WriteIndexEntry(reader, original);
			reader._offset = 0;
			Db4objects.Db4o.Internal.Slots.Slot retrieved = (Db4objects.Db4o.Internal.Slots.Slot
				)handler.ReadIndexEntry(reader);
			Db4oUnit.Assert.AreEqual(original._address, retrieved._address);
			Db4oUnit.Assert.AreEqual(original._length, retrieved._length);
		}
	}
}
