/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
using System;
using System.Diagnostics;

namespace Db4oAdmin
{
	public class Program
	{
		static int Main(string[] args)
		{	
			ProgramOptions options = new ProgramOptions(args);
			if (!options.IsValid)
			{
				options.DoHelp();
				return -1;
			}

			return Run(options);
		}

		private static int Run(ProgramOptions options)
		{
			Trace.Listeners.Add(new TextWriterTraceListener(Console.Error));
			try
			{
				InstrumentationPipeline pipeline = new InstrumentationPipeline(GetConfiguration(options));
				if (options.OptimizePredicates)
				{
					pipeline.Add(new PredicateOptimizer());
				}
				if (options.EnableCF2DelegateQueries)
				{
					pipeline.Add(new CFNQEnabler());
				}
				foreach (string customInstrumentation in options.CustomInstrumentations)
				{
					pipeline.Add((IAssemblyInstrumentation)Activator.CreateInstance(Type.GetType(customInstrumentation, true)));
				}
				if (!options.Fake)
				{
					pipeline.Add(new SaveAssemblyInstrumentation());
				}
				pipeline.Run();
			}
			catch (Exception x)
			{
				ReportError(options, x);
				return -2;
			}
			return 0;
		}

		private static void ReportError(ProgramOptions options, Exception x)
		{
			if (options.Verbose)
			{
				Console.WriteLine(x);
			}
			else
			{
				Console.WriteLine(x.Message);
			}
		}

		private static Configuration GetConfiguration(ProgramOptions options)
		{
			Configuration configuration = new Configuration(options.Assembly);
			configuration.CaseSensitive = options.CaseSensitive;
			if (options.Verbose)
			{
				configuration.TraceSwitch.Level = options.PrettyVerbose ? TraceLevel.Verbose : TraceLevel.Info;
			}
			return configuration;
		}
	}
}