/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   Copyright (C) 2004 by Scott Wheeler                                   *
 *   wheeler@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SORTEDSTRINGLIST_H
#define SORTEDSTRINGLIST_H

#include <qstringlist.h>

class SortedStringList
{
public:
    SortedStringList();
    ~SortedStringList();

    bool insert( const QString &value );
    bool contains( const QString &value ) const;
    bool remove
        ( const QString &value );

    QStringList values() const;

private:
    class Node;

    Node *find( const QString &value ) const;

    bool BSTInsert( const QString &value );
    void traverse( const Node *n, QStringList &list ) const;

    Node *treeMinimum( Node *n ) const;
    Node *treeSuccessor( Node *n ) const;

    Node *m_root;
};

#endif
