/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   Copyright (C) 2004 by Scott Wheeler                                   *
 *   wheeler@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kconfigbase.h>
#include <kconfig.h>

#include "datakiosk.h"

static const char description[] = I18N_NOOP( "DataKiosk: A database interface tool." );
static const char adam[] = I18N_NOOP( "Author of DataKiosk." );
static const char scott[] = I18N_NOOP( "Author of Juk.  DataKiosk is partially based upon JuK." );
static const char tt[] = I18N_NOOP( "Authors of Qt designer.  DataKiosk is partially based upon designer." );

static KCmdLineOptions options[] =
    {
        { "project <file>", I18N_NOOP( "Project file to open" ), 0 },
        KCmdLineLastOption
    };

int main( int argc, char *argv[] )
{
    KAboutData aboutData( "datakiosk", I18N_NOOP( "DataKiosk" ),
                          "0.7", description, KAboutData::License_GPL,
                          "(c) 2005, Adam Treat", 0,
                          "" );

    aboutData.addAuthor( "Adam Treat", adam, "treat@kde.org" );
    aboutData.addCredit( "Scott Wheeler", scott, "wheeler@kde.org" );
    aboutData.addCredit( "Trolltech AS", tt, "info@trolltech.com" );

    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options );

    KApplication::addCmdLineOptions();

    KApplication a;
    DataKiosk *datakiosk = new DataKiosk();
    a.setMainWidget( datakiosk );
    datakiosk->show();

    return a.exec();
}
