/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef DATAFIELD_H
#define DATAFIELD_H

#include <qmap.h>
#include <qstring.h>
#include <qvariant.h>
#include <qvaluelist.h>

class DataField;
class QSqlRecord;
typedef QValueList<DataField *> DataFieldList;
typedef QMap<QString, QSqlRecord *> DataRecordList;

class DataRelation
{
public:
    DataRelation()
        : m_table( QString::null ),
        m_key( QString::null ),
        m_constraint( QString::null )
    {}
    virtual ~DataRelation();

    QString table() const;
    void setTable( const QString &table );

    QString key() const;
    void setKey( const QString &key );
    QString fullKey() const;

    QString field();
    void setField( const QString &field );
    QString fullField();

    QString constraint();
    void setConstraint( const QString &constraint );

    QVariant::Type type();
    void setType( const QVariant::Type type );

    int number();
    void setNumber( int num );

    int editorWidth();
    void setEditorWidth( int num );

    DataRelation* dataRelation( const QString &key );
    void addDataRelation( const QString &name, const QString &targetTable,
                          const QString &targetKey, const QString &targetField,
                          const QString &targetConstraint,
                          const QVariant::Type targetType, int number,
                          int editorWidth );

    DataFieldList fieldList();

    DataField* dataField( const QString &key );

    void addDataField( const QString &name, const QVariant::Type type,
                       int number, int editorWidth, bool foreign, bool primary,
                       bool reporter, bool hidden );
    void removeDataField( DataField *field );

    DataField *getReportField();

    DataField *getPrimaryField();

private:
    QString m_table;            //The name of the target table
    QString m_key;              //The name of the target key
    QString m_constraint;       //The name of the target constraint
    DataFieldList m_fieldList;  //Complete field list to sub in the editor
};

class DataField
{
public:
    DataField()
        : m_name( QString::null ),
        m_table( QString::null ),
        m_type( QVariant::Invalid ),
        m_required( 0 ),
        m_calculated( false ),
        m_virtual( false ),
        m_equation( QString::null ),
        m_label( QString::null ),
        m_number( -1 ),
        m_width( 0 ),
        m_editorWidth( 0 ),
        m_foreign( false ),
        m_primary( false ),
        m_reporter( false ),
        m_hidden( false ),
        m_resizable( false ),
        m_sortable( false ),
        m_relation( 0L )
    {}
    virtual ~DataField()
    {
        delete m_relation;
    }

    QString name() const;
    void setName( const QString &name );
    QString fullName() const;

    QString table() const;
    void setTable( const QString &table );

    QVariant::Type type() const;
    void setType( const QVariant::Type type );

    int isRequired() const;
    void setRequired( int isRequired );

    bool calculated() const;
    void setCalculated( bool calculated );

    QString equation() const;
    void setEquation( const QString &equation );

    bool isVirtual() const;
    void setVirtual( bool isVirtual );

    QString label() const;
    void setLabel( const QString &label );

    int number() const;
    void setNumber( int number );

    int width() const;
    void setWidth( int width );

    int editorWidth() const;
    void setEditorWidth( int width );

    bool foreign() const;
    void setForeign( bool foreign );

    bool primary() const;
    void setPrimary( bool primary );

    bool reporter() const;
    void setReporter( bool reporter );

    bool hidden() const;
    void setHidden( bool hidden, bool invalidateNumber = true );

    bool resizable() const;
    void setResizable( bool resizable );

    bool sortable() const;
    void setSortable( bool sortable );

    DataRelation* relation() const;
    void setRelation( DataRelation* relation );

    QVariant calculateField( DataRecordList currentRecords );

private:
    QString m_name;
    QString m_table;
    QVariant::Type m_type;
    int m_required;
    bool m_calculated, m_virtual;
    QString m_equation;
    QString m_label;
    int m_number;
    int m_width;
    int m_editorWidth;
    bool m_foreign, m_primary, m_reporter, m_hidden, m_resizable, m_sortable;
    DataRelation* m_relation;
};

#endif
