/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef KCOMPLETIONTABLE_H
#define KCOMPLETIONTABLE_H

#include <kcompletionbox.h>

class KCompletionTable : public KCompletionBox
{
    Q_OBJECT
public:
    KCompletionTable( QWidget *parent = 0, const char *name = 0 );

    virtual ~KCompletionTable();

    void calculateWidths( QStringList &list );

    QValueList<int> columnWidths() const;
    void setColumnWidths( QValueList<int> &colWidths );
    void clearWidths();

    virtual QSize sizeHint() const;

public slots:
    virtual void popup();
    virtual void show();
    virtual void resize ( int w, int h );

protected:
    virtual void paintCell( QPainter * p, int row, int col );

private:
    void setupPainter( QPainter *p, QListBoxItem *i );
    int columnPosition( uint column );

private:
    int m_boxWidth;
    int m_boxHeight;
    QMap<int, int> m_colWidths;
    uint m_countCache;
};

#endif
