# tioga.rb, copyright (c) 2006 by Vincent Fourmond: 
# The interface between Tioga and CTioga (to use CTioga from within
# Tioga code)
  
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
  
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details (in the COPYING file).

require 'Tioga/FigureMaker'
require 'CTioga/plotmaker'
require 'shellwords'

class FigureMaker

   def def_figure_ctioga(name, cmdline)
      CTioga.define_tioga_figure(self, 'CTioga', *Shellwords.shellwords(cmdline))
   end

   def show_plot_ctioga(cmdline)
      CTioga.show_tioga_plot(self, *Shellwords.shellwords(cmdline))
   end

end # FigureMaker 
