# test_qt.rb: a visual test for Qt stuff.
# Copyright (C) 2006 Vincent Fourmond

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA


# Be careful: this is *not* a test suite. It is just meant to provide
# a quick look to check everything is fine. You just can't use automatic
# tests for GUIs... (unless you spend a lot of time designing an automatic
# clicker|keyboard typer, but that would be too much fun for me).

require 'Qt'
require 'MetaBuilder/parameters'
require 'MetaBuilder/qt4'

# Prompts for a parameter, with the default value
def prompt_parameter(type, value)
  t = MetaBuilder::ParameterType.get_param_type(type).new(type)
  begin
    val = t.qt4_get(nil, "Enter parameter", 
                   "Parameter (#{t.type_name})",
                   value)
    puts "Value: #{val.inspect}, class #{val.class}"
  rescue MetaBuilder::CancelInput
    puts 'User cancelled input'
  end
end

a = Qt::Application.new([])

prompt_parameter({:type => :integer}, 12)
prompt_parameter({:type => :float}, 12.0)
prompt_parameter({:type => :string}, "biniou")
prompt_parameter({:type => :file, 
                   :filter => "Biniou (*.txt)"}, "biniou")
# prompt_parameter(:boolean, "false")



