# source.rb : The implementation of a data source
# Copyright (C) 2006 Vincent Fourmond

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

module SciYAG

  # A data source is a class containing raw data, most probably under
  # the form of a list of Dvectors. It is the job of Representations to
  # transform that source into a 2D or 3D set.
  class DataSource

    # The list of the columns
    attr_reader :columns

    # A list of hashes of informations about the columns
    attr_reader :columns_info

    # Some informations about the source. Different possibilities:
    # * :filename, the name of the file from where the source is
    #   coming;
    # * :dataset, the name of dataset, if applicable.
    # and so on...
    attr_accessor :informations

    # Creates a datasource, and fills it with the columns _columns_.
    # It is better however to use directly #add_column to fill
    # the source with Data.
    def initialize(*columns)
      @columns = []
      @columns_info = []
      @informations = {}
    end

    # Automatic naming of the columns
    def auto_name(number)
      return "$#{number}"
    end

    # Add a column and its information to the list. 
    def add_column(col, name = nil, infos = {})
      name = auto_name(col.length) unless name
      @columns << col
      infos[:name] = name
      @columns_info << infos
    end
  end

end
