/*
 *  File:       branch.h
 *  Summary:    Dungeon branch classes
 *  Written by: Haran Pilpel
 *
 *  Modified for Crawl Reference by $Author: ennewalker $ on $Date: 2007-11-23T02:25:44.246247Z $
 *
 */

#ifndef BRANCH_H
#define BRANCH_H

#include "enum.h"

struct Branch
{
    branch_type id;
    branch_type parent_branch;
    int depth;
    int startdepth;             // which level of the parent branch,
                                // 1 for first level
    dungeon_feature_type entry_stairs;
    dungeon_feature_type exit_stairs;
    const char* shortname;      // "Slime Pits"
    const char* longname;       // "The Pits of Slime"
    const char* abbrevname;     // "Slime"
    const char* entry_message;
    bool has_shops;
    bool has_uniques;
    char floor_colour;          // Zot needs special handling
    char rock_colour;
    int (*mons_rarity_function)(int);
    int (*mons_level_function)(int);
    int altar_chance;           // in percent
    int travel_shortcut;        // which key to press for travel
    bool any_upstair_exits;     // any upstair exits the branch (Hell branches)
};

extern Branch branches[];

Branch& your_branch();
branch_type str_to_branch(const std::string &branch,
                          branch_type err = NUM_BRANCHES);

#endif
