# This is a -*- perl -*- script
#
# Authors:  Henning Makholm (makholm@diku.dk)
# Content:  C-Mix system: postprocessor for preprocessed output
#
# Copyright  1999. The TOPPS group at DIKU, U of Copenhagen.
# Redistribution and modification are allowed under certain
# terms; see the file COPYING.cmix for details.
#
#
# This script may be useful for post-processing the output
# of `cmix -E'. It prefixed every line in the input with a
# filename:line: specification identical to the one C-Mix
# uses in error messages. This makes it easy to search for
# the origin of an error message in the preprocessed code.

$filename = "stdin" ;
$line = 1 ;
while( <> ) {
  if ( m!^/\* C-MIX/II PREPROCESSED: (.*) \*/$! ) {
    print "========== $1 ==========\n" ;
    $filename = $1 ;
    $line = 1 ;
  } elsif ( /^\s*#\s*(line)?\s*([0-9]+)\s*"([^"]+)"/ ) {
    $filename = $3 ;
    $line = $2 ;
  } elsif ( /^\s*#\s*(line)?\s*([0-9]+)/ ) {
    $line = $2 ;
  } elsif ( /^\s*$/ ) {
    $line++ ;
  } else {
    print "$filename:$line: $_" ;
    $line++ ;
  }
}
