########################################################################
#
# generate the .c-file
#
########################################################################
proc genDotC {outName} {
  global BASE debug D Program haveMandatory

  set pname [file tail [file rootname $Program]]
  set outBase [file tail [file rootname $outName]]
  set out [open $outName w]

  
  append msg \
      "/*****\n" \
      "  command line parser -- generated by $pname\n" \
      "  (http://wsd.iitb.fhg.de/~kir/clighome/)\n" \
      "\n" \
      "  The command line parser `clig':\n" \
      "  (C) 1995-2004 Harald Kirsch "\
      "(clig@geggus.net)\n" \
      "*****/\n" \
      "\n" \
      "\#include <stdio.h>\n" \
      "\#include <stdlib.h>\n" \
      "\#include <string.h>\n" \
      "\#include <ctype.h>\n" \
      "\#include <errno.h>\n" \
      "\#include <limits.h>\n" \
      "\#include <float.h>\n" \
      "\#include <math.h>\n" \
      "\n" \
      "\#include \"${outBase}.h\"\n" \
      "\n" \
      "char *Program;\n" \
      "\n" \
      "/*@-null*/\n" \
      "[genDefault]\n" \
      "/*@=null*/\n" \
      "\n" \
      "/***** let LCLint run more smoothly */\n" \
      "/*@-predboolothers*/\n" \
      "/*@-boolops*/\n" \
      "\n"
  puts $out $msg
      
  puts $out \
    "/******************************************************************/"

  flush $out
  foreach file {
    checkFloatConversion
    getIntOpt getIntOpts
    getLongOpt getLongOpts
    getFloatOpt getFloatOpts
    getDoubleOpt getDoubleOpts
    getStringOpt getStringOpts
    checkIntLower checkIntHigher
    checkLongLower checkLongHigher
    checkFloatLower checkFloatHigher
    checkDoubleLower checkDoubleHigher
  } {
    puts $out [cat [file join $BASE c $file.c]]
  }

  if { $haveMandatory } {
    puts $out [cat [file join $BASE c missingErr.c]]
  }

  if {[info exist D(commandline)]} {
    puts $out [cat [file join $BASE c catArgv.c]]
  }

  if {[info exist debug]} {
    puts $out [genShowOptionValues]
  }
  puts $out [genUsage]
  puts $out [genParse]
  close $out
}
