#!/usr/bin/env python


########################################################################
#    Chris's Lame File Brower 4 (This reads the /etc/fstab)
#    Copyright 2004, Gabe Ginorio <gabe@zevallos.com.br>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
 #   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#######################################################################	

import os, os.path, string, re


def read():
    
    # Make a list to store the mountpoints
    mountpoints = []
    
    # Try and open the /etc/fstab/file
    try:
        fstab = file("/etc/fstab", 'r').readlines()
    except:
        return []
    
    # Read the information from it
    for line in fstab:
        # Read only the lines with mount points and add them to a list
        if line[0] != "#" and line[0:5] == "/dev/" and string.find(line, "swap") == -1:
            mountpoint = string.split(line)[1]
            mountpoints.append(mountpoint)
			
    return mountpoints
