#!/usr/bin/env python

########################################################################
# Chris's Lame Filebrowser 4 (Info Bar and the Toggle Listview Button)
# Copyright 2004, Gabe Ginorio <gabe@zevallos.com.br>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
######################################################################

import sys, string
import gtk, pygtk, pango

def create(Notebook):
	'''This functoin creates the infamous info bar and the toggle list
	view button'''
	bottom_box = gtk.HBox()
	
	# Create the info bar
	info_label = gtk.Label()
	info_label.set_text("CLAW 4")
	#info_label.modify_font(pango.FontDescription("sans 12"))
	
	# Create the toggle button
	list_button = gtk.ToggleButton()
	list_image = gtk.Image()
	list_image.set_from_file(string.replace(sys.argv[0], "claw4.py","Images/Toolbar/list.png"))
	list_button.add(list_image)
	list_button.connect("clicked", __toggleListview__, Notebook)
	
	# Add a tooltip
	tooltip = gtk.Tooltips()
	tooltip.enable()
	tooltip.set_tip(list_button, "Toggle List View")
	
	# Pack it to go
	bottom_box.pack_start(info_label, True, False)
	bottom_box.pack_start(list_button, False, False)
	bottom_box.show_all()

	return bottom_box
	
def __toggleListview__(button, Notebook):
	'''This is the callback for the toggle button'''
	Notebook.toggleView()
