C**** FILE  MI50LP   FORTRAN.
C
C     M5CHZR   M5FRMC   M5LOG    M5LPIT   M5PRIC
C     M5SETP   M5SETX   M5SOLV
C
      SUBROUTINE M5CHZR( M,HRTYPE,BBL,BBU,X,Y,
     *                   ATBND,TOLPIV,TOLX,
     *                   HITLOW,JP,THETA )
C
      IMPLICIT           REAL*8(A-H,O-Z)
      INTEGER*2          HRTYPE(M)
      DOUBLE PRECISION   BBL(M),BBU(M)
      DOUBLE PRECISION   X(M),Y(M)
      LOGICAL            ATBND,HITLOW
      LOGICAL            HLOW1,HLOW2
C  ---------------------------------------------------------------------
C
C     M5CHZR  FINDS A STEP  THETA  SUCH THAT THE POINT  X - THETA*P
C     REACHES ONE OF THE BOUNDS ON  X.  THE DIRECTION  P  IS IN  Y.
C     IF ATBND IS TRUE, P = - Y.
C
C     IN THIS VERSION OF CHUZR, WHEN X IS INFEASIBLE THE SUM OF
C     INFEASIBILITIES WILL OCCASIONALLY INCREASE AFTER THE STEP  THETA,
C     BUT THE NUMBER OF INFEASIBILITIES WILL NOT.  THE LATTER
C     COULD DECREASE BY 0, 1, OR MORE.
C
C     TWO POSSIBLE STEPS ARE COMPUTED AS FOLLOWS...
C
C     THETA1 = THE MAXIMUM STEP THAT CAN BE TAKEN WITHOUT VIOLATING
C              ONE OF THE BOUNDS THAT ARE CURRENTLY SATISFIED.
C     THETA2 = THE MAXIMUM (NONZERO) STEP THAT HAS THE PROPERTY OF
C              REACHING A BOUND THAT IS CURRENTLY VIOLATED.
C              (THETA2 IS NOT DEFINED IF  X  IS FEASIBLE.)
C
C     IF FEASIBLE, WE TAKE  THETA = THETA1.
C     OTHERWISE,   WE TAKE  THETA = MIN( THETA1, THETA2 ).
C
C     INPUT PARAMETERS
C     ----------------
C     M      IS REALLY M+1 FOR M5LPIT,  M+NS FOR M7RGIT.
C     HRTYPE IS SET BY  M5FRMC  AS FOLLOWS...
C            HRTYPE(J) = -1  IF X(J) .LT. BL(J) - TOLX
C                      =  0  IF X(J) IS FEASIBLE
C                      = +1  IF X(J) .GT. BU(J) + TOLX
C     BBL    THE LOWER BOUNDS ON THE BASIC AND SUPERBASIC VARIABLES.
C     BBU    THE UPPER BOUNDS ON DITTO.
C     X      THE VALUES OF DITTO.
C     Y      THE SEARCH DIRECTION.
C     ATBND  = .FALSE.  IF X IS CHANGING TO X - THETA*Y
C            = .TRUE.   IF X IS CHANGING TO X + THETA*Y
C     TOLPIV IS A TOLERANCE TO EXCLUDE NEGLIGIBLE ELEMENTS OF Y.
C     TOLX   IS THE FEASIBILITY TOLERANCE USED BY M5FRMC.
C     THETA  SHOULD INPUT STEPMX, THE LARGEST PERMISSIBLE STEP.
C
C
C     OUTPUT PARAMETERS
C     -----------------
C     HITLOW  = .TRUE. IF A LOWER BOUND RESTRICTED THETA.
C             = .FALSE. OTHERWISE.
C     JP      = THE POSITION OF THE X THAT REACHES A BOUND.
C     THETA   = THE REQUIRED STEP.  (SLIGHTLY NEGATIVE VALUES
C               CAN ARISE -- THESE SHOULD BE TREATED AS ZERO.)
C
C
C     THETA1 IS THE STEP COMPUTED BY THE CLASSICAL RATIO TEST.
C     THETA2 IS NEEDED OCCASIONALLY WHEN INFEASIBLE, TO PREVENT
C     GOING UNNECESSARILY FAR WHEN  THETA1  IS QUITE LARGE.  IT WILL
C     ALWAYS COME INTO EFFECT WHEN X IS ABOUT TO BECOME FEASIBLE.
C     (THE SUM OF INFEASIBILITIES WILL DECREASE INITIALLY AS THETA
C     INCREASES FROM ZERO, BUT IT IS NOT GUARANTEED TO BE DECREASING
C     STILL FOR A STEP AS LARGE AS THETA2, LET ALONE A LARGER STEP.)
C     CHOOSING THE MAXIMUM POSSIBLE THETA2 ALLOWS SEVERAL ELEMENTS
C     OF  X  TO BECOME FEASIBLE AT THE SAME TIME.
C
C     THE TWO-PASS APPROACH USED HERE FOR COMPUTING  THETA  IS
C     ANALOGOUS TO THE PROCEDURE SUGGESTED BY PAULA HARRIS (1973)
C     FOR HELPING TO RESOLVE DEGENERACY.  IT TENDS TO AVOID SMALL PIVOTS
C     AND THEREFORE HELPS AVOID UNNECESSARILY ILL-CONDITIONED BASES.
C
C
C     THIS VERSION WRITTEN NOVEMBER 1981.
C  ---------------------------------------------------------------------
C
      ZERO   = 0.0
      THETA1 = THETA
      THETA2 = ZERO
      PERTBN = 1.1*TOLX
C
C     TOLX    MUST BE THE SAME AS THE ONE USED IN  M5FRMC.
C     PERTBN  MUST BE GREATER THAN  TOLX.
C
C  ---------------------------------------------------------------------
C  FIRST PASS -- PERTURB  RES, THE DISTANCE TO EACH BOUND, SO THAT
C  THETA1 WILL BE SLIGHTLY LARGER THAN THE TRUE STEP, AND
C  THETA2 WILL BE SLIGHTLY SMALLER THAN IT SHOULD BE.  IN DEGENERATE
C  CASES, THIS STRATEGY GIVES US SOME FREEDOM IN THE SECOND PASS.
C  ---------------------------------------------------------------------
C
      DO 200 J = 1, M
         PIVOT  = Y(J)
         PIVABS = DABS(PIVOT)
         IF (PIVABS .LE. TOLPIV) GO TO 200
         IF (ATBND) PIVOT = - PIVOT
         JTYPE  = HRTYPE(J)
         IF (PIVOT .LT. ZERO) GO TO 150
C
C        X  IS DECREASING.
C        TEST FOR SMALLER  THETA1  IF LOWER BOUND IS SATISFIED.
C
         IF (JTYPE .LT. 0) GO TO 200
         RES    = X(J) - BBL(J) + PERTBN
         IF (THETA1*PIVOT .LE. RES) GO TO 140
         THETA1 = RES/PIVOT
C
C        TEST FOR BIGGER  THETA2  IF UPPER BOUND IS VIOLATED.
C
  140    IF (JTYPE .EQ. 0) GO TO 200
         RES    = X(J) - BBU(J) - PERTBN
         IF (THETA2*PIVOT .GE. RES) GO TO 200
         THETA2 = RES/PIVOT
         GO TO 200
C
C        X  IS INCREASING.
C        TEST FOR SMALLER  THETA1  IF UPPER BOUND IS SATISFIED.
C
  150    IF (JTYPE .GT. 0) GO TO 200
         RES = BBU(J) - X(J) + PERTBN
         IF (THETA1*PIVABS .LE. RES) GO TO 160
         THETA1 = RES/PIVABS
C
C        TEST FOR BIGGER  THETA2  IF LOWER BOUND IS VIOLATED.
C
  160    IF (JTYPE .EQ. 0) GO TO 200
         RES = BBL(J) - X(J) - PERTBN
         IF (THETA2*PIVABS .GE. RES) GO TO 200
         THETA2 = RES/PIVABS
  200 CONTINUE
C
C  ---------------------------------------------------------------------
C  SECOND PASS -- RECOMPUTE STEP-LENGTHS WITHOUT PERTURBATION.
C  AMONGST BOUNDS THAT ARE CLOSE TO THE PERTURBED STEPS,
C  CHOOSE THE LARGEST ASSOCIATED PIVOT ELEMENTS.
C  ---------------------------------------------------------------------
C
      PTHET1 = THETA1
      PTHET2 = THETA2
      PIVMX1 = ZERO
      PIVMX2 = ZERO
      JHIT1  = 0
      JHIT2  = 0
      HLOW1  = .FALSE.
C
      DO 400 J = 1, M
         PIVOT  = Y(J)
         PIVABS = DABS(PIVOT)
         IF (PIVABS .LE. TOLPIV) GO TO 400
         IF (ATBND) PIVOT = - PIVOT
         JTYPE  = HRTYPE(J)
         IF (PIVOT .LT. ZERO) GO TO 350
C
C        X  IS DECREASING.
C        TEST FOR SMALLER  THETA1 IF LOWER BOUND IS SATISFIED.
C
         IF (JTYPE .LT. 0) GO TO 400
         RES    = X(J) - BBL(J)
         IF (PTHET1*PIVOT .LT. RES) GO TO 340
         IF (PIVMX1 .GE. PIVOT)     GO TO 340
         PIVMX1 = PIVOT
         THETA1 = RES/PIVOT
         JHIT1  = J
         HLOW1  = .TRUE.
C
C        TEST FOR BIGGER  THETA2 IF UPPER BOUND IS VIOLATED.
C
  340    IF (JTYPE .EQ. 0) GO TO 400
         RES    = X(J) - BBU(J)
         IF (PTHET2*PIVOT .GT. RES) GO TO 400
         IF (PIVMX2 .GE. PIVOT)     GO TO 400
         PIVMX2 = PIVOT
         THETA2 = RES/PIVOT
         JHIT2  = J
         HLOW2  = .FALSE.
         GO TO 400
C
C        X  IS INCREASING.
C        TEST FOR SMALLER  THETA1 IS UPPER BOUND IS SATISFIED.
C
  350    IF (JTYPE .GT. 0) GO TO 400
         RES = BBU(J) - X(J)
         IF (PTHET1*PIVABS .LT. RES) GO TO 360
         IF (PIVMX1 .GE. PIVABS)     GO TO 360
         PIVMX1 = PIVABS
         THETA1 = RES/PIVABS
         JHIT1  = J
         HLOW1  = .FALSE.
C
C        TEST FOR BIGGER  THETA2 IF LOWER BOUND IS VIOLATED.
C
  360    IF (JTYPE .EQ. 0) GO TO 400
         RES = BBL(J) - X(J)
         IF (PTHET2*PIVABS .GT. RES) GO TO 400
         IF (PIVMX2 .GE. PIVABS)     GO TO 400
         PIVMX2 = PIVABS
         THETA2 = RES/PIVABS
         JHIT2  = J
         HLOW2  = .TRUE.
  400 CONTINUE
C
C  ---------------------------------------------------------------------
C  IF FEASIBLE, ONLY THETA1 WILL HAVE BEEN SET.
C  IF INFEASIBLE, SET  THETA = MIN( THETA1, THETA2 ).
C  ---------------------------------------------------------------------
      THETA  = THETA1
      JP     = JHIT1
      HITLOW = HLOW1
      IF (JHIT2 .EQ. 0)       GO TO 900
      IF (THETA1 .LE. THETA2) GO TO 900
      THETA  = THETA2
      JP     = JHIT2
      HITLOW = HLOW2
  900 RETURN
C
C     END OF M5CHZR
      END
      SUBROUTINE M5FRMC( N,NB,NN,NN0,NNB,NS,MS,MAXS,
     *                   FMERIT,TOLX,XNORM,
     *                   BL,BU,BBL,BBU,HRTYPE,HS,KB,
     *                   GRD2,X,XN,Z,NWCORE )
C
      IMPLICIT           REAL*8(A-H,O-Z)
      INTEGER*2          HRTYPE(MS),HS(NB)
      INTEGER            KB(MS)
      DOUBLE PRECISION   BL(NB),BU(NB),BBL(MS),BBU(MS)
      DOUBLE PRECISION   GRD2(MS),X(MS),XN(NN0),Z(NWCORE)
C     ------------------------------------------------------------------
      COMMON    /M1EPS / EPS,EPS0,EPS1,EPS2,EPS3,EPS4,EPS5,PLINFY
      COMMON    /M1FILE/ IREAD,IPRINT,ISUMM
      COMMON    /M2FILE/ IBACK,IDUMP,ILOAD,IMPS,INEWB,INSRT,
     *                   IOLDB,IPNCH,IPROB,ISCR,ISOLN,ISPECS,IREPRT
      COMMON    /M5LOBJ/ SINF,WTOBJ,MINIMZ,NINF,IOBJ
      COMMON    /M5LOG1/ IDEBUG,IERR,LPRINT
      COMMON    /M5LP1 / ITN,ITNLIM,NPHS,KMODLU,KMODPI
      COMMON    /M5LP2 / INVRQ,INVITN,INVMOD
      COMMON    /M5PRC / NPARPR,NMULPR,KPRC,NEWSB
      COMMON    /M7LEN / FOBJ  ,FOBJ2 ,NNOBJ ,NNOBJ0
      COMMON    /M7LOC / LGOBJ ,LGOBJ2
      COMMON    /M8LEN / NJAC  ,NNCON ,NNCON0,NNJAC
      COMMON    /M8LOC / LFCON ,LFCON2,LFDIF ,LFDIF2,LFOLD ,
     *                   LBLSLK,LBUSLK,LXLAM ,LRHS  ,
     *                   LGCON ,LGCON2,LXDIF ,LXOLD
      COMMON    /M8AL1 / PENPAR,ROWTOL,NCOM,NDEN,NLAG,NMAJOR,NMINOR
      COMMON    /M8DIFF/ DIFINT(2),GDUMMY,LDERIV,LVLDIF
      COMMON    /M8FUNC/ NFCON(4),NFOBJ(4),NPROB,NSTAT1,NSTAT2
      LOGICAL            GRDCON,GRDOBJ
C     ------------------------------------------------------------------
C     M5FRMC  SETS UP A VECTOR IN  GRD2  TO BE USED TO COMPUTE  PI.
C     IT ALSO DEFINES  HRTYPE  TO BE USED IN  M5CHZR.
C     AFTER  M2BFAC,  OR AT A NEWLY FEASIBLE POINT, THE MERIT FUNCTION
C     IS EVALUATED.
C     ------------------------------------------------------------------
C
      XNORM  = DASUM ( MS,X,1 )
      T      = MS
      XNORM  = (XNORM + EPS4) / DSQRT(T)
      CALL DZERO ( MS,GRD2 )
      IF (IOBJ .NE. 0) GRD2(IOBJ) = - MINIMZ
      IF (NINF .EQ. 0  .AND.  INVITN .GT. 0) RETURN
C
C
C     THE PREVIOUS ITERATION WAS INFEASIBLE, OR ELSE
C     THE BASIS HAS JUST BEEN REFACTORIZED.
C     FIND THE CURRENT NUMBER AND SUM OF INFEASIBILITIES.
C
      ZERO   = 0.0
      ONE    = 1.0
      NINF0  = NINF
      NUMINF = 0
      SUMINF = ZERO
C
      DO 100 J = 1, MS
         HRTYPE(J) = 0
         XJ        = X(J)
         RES       = BBL(J) - XJ
         IF (RES .LE. TOLX) GO TO 50
         GRD2(J)   = - ONE
         HRTYPE(J) = - 1
         GO TO 60
C
   50    RES       = XJ - BBU(J)
         IF (RES .LE. TOLX) GO TO 100
         GRD2(J)   = ONE
         HRTYPE(J) = 1
C
   60    NUMINF    = NUMINF + 1
         SUMINF    = SUMINF + RES
  100 CONTINUE
C
      SINF   = SUMINF
      NINF   = NUMINF
      IF (NUMINF .EQ. 0) GO TO 200
C
C     ---------------------------------------------
C     INFEASIBLE
C     ---------------------------------------------
C
C     IF FIRST ITERATION, SET  NPHS.
C
      IF (ITN .GT. 0) GO TO 150
      NPHS   = 1
      IF (NS .EQ. 0) GO TO 150
      IF (NS .EQ. MAXS  .OR.  NMULPR .GT. 1) NPHS = 4
      IF (IOLDB + INSRT + ILOAD .GT. 0) NPHS = 4
C
C     SET  GRD2(IOBJ)  TO ALLOW FOR A COMPOSITE OBJECTIVE.
C
  150 IF (NPHS .EQ. 2) NPHS = 1
      KMODPI = 1
      FMERIT = SINF
      FOBJ   = ZERO
      IF (IOBJ .NE. 0) GRD2(IOBJ) = - MINIMZ * WTOBJ
C
C     PRINT SOMETHING IF BASIS HAS JUST BEEN REFACTORIZED.
C
      IF (INVITN .GT. 0) RETURN
      WRITE(IPRINT, 1010) ITN,NINF,SINF
      IF (ISUMM .GT. 0) WRITE(ISUMM, 3000) ITN,SINF,NINF
      RETURN
C
C     ---------------------------------------------
C     FEASIBLE.
C     ---------------------------------------------
C
C     IF FIRST ITERATION, SET  NPHS.
C
  200 IF (ITN .GT. 0) GO TO 210
      NPHS   = 2
      IF (NS .EQ. 0) GO TO 220
      IF (NS .EQ. MAXS  .OR.  NMULPR .GT. 1) NPHS = 4
      IF (IOLDB + INSRT + ILOAD .GT. 0) GO TO 220
      GO TO 250
C
C     RESET  NPHS  IF THE PREVIOUS ITN WAS INFEASIBLE.
C
  210 IF (NINF0 .EQ. 0) GO TO 250
      IF (NPHS  .GT. 1) GO TO 220
      NPHS   = 2
      IF (NNB .GT. 0) NPHS = 3
      IF (NNB .GT. 0  .AND.  NS .GT. 0) NPHS = 4
      GO TO 250
C
  220 NPHS   = 2
      IF (NNB .GT. 0) NPHS = 3
      IF (NS  .GT. 0) NPHS = 4
C
C
C     SET UP THE FEASIBLE OBJECTIVE VALUE.
C
  250 KMODPI = 1
      FLIN   = ZERO
      IF (IOBJ .NE. 0) FLIN = - X(IOBJ)
      FMERIT = MINIMZ * FLIN
      WTOBJ  = ZERO
C
C     SET NONBASIC NONLINEAR VARIABLES AT THEIR BOUNDS.
C
      IF (NN .LE. 0) GO TO 300
      BPLUS  = 0.1*PLINFY
      DO 260 J = 1, NN
         IF (HS(J) .GT. 1) GO TO 260
         B = BL(J)
         IF (HS(J) .EQ. 1) B = BU(J)
         IF (DABS(B) .GE. BPLUS) B = 0.0
         XN(J) = B
  260 CONTINUE
C
      GRDCON = NNCON .EQ. 0  .OR.  LDERIV .GE. 2  .OR.  NLAG   .EQ. 0
      GRDOBJ = NNOBJ .EQ. 0  .OR.  LDERIV .EQ. 1  .OR.  LDERIV .EQ. 3
      IF (.NOT. GRDCON) CALL M6DMMY( NJAC ,Z(LGCON) )
      IF (.NOT. GRDOBJ) CALL M6DMMY( NNOBJ,Z(LGOBJ) )
      CALL MERFUN( 1,MS,FMERIT,X,Z,NWCORE )
      IF (IERR .NE. 0) RETURN
C
  300 OBJ    = MINIMZ * FMERIT
      OBJTRU = FLIN + FOBJ
      IF (NINF0 .GT. 0) WRITE(IPRINT, 1000)
      IF (NNCON .EQ. 0) WRITE(IPRINT, 1020) ITN,OBJ
      IF (NNCON .GT. 0) WRITE(IPRINT, 1030) ITN,OBJTRU,OBJ
      IF (NINF0 .GT. 0) WRITE(IPRINT, 1000)
      IF (ISUMM .LE. 0) RETURN
      IF (NN .EQ. 0) WRITE(ISUMM, 3100) ITN,OBJ
      IF (NN .GT. 0) WRITE(ISUMM, 3200) ITN,OBJ,NFOBJ(1),NFCON(1),NS
      RETURN
C
 1000 FORMAT(' ')
 1010 FORMAT(' ITN', I5, ' -- INFEASIBLE.  NUM =', I5,
     *   '   SUM =', 1PE18.9)
 1020 FORMAT(' ITN', I5, ' -- FEASIBLE SOLUTION.  OBJECTIVE =',
     *   1PE18.9)
 1030 FORMAT(' ITN', I5, ' -- FEASIBLE SUBPROBLEM.  TRUE OBJ =',
     *   1PE17.9, 4X, ' AUGLAG OBJ =', 1PE17.9)
 3000 FORMAT(/ ' ITN', I7, '  SINF=', 1PE16.9, '  NINF=', I7)
 3100 FORMAT(/ ' ITN', I7, '  OBJ=',  1PE17.9)
 3200 FORMAT(/ ' ITN', I7, '  OBJ=',  1PE17.9, '  FUNS=', 2I7,
     *   '  SB=', I5)
C     END OF M5FRMC
      END
      SUBROUTINE M5LOG ( M,MAXS,MBS,N,NB,NN,NN0,NS,NX,FMERIT,
     *                   NE,NKA,A,HA,KA,
     *                   BL,BU,HS,KB,X,XN,Y,Z,NWCORE )
      IMPLICIT           REAL*8(A-H,O-Z)
      DOUBLE PRECISION   A(NE),BL(NB),BU(NB)
      INTEGER*2          HA(NE),HS(NB)
      INTEGER            KA(NKA),KB(MBS)
      DOUBLE PRECISION   X(NX),XN(NN0),Y(NX),Z(NWCORE)
      LOGICAL            CONV
      COMMON    /M1FILE/ IREAD,IPRINT,ISUMM
      COMMON    /M2LU3 / LENL,LENU,NCP,LROW,LCOL
      COMMON    /M5FREQ/ KCHK,KINV,KSAV,KLOG,KSUMM,I1FREQ,I2FREQ,MSOLN
      COMMON    /M5LOBJ/ SINF,WTOBJ,MINIMZ,NINF,IOBJ
      COMMON    /M5LOG1/ IDEBUG,IERR,LPRINT
      COMMON    /M5LOG2/ IHEAD,JQ1,JQ2,JR1,JR2
      COMMON    /M5LOG3/ DJQ,THETA,PIVOT,COND,NONOPT,JP,JQ,MODR1,MODR2
      COMMON    /M5LP1 / ITN,ITNLIM,NPHS,KMODLU,KMODPI
      COMMON    /M5LP2 / INVRQ,INVITN,INVMOD
      COMMON    /M5PRC / NPARPR,NMULPR,KPRC,NEWSB
      COMMON    /M7CONV/ ETASH,ETARG,LVLTOL,NFAIL,CONV(4)
      COMMON    /M7PHES/ RGMIN1,RGNRM1,RGNRM2,JZ1,JZ2,LABZ,NFULLZ,MFULLZ
      COMMON    /M8FUNC/ NFCON(4),NFOBJ(4),NPROB,NSTAT1,NSTAT2
      LOGICAL            SHORT
      INTEGER            LABEL(2)
      DATA               LABEL(1)/' '/, LABEL(2)/'R'/
C
C     M5LOG   PRINTS THE ITERATION LOG.
C     NORMALLY THE ONLY PARAMETERS USED ARE  NN  AND  NS.
C     THE OTHERS ARE THERE TO ALLOW MONITORING OF VARIOUS
C     ITEMS FOR EXPERIMENTAL PURPOSES.
C     MN  = M + MAXS   .GE.   M + NS
C     NX  = MAX0(MN, NN)
C     THE ARRAY  Y(NX)  IS AVAILABLE FOR WORKSPACE.
C
      MS     = M + NS
      OBJ    = SINF
      IF (NINF .EQ. 0) OBJ = MINIMZ*FMERIT
      IF (INVITN.LE.1) IHEAD = 0
      ILOG   = MOD( ITN, KLOG )
      IF (ILOG .NE. 0) GO TO 800
C
C     PRINT HEADING IF NONE SO FAR.
C
      IHEAD  = IHEAD + 1
      IF (IHEAD .NE. 1) GO TO 600
      SHORT  = NN.EQ.0  .AND.  NS.EQ.0  .AND.  NPHS.LE.2
      IF (      SHORT) WRITE(IPRINT, 1000)
      IF (.NOT. SHORT) WRITE(IPRINT, 1005)
C
C     PRINT LP-TYPE LINE IF LP AND NO SUPERBASICS
C
  600 ITER   = MOD( ITN, 100000 )
      L      = LABEL(LABZ)
      SHORT  = NS.EQ.0  .AND.  NPHS.LE.2
C
      IF (      SHORT) WRITE(IPRINT, 1010)
     *   ITER,L,NPHS,KPRC,NONOPT,DJQ,JQ2,JR2,JR1,
     *   THETA,PIVOT,LENL,LENU,NCP,NINF,OBJ
C
      IF (.NOT. SHORT) WRITE(IPRINT, 1010)
     *   ITER,L,NPHS,KPRC,NONOPT,DJQ,JQ2,JR2,JR1,
     *   THETA,PIVOT,LENL,LENU,NCP,NINF,OBJ
     *   ,NFOBJ(1),NFCON(1),NS,MODR1,MODR2,COND,CONV
C
C     SPECIAL OUTPUT IF  HESSIAN DIMENSION  IS LESS THAN THE CURRENT
C     NUMBER OF SUPERBASICS, AND IF VARIABLE  JZ2  HAS JUST BEEN
C     MOVED FROM SET Z2  INTO SET  Z1  IN PLACE OF VARIABLE  JZ1.
C
      IF (JZ2 .GT. 0) WRITE(IPRINT, 1100) RGNRM2,JZ2,JZ1,RGMIN1
C
C     ---------------
C     DEBUG OUTPUT.
C     ---------------
      IF (IDEBUG .NE. 100) GO TO 800
      WRITE(IPRINT, 2000) (KB(K),X(K), K=1,MS)
C
C     ---------------
C     SUMMARY OUTPUT.
C     ---------------
  800 ILOG   = MOD( ITN, KSUMM )
      IF (ILOG  .NE. 0) GO TO 900
      IF (ISUMM .LE. 0) GO TO 900
      IF (NINF  .EQ. 0) GO TO 820
      WRITE(ISUMM, 3000) ITN,SINF,NINF
      GO TO 900
C
  820 IF (NN .EQ. 0) WRITE(ISUMM, 3100) ITN,OBJ
      IF (NN .GT. 0) WRITE(ISUMM, 3200) ITN,OBJ,NFOBJ(1),NFCON(1),NS
C
C     EXIT.
C
  900 RETURN
C
 1000 FORMAT(/ '   ITN PH PP NOPT  DJ,RG  +SBS -SBS  -BS',
     *   '  STEP    PIVOT       L     U NCP NINF  SINF,OBJECTIVE')
 1005 FORMAT(/ '   ITN PH PP NOPT  DJ,RG  +SBS -SBS  -BS',
     *   '  STEP    PIVOT       L     U NCP NINF  SINF,OBJECTIVE',
     *   '  NOBJ  NCON  NSB HMOD H-CONDN CONV')
 1010 FORMAT(I6, 1X, A1, I1, I3, I4, 1PE9.1, 3I5,
     *   1PE8.1, 1PE9.1, 2I6, I4, I5, 1PE16.8,
     *   2I6, I5, 1X, 2I2, 1PE8.1, 1X, 4L1)
 1100 FORMAT(16X, 1PE9.1, 2I5, 1PE9.1)
 2000 FORMAT(/ ' BS AND SB VALUES...' / (5(I7, G17.8)))
 3000 FORMAT(' ITN', I7, '  SINF=', 1PE16.9, '  NINF=', I7)
 3100 FORMAT(' ITN', I7, '  OBJ=',  1PE17.9)
 3200 FORMAT(' ITN', I7, '  OBJ=',  1PE17.9, '  FUNS=', 2I7,
     *   '  SB=', I5)
C     END OF M5LOG
      END
      SUBROUTINE M5LPIT( M,M1,MBS,N,NB,NN,NNB,NS,
     *                   HRTYPE,HS,KB,BBL,BBU,X,Y,Y2,Z,NWCORE )
      IMPLICIT           REAL*8(A-H,O-Z)
      INTEGER*2          HRTYPE(M1),HS(NB)
      INTEGER            KB(M1)
      DOUBLE PRECISION   BBL(MBS),BBU(MBS)
      DOUBLE PRECISION   X(MBS),Y(M1),Y2(M),Z(NWCORE)
      COMMON    /M1EPS / EPS,EPS0,EPS1,EPS2,EPS3,EPS4,EPS5,PLINFY
      COMMON    /M1FILE/ IREAD,IPRINT,ISUMM
      COMMON    /M5LOBJ/ SINF,WTOBJ,MINIMZ,NINF,IOBJ
      COMMON    /M5LOG1/ IDEBUG,IERR,LPRINT
      COMMON    /M5LOG2/ IHEAD,JQ1,JQ2,JR1,JR2
      COMMON    /M5LOG3/ DJQ,THETA,PIVOT,COND,NONOPT,JP,JQ,MODR1,MODR2
      COMMON    /M5LP1 / ITN,ITNLIM,NPHS,KMODLU,KMODPI
      COMMON    /M5LP2 / INVRQ,INVITN,INVMOD
      COMMON    /M5TOLS/ TOLDJ(3),TOLX,TOLPIV,TOLROW,ROWERR,XNORM
      LOGICAL            ATBND,HITLOW
C
C     NORMAL SIMPLEX ITERATION (PHASE 1 OR 2)
C
      JQ2    = JQ
      JR2    = JQ
      ATBND  = DJQ .GT. 0.0
C
C     UNPACK COLUMN JQ INTO  Y2  AND SOLVE  B*Y = Y2.
C     Y2  WILL BE ALTERED, AND IS NEEDED LATER TO MODIFY L AND U.
C
      CALL M2UNPK( JQ,Y2,M,Z,NWCORE )
      CALL M2BSOL( 2,M,Y2,Y,Z,NWCORE )
C
C     SELECT VARIABLE TO BE DROPPED FROM B.
C     M5CHZR  USES  M+1-TH ELEMENT OF HRTYPE, BBL, BBU, X.
C
      JM1   = HRTYPE(M1)
      BLM1  = BBL(M1)
      BUM1  = BBU(M1)
      XM1   = X(M1)
      MS1        = M + NS + 1
      HRTYPE(M1) = 0
      BBL(M1)    = BBL(MS1)
      BBU(M1)    = BBU(MS1)
      X(M1)      = X(MS1)
      Y(M1)      = -1.0
      THETA      = PLINFY
C
      CALL M5CHZR( M1,HRTYPE,BBL,BBU,X,Y,
     *             ATBND,TOLPIV,TOLX,
     *             HITLOW,JP,THETA )
      IF (JP.EQ.0 .OR. THETA.GE.PLINFY) GO TO 800
      IF (JP.EQ.M1) GO TO 250
C
C     VARIABLE  JQ  REPLACES JP-TH VARIABLE OF  B.
C
      JR     = KB(JP)
      JQ1    = JQ
      JR1    = JR
      KB(JP) = JQ
      HS(JQ) = 3
      BBL(JP)= BBL(M1)
      BBU(JP)= BBU(M1)
      IF (      HITLOW) HS(JR) = 0
      IF (.NOT. HITLOW) HS(JR) = 1
      IF (JQ.LE.NN) NNB = NNB + 1
      IF (JR.LE.NN) NNB = NNB - 1
      PIVOT = Y(JP)
      IF (THETA.GT.EPS0) GO TO 300
      THETA = 0.0
      GO TO 350
C
C     VARIABLE JQ REACHES ITS OPPOSITE BOUND
C
  250 PIVOT  = 0.0
      HS(JQ) = 1 - HS(JQ)
      KMODLU = 0
      IF (NINF.EQ.0) KMODPI = 0
C
C     UPDATE  X
C
  300 DALFA = - THETA
      IF (ATBND) DALFA = THETA
      CALL DAXPY ( M1,DALFA,Y,1,X,1 )
  350 X(JP) = X(M1)
      GO TO 900
C
C     SOLUTION IS UNBOUNDED
C
  800 WRITE(IPRINT,1010) JQ
      IERR = 2
C
C     EXIT -- RESTORE  HRTYPE(M1)  ETC.
C
  900 HRTYPE(M1) = JM1
      BBL(M1)    = BLM1
      BBU(M1)    = BUM1
      X(M1)      = XM1
      RETURN
C
 1010 FORMAT(' INCOMING VARIABLE WAS', I5)
C     END OF M5LPIT
      END
      SUBROUTINE M5PRIC( M,MBS,N,NB,NN,NN0,NS,MAXR,MAXS,
     *                   NE,NKA,A,HA,KA,
     *                   HS,KB,BL,BU,BBL,BBU,
     *                   GMERIT,PI,RG,X,XN,Z,NWCORE )
C
      IMPLICIT           REAL*8(A-H,O-Z)
      INTEGER*2          HA(NE),HS(NB)
      INTEGER            KA(NKA),KB(MBS)
      DOUBLE PRECISION   A(NE),BL(NB),BU(NB),BBL(MBS),BBU(MBS)
      DOUBLE PRECISION   GMERIT(NN0),PI(M),RG(MAXS),X(MBS)
      DOUBLE PRECISION   XN(NN0),Z(NWCORE)
      COMMON    /M1EPS / EPS,EPS0,EPS1,EPS2,EPS3,EPS4,EPS5,PLINFY
      COMMON    /M1FILE/ IREAD,IPRINT,ISUMM
      COMMON    /M5LOBJ/ SINF,WTOBJ,MINIMZ,NINF,IOBJ
      COMMON    /M5LOG1/ IDEBUG,IERR,LPRINT
      COMMON    /M5LOG3/ DJQ,THETA,PIVOT,COND,NONOPT,JP,JQ,MODR1,MODR2
      COMMON    /M5LP1 / ITN,ITNLIM,NPHS,KMODLU,KMODPI
      COMMON    /M5PRC / NPARPR,NMULPR,KPRC,NEWSB
      COMMON    /M5TOLS/ TOLDJ(3),TOLX,TOLPIV,TOLROW,ROWERR,XNORM
      COMMON    /M7TOLS/ XTOL(2),FTOL(2),GTOL(2),PINORM,RGNORM,TOLRG
      LOGICAL            INFSBL
C  ---------------------------------------------------------------------
C
C     M5PRIC  SELECTS A NONBASIC VARIABLE TO ENTER THE BASIS,
C     USING THE REDUCED GRADIENTS  DJ = GMERIT(J) - PI(T)*A(J).
C
C     THIS VERSION DOES PARTIAL PRICING ON BOTH STRUCTURALS AND SLACKS.
C     ALSO, MULTIPLE PRICING NO LONGER CANCELS PARTIAL PRICING.
C     DYNAMIC TOLERANCES ARE USED IF PARTIAL PRICING IS IN EFFECT.
C
C     PARTIAL PRICING HERE MEANS SECTIONAL PRICING, BECAUSE THE
C     COLUMNS OF  A  AND  I  ARE BOTH SLICED UP INTO NPARPR SECTIONS
C     OF EQUAL SIZE.  (THE LAST SECTION OF EACH MAY BE A LITTLE BIGGER,
C     SINCE NPARPR IS UNLIKELY TO DIVIDE EVENLY INTO  N  OR  M.)
C
C     INPUT    GMERIT = GRADIENT FOR NONLINEAR VARIABLES.
C              PI     = PRICING VECTOR.
C              KPRC   = THE NO. OF THE SECTION WHERE  M5PRIC  LAST FOUND
C                       A USEFUL DJ.
C                       (KPRC = 0 AT THE START OF EACH MAJOR ITN)
C
C     OUTPUT   KPRC   = THE LAST SECTION SCANNED.
C              NONOPT = THE NO. OF USEFUL DJ-S FOUND IN THAT SECTION.
C              JQ     = BEST COLUMN FOUND.
C              DJQ    = BEST DJ.
C              NEWSB  = NO. OF NEW SUPERBASICS SELECTED.
C
C     IF MULTIPLE PRICE IS IN EFFECT,
C              KB(NS+1), ... KB(NS+NEWSB) = SUPERBASICS SELECTED,
C              RG(NS+1), ... RG(NS+NEWSB) = THEIR REDUCED GRADIENTS.
C
C     IN THE CODE BELOW,
C     THE NEXT SECTION OF  A  CONTAINS NPR1 STRUCTURALS (J1+1 THRU K1),
C     THE NEXT SECTION OF  I  CONTAINS NPR2 SLACKS      (J2+1 THRU K2).
C     IF  NPARPR  IS RATHER LARGE, EITHER NPR1 OR NPR2 COULD BE ZERO,
C     BUT NOT BOTH.
C
C
C     THIS VERSION WRITTEN SEPTEMBER 1981.
C  ---------------------------------------------------------------------
C
      INFSBL = NINF.GT.0
      ZERO   = 0.0
      BPLUS  = 0.1*PLINFY
      BMINUS = - BPLUS
      DJMAX  = BMINUS
      DJQ    = ZERO
      JQ     = 0
      NONOPT = 0
      MS     = M + NS
      NCAN   = 0
      NEWSB  = 1
      NPARP  = NPARPR
      NPRC   = 0
      MAXMP  = MAXS - NS
      MAXMP  = MIN0( NMULPR, MAXMP )
C
C     SEE IF WE PARTITION ONLY THE LINEAR COLUMNS
C
      J0     = 0
      IF (NPHS .LE. 2  .AND.  NS .GT. 0) J0 = NN
      NCOL   = N - J0
      NPR1   = NCOL/NPARP
      NPR2   = M   /NPARP
      IF (MAX0(NPR1,NPR2) .LE. 0) NPARP = 1
C
C     SET THE TOLERANCE FOR A SIGNIFICANT DJ
C
      LVLDJ  = 2
      IF (INFSBL) LVLDJ = 1
      IF (NPARP .EQ. 1) LVLDJ = 3
      TOLD   = TOLDJ(LVLDJ)*PINORM
      TOLMIN = TOLDJ(3)    *PINORM
C
C
C     SET POINTERS TO NEXT PARTITION OF  A  AND  I
C
  100 NPRC = NPRC + 1
      KPRC = KPRC + 1
      IF (KPRC .GT. NPARP) KPRC = 1
      NPR1 = NCOL/NPARP
      J1   = J0 + (KPRC - 1)*NPR1
      K1   = J1 + NPR1
      IF (KPRC .EQ. NPARP) K1 = N
      NPR1 = MAX0( 0, K1-J1 )
C
      NPR2 = M/NPARP
      J2   = N + (KPRC - 1)*NPR2
      K2   = J2 + NPR2
      IF (KPRC .EQ. NPARP) K2 = NB
      NPR2 = MAX0( 0, K2-J2 )
C
      NP   = NPR1 + NPR2
      J    = J1
      JSLK = NPR1 + 1
C
C     ----------------------------------------
C     PRICE THE KPRC-TH SECTION OF STRUCTURALS
C     AND   THE KPRC-TH SECTION OF SLACKS.
C     ----------------------------------------
C
C     COMPUTE THE REDUCED COSTS  DJ.
C
      DO 700 JJ = 1, NP
         IF (JJ .EQ. JSLK) J = J2
         J  = J + 1
         JS = HS(J)
         IF (JS.GT.1) GO TO 700
         B1 = BL(J)
         B2 = BU(J)
         IF (B1.EQ.B2) GO TO 700
C
C        DJ IS EASY FOR SLACKS
         IF (J.LE.N) GO TO 350
         DJ = - PI(J - N)
         GO TO 410
C
  350    DJ = ZERO
         K1 = KA(J)
         K2 = KA(J+1) - 1
C
C*****   THE FOLLOWING LOOP COULD CONCEIVABLY BE CODED SPECIALLY.
C*****   IT RUNS DOWN THE J-TH COLUMN OF THE MATRIX  A.
C*****   THERE WILL SELDOM BE MORE THAN 5 OR 10 ENTRIES PER COLUMN.
C
         DO 400 I = K1, K2
            IR = HA(I)
C-I         IR = IABS(IR)
            DJ = DJ - PI(IR)*A(I)
  400    CONTINUE
C
  410    IF (INFSBL ) GO TO 420
         IF (J.LE.NN) DJ = GMERIT(J) + DJ
  420    IF (JS.NE.0) GO TO 440
C
C        X(J) IS PROBABLY NONBASIC AT ITS LOWER BOUND
         IF (B1.LE.BMINUS) GO TO 460
         D = - DJ
         GO TO 500
C
C        X(J) IS PROBABLY NONBASIC AT ITS UPPER BOUND
  440    IF (B2.GE.BPLUS) GO TO 460
         D = DJ
         GO TO 500
C
C        X(J) IS A NON-BASIC FREE VARIABLE (CURRENTLY ZERO)
  460    D = DABS(DJ)
C
C        SEE IF THIS WAS THE BIGGEST DJ
C
  500    IF (DJMAX.GE.D) GO TO 505
         DJMAX = D
         DJQ   = DJ
         JQ    = J
         B1Q   = B1
         B2Q   = B2
         KPSAV = KPRC
C
C        SEE IF THIS DJ IS SIGNIFICANT
C
  505    IF (D .GT. TOLD) NONOPT = NONOPT + 1
C
C        IF MULTIPLE PRICING, BUILD LIST OF CANDIDATES
C
         IF (MAXMP .LE. 1 ) GO TO 700
         IF (D .LE. TOLMIN) GO TO 700
         IF (NCAN  .EQ. 0 ) GO TO 520
C
C        SEARCH LIST BACKWARDS, STARTING WITH SMALLEST G VALUES
C
         DO 510 II = 1, NCAN
            I   = 1 + NCAN - II
            NSI = NS + I
            MSI = MS + I
C           SEE IF THIS LIST ELEMENT WILL STAY PUT
            IF (D .LE. DABS(RG(NSI))) GO TO 530
C           MAKE SURE WE HAVE SPACE TO MOVE IT
            IF (I .GE. MAXMP) GO TO 510
C           THIS ELEMENT LOST THE CONTEST BUT IS STAYING IN THE LIST
            RG(NSI + 1) = RG(NSI)
            KB(MSI + 1) = KB(MSI)
  510    CONTINUE
C
C        THIS IS THE BIGGEST D SO FAR
C
  520    I = 0
C
C        IF ROOM, PUT THE NEW CANDIDATE INTO THE LIST
C
  530    IF (I .GE. MAXMP) GO TO 700
         I = I + 1
         RG(NS + I) = DJ
         KB(MS + I) = J
         IF (NCAN .LT. MAXMP) NCAN = NCAN + 1
  700 CONTINUE
C     ----------------------------------------
C
C
C     EXIT IF SOMETHING SIGNIFICANT WAS FOUND.
C     OTHERWISE PRICE THE NEXT SECTION, IF ANY SECTIONS REMAIN.
C
      IF (NONOPT .GT. 0) GO TO 950
      IF (NPRC .LT. NPARP) GO TO 100
C
C     ALL PARTITIONS SCANNED AND NOTHING FOUND.
C     CHECK TOLDJ.
C
      IF (JQ    .EQ. 0)      GO TO 990
      IF (NPARP .EQ. 1)      GO TO 990
      IF (DJMAX .LE. TOLMIN) GO TO 990
      NONOPT = 1
      KPRC   = KPSAV
      D      = 0.1*DJMAX/PINORM
      IF (D .LT. TOLDJ(3)) D = TOLDJ(3)
      TOLDJ(LVLDJ) = D
      WRITE(IPRINT, 1010) D,PINORM
      GO TO 980
C
C     FINISH UP MULTIPLE PRICING.
C     THE NEW DJ-S ARE NOW IN DESCENDING ORDER, WITH THE BIGGEST
C     IN RG(NS+1).  TRUNCATE THE LIST IF ANY ARE MUCH SMALLER.
C
  950 IF (MAXMP .LE. 1) GO TO 980
      IF (NCAN  .LE. 1) GO TO 980
      TOLD = 0.1*DJMAX
      IF (TOLD .LT. TOLMIN) TOLD = TOLMIN
      DO 960 J = 2, NCAN
         IF (DABS(RG(NS + J)) .LT. TOLD) GO TO 980
         NEWSB = NEWSB + 1
  960 CONTINUE
      IF (NEWSB .GT. 1) NPHS = 3
C
  980 MS1 = MS + 1
      BBL(MS1) = B1Q
      BBU(MS1) = B2Q
      XJQ      = B1Q
      IF (     DJQ  .GT. ZERO ) XJQ = B2Q
      IF (DABS(XJQ) .GT. BPLUS) XJQ = ZERO
      X(MS1)   = XJQ
C
C     EXIT
C
  990 RETURN
C
 1010 FORMAT(' TOLDJ REDUCED TO', 1PE13.3, '    NORM PI =', 1PE13.3)
C     END OF M5PRIC
      END
      SUBROUTINE M5SETP( MODE,M,RHS,PI,Z,NWCORE )
      IMPLICIT           REAL*8(A-H,O-Z)
      DOUBLE PRECISION   PI(M),RHS(M),Z(NWCORE)
      COMMON    /M7TOLS/ XTOL(2),FTOL(2),GTOL(2),PINORM,RGNORM,TOLRG
C
C     SOLVE  B(T)*PI = RHS.    BEWARE -- RHS IS ALTERED BY M2BSOL.
C
      CALL M2BSOL( 3,M,RHS,PI,Z,NWCORE )
C
      IF (MODE .EQ. 0) RETURN
      PINORM = M
      PINORM = DASUM( M,PI,1 ) / DSQRT(PINORM)
      IF (PINORM .LT. 1.0) PINORM = 1.0
      RETURN
C     END OF M5SETP
      END
      SUBROUTINE M5SETX( MODEX,M,MS,NS,W,X,Y,Y2,Z,NWCORE )
      IMPLICIT           REAL*8(A-H,O-Z)
      DOUBLE PRECISION   W(M),X(MS),Y(MS),Y2(M),Z(NWCORE)
      COMMON    /M1EPS / EPS,EPS0,EPS1,EPS2,EPS3,EPS4,EPS5,PLINFY
      COMMON    /M1FILE/ IREAD,IPRINT,ISUMM
      COMMON    /M5LOG1/ IDEBUG,IERR,LPRINT
      COMMON    /M5LP1 / ITN,ITNLIM,NPHS,KMODLU,KMODPI
      COMMON    /M5TOLS/ TOLDJ(3),TOLX,TOLPIV,TOLROW,ROWERR,XNORM
      COMMON    /M8LEN / NJAC  ,NNCON ,NNCON0,NNJAC
      COMMON    /M8LOC / LFCON ,LFCON2,LFDIF ,LFDIF2,LFOLD ,
     *                   LBLSLK,LBUSLK,LXLAM ,LRHS  ,
     *                   LGCON ,LGCON2,LXDIF ,LXOLD
      LOGICAL            PRNT
C
C     IF MODEX = 1          RESET X, REFINE AND GET ROW ERROR.
C     IF MODEX = 2 OR MORE,                     GET ROW ERROR.
C
      M1     = M + 1
      TOLZ   = EPS0
      ZERO   = 0.0
      ONE    = 1.0
      ROOTMS = MS
      ROOTMS = DSQRT(ROOTMS)
      DXNORM = ZERO
C
C     COMPUTE  Y  =  RHS  -  (NONBASIC A) * (APPROPRIATE BOUNDS).
C     X  IS NOT USED BY  APROD  IN THIS CALL.
C
      CALL DZERO ( M,Y )
      IF (NNCON .GT. 0) CALL DCOPY ( NNCON,Z(LRHS),1,Y,1 )
      CALL M2APRD( 5,X,MS,Y,M,Z,NWCORE )
C
C     SET  Y  =  Y - S*XS
C
      IF (NS .GT. 0) CALL M2APRD( 2,X(M1),NS,Y,M,Z,NWCORE )
      IF (MODEX .NE. 1) GO TO 200
C
C     COMPUTE BASIC X FROM  B*X = Y.
C     USE  W  AS THE RHS TO AVOID OVERWRITING  Y.
C
      CALL DCOPY ( M,Y,1,W,1 )
      CALL M2BSOL( 2,M,W,X,Z,NWCORE )
C
C     SET  W  =  W - B*X   (RESIDUALS FOR UNREFINED X).
C
      CALL DCOPY ( M,Y,1,W,1 )
      CALL M2APRD( 1,X,M,W,M,Z,NWCORE )
C
C     SOLVE  B*Y2 = W  FOR CORRECTION TO X
C
      CALL M2BSOL( 2,M,W,Y2,Z,NWCORE )
      CALL DAXPY ( M,ONE,Y2,1,X,1 )
      DXNORM = DASUM( M,Y2,1 ) / ROOTMS
C
C     SET  Y  =  Y - B*X   (RESIDUALS FOR FINAL  X).
C
  200 CALL M2APRD( 1,X,M,Y,M,Z,NWCORE )
      XNORM  = DASUM( MS,X,1 ) / ROOTMS
C     THE NEXT LINE ALLOWS FOR THE RARE CASE  X = 0.
      IF (XNORM .LE. EPS4) XNORM = ONE
      CONDB  = DXNORM / (XNORM * EPS)
      CONDB  = DMAX1( CONDB, ONE )
C
C     FIND MAXIMUM ROW RESIDUAL
C
      IR     = IDAMAX( M,Y,1 )
      RMAX   = DABS( Y(IR) )
      ROWERR = RMAX/XNORM
      IF (ROWERR .GT. TOLROW) IERR = 10
C
      PRNT = RMAX.GT.TOLROW .OR. DXNORM.GT.TOLX .OR. IDEBUG.GE.2
      IF (.NOT. PRNT) RETURN
      IF (MODEX .EQ. 1) WRITE(IPRINT, 1100) ITN,RMAX,IR,XNORM,
     *                                      DXNORM,CONDB
      IF (MODEX .GT. 1) WRITE(IPRINT, 1200) ITN,RMAX,IR,XNORM
      RETURN
C
 1100 FORMAT(/ ' ROW CHECK. ITN =', I6,
     *   '   MAX RESIDUAL =', 1PE9.2, '  ON ROW', I5,
     *   '   NORM X =', 1PE9.2,
     *   '   NORM DX =', 1PE9.2, '   COND B =', 1PE9.2)
 1200 FORMAT(/ ' ROW CHECK. ITN =', I6,
     *   '   MAX RESIDUAL =', 1PE9.2, '  ON ROW', I5,
     *   '   NORM X =', 1PE9.2)
C     END OF M5SETX
      END
      SUBROUTINE M5SOLV( NCYCLE,GOTLAM,OBJTRU,
     *                   M,MBS,NX,N,NB,NR,NN,NN0,MAXR,MAXS,NS,NSCL,
     *                   NE,NKA,A,HA,KA,
     *                   HRTYPE,HS,KB,ASCALE,BL,BU,BBL,BBU,
     *                   FMERIT,GMERIT,GMERT2,GRD,GRD2,PI,R,
     *                   RG,RG2,X,XN,Y,Y2,Z,NWCORE )
C
      IMPLICIT           REAL*8(A-H,O-Z)
      LOGICAL            GOTLAM
      INTEGER*2          HA(NE),HRTYPE(MBS),HS(NB)
      INTEGER            KA(NKA),KB(MBS)
      DOUBLE PRECISION   A(NE),ASCALE(NSCL),BL(NB),BU(NB)
      DOUBLE PRECISION   BBL(MBS),BBU(MBS)
      DOUBLE PRECISION   GMERIT(NN0),GMERT2(NN0),GRD(MBS),GRD2(MBS)
      DOUBLE PRECISION   PI(M),R(NR),RG(MAXS),RG2(MAXS)
      DOUBLE PRECISION   X(NX),XN(NN0),Y(NX),Y2(NX),Z(NWCORE)
C     ------------------------------------------------------------------
      LOGICAL            CONV,RESTRT
      COMMON    /M1EPS / EPS,EPS0,EPS1,EPS2,EPS3,EPS4,EPS5,PLINFY
      COMMON    /M1FILE/ IREAD,IPRINT,ISUMM
      COMMON    /M2FILE/ IBACK,IDUMP,ILOAD,IMPS,INEWB,INSRT,
     *                   IOLDB,IPNCH,IPROB,ISCR,ISOLN,ISPECS,IREPRT
      COMMON    /M2LU3 / LENL,LENU,NCP,LROW,LCOL
      COMMON    /M2PARM/ DPARM(30),IPARM(30)
      COMMON    /M3MPS2/ LCNAM1,LRNAM1,LCNAM2,LRNAM2,LXS,LXL,LFREE
      COMMON    /M3MPS3/ AIJTOL,BSTRUC(2),MINMAX,MLST,MER,
     *                   NAME(2),MOBJ(2),MRHS(2),MRNG(2),MBND(2)
      COMMON    /M5FREQ/ KCHK,KINV,KSAV,KLOG,KSUMM,I1FREQ,I2FREQ,MSOLN
      COMMON    /M5LOBJ/ SINF,WTOBJ,MINIMZ,NINF,IOBJ
      COMMON    /M5LOG1/ IDEBUG,IERR,LPRINT
      COMMON    /M5LOG2/ IHEAD,JQ1,JQ2,JR1,JR2
      COMMON    /M5LOG3/ DJQ,THETA,PIVOT,COND,NONOPT,JP,JQ,MODR1,MODR2
      COMMON    /M5LP1 / ITN,ITNLIM,NPHS,KMODLU,KMODPI
      COMMON    /M5LP2 / INVRQ,INVITN,INVMOD
      COMMON    /M5PRC / NPARPR,NMULPR,KPRC,NEWSB
      COMMON    /M5TOLS/ TOLDJ(3),TOLX,TOLPIV,TOLROW,ROWERR,XNORM
      COMMON    /M7LEN / FOBJ  ,FOBJ2 ,NNOBJ ,NNOBJ0
      COMMON    /M7LOC / LGOBJ ,LGOBJ2
      COMMON    /M7CG1 / CGBETA,ITNCG,MSGCG,MODCG,RESTRT
      COMMON    /M7CONV/ ETASH,ETARG,LVLTOL,NFAIL,CONV(4)
      COMMON    /M7PHES/ RGMIN1,RGNRM1,RGNRM2,JZ1,JZ2,LABZ,NFULLZ,MFULLZ
      COMMON    /M7TOLS/ XTOL(2),FTOL(2),GTOL(2),PINORM,RGNORM,TOLRG
      COMMON    /M8LEN / NJAC  ,NNCON ,NNCON0,NNJAC
      COMMON    /M8LOC / LFCON ,LFCON2,LFDIF ,LFDIF2,LFOLD ,
     *                   LBLSLK,LBUSLK,LXLAM ,LRHS  ,
     *                   LGCON ,LGCON2,LXDIF ,LXOLD
      COMMON    /M8AL1 / PENPAR,ROWTOL,NCOM,NDEN,NLAG,NMAJOR,NMINOR
      COMMON    /M8AL2 / RADIUS,RHSMOD,MODPEN,MODRHS
      COMMON    /M8DIFF/ DIFINT(2),GDUMMY,LDERIV,LVLDIF
      COMMON    /M8FUNC/ NFCON(4),NFOBJ(4),NPROB,NSTAT1,NSTAT2
      COMMON    /M8SAVE/ KMAJOR,KMINOR,NSSAVE
      COMMON    /M8VERI/ JVERIF(4),LVERIF(2)
C     ------------------------------------------------------------------
      INTEGER            ISTATE(3)
      LOGICAL            FLYING,FEASBL,INFSBL,JSTFES,LINEAR,NONLIN
      LOGICAL            ENDCHK,VERIFY
      LOGICAL            AUGLAG,CONVGD,OPTSUB
C
C     ------------------------------------------------------------------
C     M5SOLV  SOLVES THE CURRENT PROBLEM.  A BASIS IS ASSUMED TO BE
C     SPECIFIED BY  KB  AND  HS.
C
C     THE FIRST CALL TO  M5SOLV  MUST HAVE  NCYCLE = 1.
C     IF  NCYCLE .GT. 1, WE ASSUME THAT WE ARE OFF TO A FLYING START,
C     USING ALL RELEVANT QUANTITIES FROM THE PREVIOUS CALL.
C
C     ON RETURN, IF  IERR .LT. 10  IT IS SAFE TO SAVE THE FINAL
C     BASIS FILES AND PRINT THE SOLUTION.  OTHERWISE, A FATAL ERROR
C     CONDITION EXISTS AND NUMEROUS ITEMS WILL BE UNDEFINED.
C     THE LAST BASIS MAP SAVED (IF ANY) RETAINS THE ONLY USEFUL
C     INFORMATION.
C     ------------------------------------------------------------------
C
      ZERO   = 0.0
      ONE    = 1.0
      LINEAR = NN .EQ. 0
      NONLIN = .NOT. LINEAR
      FLYING = NCYCLE .GT. 1
      CGBETA = ZERO
      COND   = ZERO
      FOBJ   = ZERO
      FMERIT = ZERO
      FXPREV = ZERO
C
      IERR   = 0
      INFSUB = 0
      ITNCHK = -1
      INVRQ  = 0
      ITN    = 0
      MAJITS = 0
      MODWT  = 0
      MSGCG  = 1
      M1     = M + 1
      NFAIL  = 0
      NFULLZ = 0
      NINV   = 0
      NNB    = 0
      NOMOVE = 0
      NPHS   = 1
      NREDUC = 0
      NSAMEF = 0
      MSAMEF = MAX0( 2*NB, 200 )
      MSAMEF = MIN0( MSAMEF, 1000 )
      NSSAVE = NS
C
      PINORM = ONE
      RGNORM = ZERO
      RGTEST = ZERO
      SINF   = ZERO
      TOLZ   = EPS0
      XNORM  = ZERO
      DO 30 I = 1, 4
         CONV(I) = .FALSE.
   30 CONTINUE
C
C     SAVE JACOBIAN AND RHS FROM MPS FILE.
C
      AUGLAG = NNCON .GT. 0
      ENDCHK = .FALSE.
      OPTSUB = .FALSE.
      IF (AUGLAG) CALL M8AUGL( 1,INFORM,Z,NWCORE )
C
C     SOME THINGS SHOULD NOT BE DONE IF THIS IS A FLYING START
C
      IF (FLYING) GO TO 90
      VERIFY = .TRUE.
      NINF   = 1
      R(1)   = ZERO
      GOTLAM = .FALSE.
C
C     KEEP WATFIV HAPPY
C
      IF (NN .GT. 0) CALL DZERO( NN,GMERT2 )
      HRTYPE(M1) = 0
C
C     ------------------------------------------------------------------
C     IF REQUESTED, CHECK GRADIENTS AT VERY FIRST POINT.
C     ------------------------------------------------------------------
      IF (LVERIF(1) .LT. 10) GO TO 90
      LVERIF(1) = MOD( LVERIF(1), 10 )
      LVLDIF    = 1
      IERR      = 0
      ITNCHK    = 0
      VERIFY    = .FALSE.
C
      IF (AUGLAG)
     *CALL M8CHKJ( ENDCHK,NNCON,NNJAC,NJAC,NX,
     *             NE,NKA,HA,KA,
     *             BL,BU,Z(LFCON),Z(LFCON2),Z(LGCON),Z(LGCON2),
     *             XN,Y,Y2,Z,NWCORE )
      IF (IERR .EQ. 6) GO TO 900
C
      IF (NNOBJ .GT. 0)
     *CALL M7CHKG( ENDCHK,NNOBJ,
     *             BL,BU,Y,Y2,Z(LGOBJ),Z(LGOBJ2),XN,Z,NWCORE )
      IF (IERR .EQ. 6) GO TO 900
      IF (IERR .EQ. 7) GO TO 870
      IF (IERR .EQ. 8) GO TO 880
C
C     ------------------------------------------------------------------
C     JUST ABOUT READY TO FACTORIZE  B.
C     IF NECESSARY, RECOMPUTE THE JACOBIAN MATRIX.
C     ------------------------------------------------------------------
   90 MAJITS = MAJITS + 1
      MINITS = 0
      KMAJOR = MAJITS
      KMINOR = MINITS
      INVITN = -1
      KPRC   = 0
      LPRC   = 0
      LVLDIF = 1
      LVLTOL = 1
      MS     = M + NS
      NFAIL  = 0
      NONOPT = -1
      TOLDJ(1) = ONE
      TOLDJ(2) = ONE
      TOLRG  = ZERO
      IF (.NOT. AUGLAG) GO TO 100
C
      CALL M8SETJ( MAJITS,NNCON,NNJAC,NNOBJ,NNOBJ0,NJAC,
     *             NCONVG,NOMOVE,NREDUC,GOTLAM,OPTSUB,CONVGD,
     *          Z(LFCON),Z(LFCON2),Z(LFDIF),Z(LFOLD),Z(LGCON),Z(LGCON2),
     *             Z(LXLAM),Z(LXDIF),Z(LXOLD),
     *             M,MS,N,NB,NN,NE,NKA,NS,A,HA,KA,KB,HS,
     *             BL,BU,Z(LBLSLK),Z(LBUSLK),Z(LRHS),PI,X,XN,Y,Z,NWCORE)
C
      IF (IERR .NE. 0) GO TO 880
      IF (CONVGD) GO TO 800
      IF (MAJITS .GT. NMAJOR) GO TO 825
      IF (NOMOVE .GE. 4     ) GO TO 825
      OPTSUB = .FALSE.
C
C     ------------------------------------------------------------------
C     FACTORIZE THE BASIS.  IN THIS VERSION,  B = L*U.
C     ------------------------------------------------------------------
  100 IF (INVITN .EQ. 0) GO TO 840
      CALL M2BFAC( NINV,M,MBS,N,NB,NR,NN,NS,FMERIT,
     *             NE,NKA,A,HA,KA,
     *             KB,HS,BL,BU,BBL,BBU,R,GRD,X,Y,Y2,Z,NWCORE )
C
      IF (IERR .GT. 0) GO TO 895
      NSSAVE = NS
      LUSIZ0 = LENL + LENU
      LUMAX  = 2*LUSIZ0
      KMODPI = 1
      NNB    = 0
      RESTRT = .TRUE.
      IF (LINEAR) GO TO 200
      DO 150 J = 1, NN
         IF (HS(J).EQ.3) NNB = NNB + 1
         IF (NNB .GT. KINV) GO TO 200
  150 CONTINUE
C
C     ------------------------------------------------------------------
C     MAIN ITERATION LOOP
C     ------------------------------------------------------------------
  200 IERR   = 0
      MS     = M+NS
      NINF0  = NINF
C
C     CHECK FEASIBILITY
C
      CALL M5FRMC( N,NB,NN,NN0,NNB,NS,MS,MAXS,
     *             FMERIT,TOLX,XNORM,
     *             BL,BU,BBL,BBU,HRTYPE,HS,KB,
     *             GRD2,X,XN,Z,NWCORE )
C
      IF (IERR .NE. 0) GO TO 900
      FEASBL = NINF .EQ. 0
      INFSBL = .NOT. FEASBL
      JSTFES = NINF0 .GT. 0  .AND.  FEASBL
      IF (.NOT. JSTFES) GO TO 220
      LVLTOL = 1
      TOLRG  = ZERO
      IF (.NOT. (NONLIN  .AND.  VERIFY)) GO TO 220
C
C     ==================================================================
C
C     CHECK GRADIENTS (AT FIRST FEASIBLE POINT OR JUST BEFORE QUITTING).
C
  210 IF (AUGLAG)
     *CALL M8CHKJ( ENDCHK,NNCON,NNJAC,NJAC,NX,
     *             NE,NKA,HA,KA,
     *             BL,BU,Z(LFCON),Z(LFCON2),Z(LGCON),Z(LGCON2),
     *             XN,Y,Y2,Z,NWCORE )
      IF (IERR .EQ. 6) GO TO 900
C
      IF (NNOBJ .GT. 0)
     *CALL M7CHKG( ENDCHK,NNOBJ,
     *             BL,BU,Y,Y2,Z(LGOBJ),Z(LGOBJ2),XN,Z,NWCORE )
      IF (ENDCHK     ) GO TO 950
      IF (IERR .EQ. 6) GO TO 900
      IF (IERR .EQ. 7) GO TO 870
      IF (IERR .EQ. 8) GO TO 880
C
      VERIFY = .FALSE.
      IF (LVERIF(1) .GE. 0) ITNCHK = ITN
C
C     END OF GRADIENT CHECK.
C
C     ==================================================================
C
C     ALTER  NPHS  FOR CERTAIN RARE CASES.
C
  220 IF (FLYING  .AND.  FEASBL  .AND.  ITN .EQ. 0) NPHS = 3
      IF (NPHS.GT.2 .AND. NNB.EQ.0 .AND. NS.EQ.0) NPHS = 2
      IF (NPHS.EQ.2 .AND. INFSBL) NPHS = 1
C
C     COMPUTE PI
C
      IF (KMODPI.EQ.0) GO TO 250
      IF (NPHS.LE.2  .OR.  INFSBL  .OR.  LINEAR) GO TO 240
      CALL MERGRD( 1,MS,NN,GMERIT,GRD2,Z,NWCORE )
      IF (IERR .NE. 0) GO TO 900
C
  240 CALL DCOPY ( MS,GRD2,1,GRD,1 )
      CALL M5SETP( 1,M,GRD2,PI,Z,NWCORE )
C
C---- IF THIS IS THE FIRST FEASIBLE POINT EVER, WE POSSIBLY WANT TO
C---- TERMINATE THE MAJOR ITERATION IN ORDER TO INITIALIZE  XLAM.
C----
C---- IF (AUGLAG  .AND.  JSTFES  .AND.  (.NOT. GOTLAM)) GO TO 500
C
C     COMPUTE RG = REDUCED GRADIENT
C
      IF (NPHS.LE.2) GO TO 250
      RGNORM = ZERO
      IF (NS .GT. 0) CALL M7RG  ( M,MS,NS,GRD,PI,RG,RGNORM,Z,NWCORE )
      IF (TOLRG .EQ. ZERO) TOLRG = ETARG*RGNORM
C
C     PROCEED WITH NEXT ITERATION
C
  250 KMODLU = 1
      KMODPI = 1
      MODR1  = 0
      MODR2  = 0
      JQ1    = 0
      JQ2    = 0
      JR1    = 0
      JR2    = 0
      JZ2    = 0
      LABZ   = 1
      NXTPHS = NPHS
      IF (NPHS .EQ. 4) GO TO 260
      IF (NS .EQ. MAXS) GO TO 850
C
C     PHASE 1, 2 OR 3.
C     SELECT ONE OR MORE NONBASIC VARIABLES TO BECOME SUPERBASIC.
C
      CALL M5PRIC( M,MBS,N,NB,NN,NN0,NS,MAXR,MAXS,
     *             NE,NKA,A,HA,KA,
     *             HS,KB,BL,BU,BBL,BBU,
     *             GMERIT,PI,RG,X,XN,Z,NWCORE )
C
      IF (IERR .NE. 0) GO TO 900
      IF (NONOPT .EQ. 0) GO TO 400
      LVLDIF = 1
      LVLTOL = 1
      NSUBSP = 0
      IF (NPHS.EQ.2 .AND. JQ.LE.NN) NPHS = 3
      IF (AUGLAG) NCONVG = 0
C
C     TEST FOR EXCESS ITERATIONS
C
  260 IF (ITN .GE. ITNLIM) GO TO 830
      IF (AUGLAG .AND. MINITS.GE.NMINOR .AND. NPHS.GT.2) GO TO 500
      IF (NPHS.GT.2) GO TO 280
C
C     PHASE 1 OR 2
C
      CALL M5LPIT( M,M1,MBS,N,NB,NN,NNB,NS,
     *             HRTYPE,HS,KB,BBL,BBU,X,Y,Y2,Z,NWCORE )
      GO TO 300
C
C     PHASE 3 OR 4
C
  280 CALL M7RGIT( M,MAXR,MAXS,MBS,NX,NB,NN,NN0,NNB,NR,NS,
     *             INFORM,NXTPHS,
     *             HRTYPE,HS,KB,BL,BU,BBL,BBU,
     *             FMERIT,GMERIT,GMERT2,GRD,GRD2,
     *             PI,R,RG,RG2,X,XN,Y,Y2,Z,NWCORE )
C
C     TEST IF THE LINE SEARCH FAILED.
C     FOR CERTAIN VALUES OF  INFORM  WE WANT TO TRY AGAIN.
C     IF INFORM = 5, M2BFAC HAS BEEN REQUESTED (PART OF ERROR RECOVERY).
C     IF INFORM = 4, WE WANT A BETTER  GMERIT  AND  PI  USING
C                    CENTRAL DIFFERENCES (NON-DERIVATIVE CASE ONLY).
C     IF INFORM = 1, WE WANT TO CALL  M5PRIC.
C
      IF (INFORM .EQ. 5) GO TO 100
      IF (INFORM .EQ. 4) GO TO 200
      IF (INFORM .EQ. 1) GO TO 250
C
C     OTHERWISE,  M7RGIT  EXITS WITH A GOOD  PI  AND  GRD  (UNLESS
C     IERR GT 0).  SET  KMODPI  TO INDICATE THAT WE DONT NEED A NEW  PI.
C
      KMODPI = 0
C
C
C     TEST FOR ERROR CONDITION AND/OR FREQUENCY INTERRUPTS
C
  300 MS     = M + NS
      IF (IERR  .EQ. 2) GO TO 460
      IF (IERR  .GT. 0) GO TO 680
      ITN    = ITN + 1
      INVITN = INVITN + 1
      MINITS = MINITS + 1
      KMINOR = MINITS
      IF (IOBJ.NE.0 .AND. LINEAR .AND. FEASBL)
     *   FMERIT = - MINIMZ * X(IOBJ)
      IF (NPHS.EQ.2 .AND. NONLIN)
     *CALL MERFUN( 1,MS,FMERIT,X,Z,NWCORE )
      IF (IERR .NE. 0) GO TO 900
C
C     PRINT ITERATION LOG
C
      CALL M5LOG ( M,MAXS,MBS,N,NB,NN,NN0,NS,NX,FMERIT,
     *             NE,NKA,A,HA,KA,
     *             BL,BU,HS,KB,X,XN,Y,Z,NWCORE )
C
C     CHECK FOR THE DREADED INFINITE LOOP,
C     BY SEEING IF THE OBJECTIVE HAS STAYED THE SAME MUCH TOO LONG.
C
      NSAMEF = NSAMEF + 1
      FX     = SINF
      IF (FEASBL) FX = FMERIT
      IF (DABS(FXPREV - FX) .GT. (ONE + DABS(FX))*EPS1) NSAMEF = 0
      IF (NSAMEF .GE. MSAMEF) GO TO 835
C
C     PRESS ON
C
      FXPREV = FX
      NPHS   = NXTPHS
      IF (AUGLAG .AND. (INFSBL .OR. RGNORM.GT.RGTEST)) NCONVG = 0
      IF (MOD(ITN,KSAV) .EQ. 0) GO TO 580
C
C     REFACTORIZE BASIS IF IT HAS BEEN MODIFIED A LOT.
C     OTHERWISE, UPDATE LU FACTORS OF BASIS IF REQUESTED.
C
  320 IF (INVMOD .GE. KINV - 1) GO TO 610
      LUSIZE = LENL + LENU
      IF (INVMOD .GE. 20  .AND.  LUSIZE .GT. LUMAX) GO TO 620
      IF (KMODLU .EQ. 1) CALL M2BSOL( 4,M,Y2,Y,Z,NWCORE )
      IF (INVRQ  .NE. 0) GO TO 100
C
C     CHECK ROW ERROR IF APPROPRIATE.
C
      MODEX  = 2
      IF (MOD(INVITN,KCHK) .EQ. 0) GO TO 640
      GO TO 200
C     ------------------------------------------------------------------
C     END OF ITERATION LOOP
C     ------------------------------------------------------------------
C
C     SOLUTION IS APPARENTLY OPTIMAL -- CHECK RGTOLS ETC.
C
  400 IF (INFSBL       ) GO TO 430
      IF (NS     .EQ. 0) GO TO 420
      IF (NPHS   .EQ. 2) GO TO 410
      IF (NCOM   .EQ. 0) GO TO 420
      IF (LVLTOL .EQ. 2) GO TO 420
      IF (NFAIL  .GT. 0  .AND.  NFULLZ .LE. 1) GO TO 420
      NFAIL  = 0
      NPHS   = 4
      TOLMIN = TOLDJ(3)*PINORM
      TOLRG  = 0.1 * DMIN1( TOLRG, RGNORM )
      IF (TOLRG  .LE. TOLMIN) LVLTOL = 2
      IF (TOLRG  .LE. TOLMIN) TOLRG  = TOLMIN
      IF (RGNORM .LE. TOLMIN) GO TO 420
      IF (LPRINT .GT. 0) WRITE(IPRINT, 1400) TOLRG,LVLTOL
      GO TO 280
C
C     END OF INITIAL PHASE 2 LP ITNS
C
  410 WRITE(IPRINT, 1210)
      NPHS   = 4
      MINITS = 0
      NINF   = 1
      NNB    = 1
      ITN    = MAX0( ITN, 1 )
      GO TO 200
C
C     RGTOLS SMALL ENOUGH -- CHECK RESIDUALS BEFORE TERMINATING
C
  420 DJQ = MINIMZ*DJQ
      IF (LPRINT .GT. 0) WRITE(IPRINT, 1410) DJQ,JQ,RGNORM,PINORM
      IF (INVITN .EQ. 0) GO TO 450
      MODEX  = 3
      GO TO 640
C
C     OPTIMAL BUT STILL INFEASIBLE
C
  430 IF (WTOBJ  .NE. ZERO) GO TO 655
      IF (NS     .EQ. 0) GO TO 470
      IF (NPHS   .EQ. 1) GO TO 440
      IF (LVLTOL .EQ. 2) GO TO 470
      LVLTOL = 2
      TOLRG  = TOLDJ(3)*PINORM
      IF (RGNORM .LE. TOLRG) GO TO 470
      NPHS   = 4
      WRITE(IPRINT, 1400) TOLRG,LVLTOL
      GO TO 280
C
C     END OF PHASE 1 LP ITNS -- GO INTO INFEASIBLE NONLINEAR MODE
C
  440 IF (ITN .GT. 0) WRITE(IPRINT, 1205)
      NPHS   = 4
      GO TO 240
C
C     SUBPROBLEM IS OPTIMAL.
C
  450 OPTSUB = .TRUE.
      IF (.NOT. AUGLAG) GO TO 800
      WRITE(IPRINT, 1510) MAJITS,MINITS,ITN
      IF (ISUMM.GT.0) WRITE(ISUMM, 1511) MINITS,ITN
      RGTEST = 100.0*TOLDJ(3)*PINORM
      IF (MODRHS .EQ. 0) INFSUB = 0
      GO TO 510
C
C     SUBPROBLEM IS UNBOUNDED
C
  460 IF (INFSBL .AND. WTOBJ.NE.ZERO) GO TO 650
      IF (.NOT. AUGLAG) GO TO 820
      CALL M8AUGL( 2,INFORM,Z,NWCORE )
      IF (INFORM .NE. 0) GO TO 900
      KMODPI = 1
      NINF   = 1
      GO TO 200
C
C     SUBPROBLEM IS INFEASIBLE.
C     MODIFY THE BOUNDS ON THE LINEARIZED CONSTRAINTS.
C
  470 IF (.NOT. AUGLAG) GO TO 810
      IF (MODRHS .EQ. 0) INFSUB = INFSUB + 1
      IF (INFSUB .GT. 5) GO TO 476
      CALL M8AUGL( 3,INFORM,Z,NWCORE )
      IF (INFORM .NE. 0) GO TO 475
      DO 472 K = 1, MS
         J      = KB(K)
         IF (J .LE. N        ) GO TO 472
         IF (J .GT. N + NNCON) GO TO 472
         BBL(K) = BL(J)
         BBU(K) = BU(J)
  472 CONTINUE
      KMODPI = 1
      MODEX  = 1
      GO TO 640
C
  475 IF (MINITS .GT. 0) GO TO 500
  476 ENDCHK = .TRUE.
      GO TO 810
C
C     MINOR ITNS TERMINATED
C
  500 WRITE(IPRINT, 1500) MAJITS,MINITS,ITN
      IF (ISUMM.GT.0) WRITE(ISUMM, 1501) MINITS,ITN
      NONOPT = 1
C
C     RETURN FOR NEXT MAJOR ITERATION
C
  510 INVITN = INVITN + 1
      NPHS   = 4
      GO TO 90
C
C     TIME TO SAVE BASIS
C
  580 IF (INEWB.LE.0 .OR. ITN.GE.ITNLIM) GO TO 320
      CALL M4STAT( 0,ISTATE )
      CALL M4NEWB( INEWB,M,N,NB,NN,NN0,NS,MS,NSCL,FMERIT,
     *             KB,HS,ASCALE,X,XN,ISTATE )
      IF (IBACK .GT. 0)
     *CALL M4NEWB( IBACK,M,N,NB,NN,NN0,NS,MS,NSCL,FMERIT,
     *             KB,HS,ASCALE,X,XN,ISTATE )
      GO TO 320
C
C     FACTORIZE  B  (FREQUENCY)
C
  610 INVRQ  = 1
      GO TO 100
C
C     FACTORIZE  B  (LU GROWTH)
C
  620 BGRWTH = LUSIZE
      BOLD   = LUSIZ0
      BGRWTH = BGRWTH/BOLD
      WRITE(IPRINT, 1030) BGRWTH
      INVRQ  = 2
      GO TO 100
C
C     IF MODEX = 1          RESET X, REFINE AND GET ROW ERROR.
C     M5SETX  THEN NEEDS  GRD2  FOR WORKSPACE.
C     IF MODEX = 2 OR MORE,                     GET ROW ERROR.
C
  640 MS     = M + NS
      CALL M5SETX( MODEX,M,MS,NS,GRD2,X,Y,Y2,Z,NWCORE )
      IF (IERR   .GT. 0) INVRQ = 10
      IF (INVRQ  .GT. 0) GO TO 100
      IF (MODEX .EQ. 3) GO TO 450
      GO TO 200
C
C     RESET OR REDUCE WTOBJ
C
  650 WTOBJ  = ZERO
  655 MODWT  = MODWT + 1
      WTOBJ  = 0.1*WTOBJ
      IF (MODWT .GT. 5) WTOBJ = ZERO
      WRITE(IPRINT, 1200) WTOBJ
      GO TO 200
C
C     ERROR CONDITION.  CHECK IF IT WAS A LINESEARCH FAILURE.
C
  680 IF (AUGLAG  .AND.  IERR .EQ. 9  .AND.  MINITS .GT. 0) GO TO 500
      IF (IERR .EQ. 9) GO TO 890
      GO TO 900
C
C     ------------------------------------------------------------------
C     EXIT.
C     ------------------------------------------------------------------
C
C     OPTIMAL
C
  800 WRITE(IPRINT, 1800)
      IF (ISUMM.GT.0) WRITE(ISUMM, 1800)
      RGTEST = RGNORM/PINORM
      IF (RGTEST .GE. ONE) WRITE(IPRINT, 1802)
      GO TO 900
C
C     INFEASIBLE
C
  810 WRITE(IPRINT, 1810) NINF,SINF
      IF (ISUMM.GT.0) WRITE(ISUMM, 1810) NINF,SINF
      IERR = 1
      GO TO 900
C
C     UNBOUNDED
C
  820 WRITE(IPRINT, 1820)
      IF (ISUMM.GT.0) WRITE(ISUMM, 1820)
      GO TO 900
C
C     TOO MANY ITERATIONS
C
  825 WRITE(IPRINT, 1825)
  830 WRITE(IPRINT, 1830)
      IF (ISUMM.GT.0) WRITE(ISUMM, 1830)
      IERR = 3
      GO TO 900
C
C     THE OBJECTIVE HASNT CHANGED FOR AGES
C
  835 WRITE(IPRINT, 1835) MSAMEF
      IF (ISUMM.GT.0) WRITE(ISUMM, 1835) MSAMEF
      IERR = 4
      GO TO 900
C
C     M2BFAC CALLED TWICE IN A ROW
C
  840 WRITE(IPRINT, 1840)
      IF (ISUMM .GT. 0) WRITE(ISUMM, 1840)
      IERR = 12
      GO TO 900
C
C     MAXS  TOO SMALL
C
  850 WRITE(IPRINT, 1850)
      IF (ISUMM .GT. 0) WRITE(ISUMM, 1850)
      IERR = 5
      GO TO 900
C
C     BAD GRADIENTS IN  FUNOBJ.
C
  870 WRITE(IPRINT, 1870)
      IF (ISUMM .GT. 0) WRITE(ISUMM, 1870)
      GO TO 900
C
C     BAD GRADIENTS IN  FUNCON.
C
  880 WRITE(IPRINT, 1880)
      IF (ISUMM .GT. 0) WRITE(ISUMM, 1880)
      GO TO 900
C
C     LINESEARCH FAILURE.
C
  890 WRITE(IPRINT, 1890)
      IF (ISUMM .GT. 0) WRITE(ISUMM, 1890)
      ENDCHK = .TRUE.
      GO TO 900
C
C     FATAL ERROR AFTER LU FACTORIZATION.
C
  895 IF (IERR .NE. 10) GO TO 900
      WRITE(IPRINT, 1895)
      IF (ISUMM .GT. 0) WRITE(ISUMM, 1895)
C
C
C     ------------------------------------------------------------------
C     PRINT SUMMARY OF FINAL SOLUTION
C     ------------------------------------------------------------------
C
  900 MS     = M + NS
      FLIN   = ZERO
      IF (IOBJ.NE. 0) FLIN = - X(IOBJ)
      OBJTRU = FLIN + FOBJ
      RGTEST = RGNORM / PINORM
      WRITE(IPRINT, 1900) ITN,OBJTRU
      IF (NONLIN)    WRITE(IPRINT, 1910) MAJITS,FLIN,PENPAR,FOBJ
                     WRITE(IPRINT, 1930) XNORM,PINORM
      IF (NN .GT. 0) WRITE(IPRINT, 1940) NS,RGNORM,NNB,RGTEST
      IF (NONLIN)    WRITE(IPRINT, 1950)  NFOBJ(1),NFCON(1)
      IF (NONLIN  .AND.  LDERIV .LT. 3)
     *               WRITE(IPRINT, 1960) (NFOBJ(I),NFCON(I), I=2,4)
      IF (ISUMM .LE. 0) GO TO 920
C
      WRITE(ISUMM, 2000) MAJITS,ITN,OBJTRU
      IF (NN .GT. 0) WRITE(ISUMM, 2040) NS,RGNORM
                     WRITE(ISUMM, 2050) XNORM,PINORM
      IF (NONLIN)    WRITE(ISUMM, 2060) NFOBJ(1),NFCON(1)
C
C
C     RESTORE ORIGINAL RHS.
C     SEE IF AN EMERGENCY GRADIENT CHECK WAS REQUESTED.
C
  920 IF (AUGLAG) CALL M8AUGL( 4,INFORM,Z,NWCORE )
      IF (ENDCHK .AND. ITNCHK.LT.ITN) GO TO 210
C
C
  950 RETURN
C
C
 1030 FORMAT(' LU FILE HAS INCREASED BY A FACTOR OF', F6.1)
 1200 FORMAT(/ ' WEIGHT ON OBJ  REDUCED TO', 1PE12.2)
 1205 FORMAT(/ ' END OF PHASE 1 LP ITERATIONS.',
     *   '   STILL INFEASIBLE AT NON-VERTEX POINT.' /)
 1210 FORMAT(/ ' END OF PHASE 2 LP ITERATIONS' /)
 1400 FORMAT(' TOLRG  REDUCED TO', 1PE11.3, 5X, ' LVLTOL =', I2)
 1410 FORMAT(/ ' BIGGEST DJ =', 1PE11.3, ' (VARIABLE', I6, ')',
     *   '   NORM RG =', 1PE11.3, '   NORM PI =', 1PE11.3)
 1500 FORMAT(/ ' END OF MAJOR ITN', I4,
     *   '  -  MINOR ITNS TERMINATED AT', I4,
     *   '  -  TOTAL ITNS =', I6)
 1501 FORMAT(' MINOR ITNS TERMINATED AT', I4,
     *   '  -  TOTAL ITNS =', I6)
 1510 FORMAT(/ ' END OF MAJOR ITN', I4,
     *   '  -  OPTIMAL SUBPROBLEM AT MINOR ITN', I4,
     *   '  -  TOTAL ITNS =', I6)
 1511 FORMAT(' OPTIMAL SUBPROBLEM AT MINOR ITN', I4,
     *   '  -  TOTAL ITNS =', I6)
C
 1800 FORMAT(1H1 / ' EXIT -- OPTIMAL SOLUTION FOUND')
 1802 FORMAT(/ ' XXX WARNING -- REDUCED GRADIENT IS LARGE --',
     *   ' SOLUTION IS NOT REALLY OPTIMAL.')
 1810 FORMAT(1H1 / ' EXIT -- THE PROBLEM IS INFEASIBLE'
     *   // ' NO. AND SUM OF INFEASIBILITIES', I6, 1PE20.8)
 1820 FORMAT(1H1 / ' EXIT -- THE PROBLEM IS UNBOUNDED ',
     *   ' (OR BADLY SCALED).')
 1825 FORMAT(/ ' XXX  MAJOR ITERATIONS TERMINATED BEFORE CONVERGENCE')
 1830 FORMAT(1H1 / ' EXIT -- TOO MANY ITERATIONS')
 1835 FORMAT('1' / ' EXIT -- THE OBJECTIVE HAS NOT CHANGED',
     *   ' FOR THE LAST', I8, '  ITERATIONS')
 1840 FORMAT(1H1 / ' EXIT -- BASIS FACTORIZATION REQUESTED',
     *   ' TWICE IN A ROW')
 1850 FORMAT(1H1 / ' EXIT -- THE SUPERBASICS LIMIT IS TOO SMALL...', I7)
 1870 FORMAT(1H1 / ' EXIT -- SUBROUTINE FUNOBJ APPEARS TO BE',
     *   ' GIVING INCORRECT GRADIENTS')
 1880 FORMAT(1H1 / ' EXIT -- SUBROUTINE FUNCON APPEARS TO BE',
     *   ' GIVING INCORRECT GRADIENTS')
 1890 FORMAT('1' / ' EXIT -- THE CURRENT POINT CANNOT BE IMPROVED UPON')
 1895 FORMAT('1' / ' EXIT -- NUMERICAL ERROR.  GENERAL CONSTRAINTS',
     *   ' CANNOT BE SATISFIED ACCURATELY')
C
 1900 FORMAT(/ ' NO. OF ITERATIONS', I24,
     *   6X, 15HOBJECTIVE VALUE, 1PE26.13)
 1910 FORMAT(/ ' NO. OF MAJOR ITERATIONS', I18,
     *   5X, ' LINEAR OBJECTIVE', 1PE25.13
     *   //  ' PENALTY PARAMETER', 0PF24.6,
     *   5X, ' NONLINEAR OBJECTIVE', 1PE22.13)
 1930 FORMAT(/ ' NORM OF X', 1PE32.3,
     *   5X,   ' NORM OF PI', 1PE31.3)
 1940 FORMAT(/ ' NO. OF SUPERBASICS', I23,
     *   5X,   ' NORM OF REDUCED GRADIENT', 1PE17.3
     *      // ' NO. OF BASIC NONLINEARS', I18,
     *   5X,   ' NORM RG / NORM PI', 1PE24.3)
 1950 FORMAT(/ ' NO. OF CALLS TO  FUNOBJ        ', I10,
     *     5X, ' NO. OF CALLS TO  FUNCON        ', I10)
 1960 FORMAT(  ' CALLS WITH MODE=2  (F, KNOWN G)', I10,
     *     5X, ' CALLS WITH MODE=2  (F, KNOWN G)', I10
     *       / ' CALLS FOR FORWARD DIFFERENCING ', I10,
     *     5X, ' CALLS FOR FORWARD DIFFERENCING ', I10
     *       / ' CALLS FOR CENTRAL DIFFERENCING ', I10,
     *     5X, ' CALLS FOR CENTRAL DIFFERENCING ', I10)
 2000 FORMAT(/ ' MAJOR, MINOR ITNS   ', 2I12
     *       / ' OBJECTIVE FUNCTION  ', 1PE24.13)
 2040 FORMAT(  ' SUPERBASICS, RGNORM ', I12, 1PE12.2)
 2050 FORMAT(  ' XNORM,       PINORM ', 1P2E12.2)
 2060 FORMAT(  ' FUNOBJ, FUNCON CALLS', 2I12)
C     END OF M5SOLV
      END
