#include "cp_types.h"
#include "cp_proto.h"
#include "cp_post.h"

int post_any_polygon(FILE *fp,struct p_data *p,
		     struct Vertlist *vertlist,int eflag,int ecol,int col)
     /* calling routine must make sure first vertex is repeated at end
	if a closed polygon is desired. If the 'filled' option is
	specified, then a 'closepath' will be issued to close it up in
	any case. */
{
  int v,w;
  complex a,b;
  hyp_geodesic hg;
  struct Vertlist *vtrace;
  struct Pathlist *plist;
  struct R_data *pR_ptr;

  if (!(vtrace=vertlist) || !(vtrace->next)
      || (v=vtrace->v)<1 || v>p->nodecount) return 0;
  pR_ptr=p->packR_ptr;
  a=pR_ptr[v].center;
  fprintf(fp,"gs   %f %f m\n",a.re,a.im);
  if (p->hes<0)
    {
      while (vtrace && vtrace->next
	     && (v=vtrace->v)>0 && v<=p->nodecount
	     && (w=vtrace->next->v)>0 && w<=p->nodecount)
	{
	  if (v!=w) /* eat repeats */
	    {
	      a=pR_ptr[v].center;	
	      b=pR_ptr[w].center;
	      h_geodesic(a,b,&hg);
	      if (hg.line_flag) /* use straight line */
		{
		  fprintf(fp,"%f %f l\n",b.re,b.im);
		}
	      else 
		{
		  if (hg.z1.re==a.re && hg.z1.im==a.im) 
				/* right direction*/
		    fprintf(fp,"%f %f %f %f %f a\n",
			    hg.c.re,hg.c.im,hg.rad,
			    hg.arg1*degPI,hg.arg2*degPI);
		  else fprintf(fp,"%f %f %f %f %f an\n",
			       hg.c.re,hg.c.im,hg.rad,
			       hg.arg2*degPI,hg.arg1*degPI);
		}
	    }
	  vtrace=vtrace->next;
	} /* end of while */
      if (ecol!=FG_COLOR) /* edge colors? */
	fprintf(fp,"%f %f %f srgb ",
		(double)red[ecol]/255,(double)green[ecol]/255,
		(double)blue[ecol]/255);
      if ((eflag & 2) && col!=FG_COLOR) 
	fprintf(fp,"cp\ngs %f %f %f srgb fill gr ",
		(double)red[col]/255,(double)green[col]/255,
		(double)blue[col]/255);
      else if (eflag & 2)
	fprintf(fp,"cp\ngs gry  sg fill gr\n"); 
      fprintf(fp,"s gr\n"); /* draw border */
      return 1;
    } /* end of hyp case */
  else if (p->hes==0)
    {
      while (vtrace && vtrace->next
	     && (v=vtrace->v)>0 && v<=p->nodecount
	     && (w=vtrace->next->v)>0 && w<=p->nodecount)
	{
	  if (v!=w) /* eat repeats */
	    {
	      b=pR_ptr[w].center;
	      fprintf(fp,"%f %f l\n",b.re,b.im);
	    }
	  vtrace=vtrace->next;
	} /* end of while */
      if (ecol!=FG_COLOR) /* edge colors? */
	fprintf(fp,"%f %f %f srgb ",
		(double)red[ecol]/255,(double)green[ecol]/255,
		(double)blue[ecol]/255);
      if ((eflag & 2) && col!=FG_COLOR) 
	fprintf(fp,"cp\ngs %f %f %f srgb fill gr ",
		(double)red[col]/255,(double)green[col]/255,
		(double)blue[col]/255);
      else if (eflag & 2)
	fprintf(fp,"cp\ngs gry  sg fill gr\n"); 
      fprintf(fp,"s gr\n"); /* draw border */
      return 1;
    } /* end of eucl case */
  else if (p->hes>0) /* fixup: will sph 'fill' screw up if not convex? */
    {
      if (!(plist=sph_poly_list(p,vertlist))) return 0;
      post_s_convex(fp,plist,eflag,ecol,col);
      return 1;
    }
  return 0;
} /* post_any_polygon */

