#include  "cp_types.h"
#include "cp_proto.h"

/* patch_pack.c is a bunch of code to:
   - find verts interior to current path
   - create a p_light structure with vertex_map to parent
   - send p_light pack for repacking
   - blend centers radii back into original
*/

int patch_pack(struct p_data *p,int bdry1,int bdry2,
	       int passes, double tolr,int n_gen,int mincount,
	       struct Pathlist *pathlist,int pathlength)
     /* 
     bdry1/2: bdry verts to be used for registration when blending
     mincount: want at least this many interior verts
     n_gen: number of generations from the bdry to use in 'blend'. 
     */
{
  int i,j,hit1=0,hit2=0,icount=0;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;

  /* create region */
  Xptr=path_XPoints(p->screen,pathlist,&length);
  (*region)=XPolygonRegion(Xptr,length,WindingRule);
  free(Xptr);
  
  /* mark interior, call to create p_light */
  for (i=1;i<=p->nodecount;i++)
    {
      if (!pK_ptr[i].bdry_flag && path_wrap(p,pR_ptr[i].center)) 
	{
	  pK_ptr[i].util_flag=1;
	  icount++;
	}
      else pK_ptr[i].util_flag=0;
    }
  if (icount<mincount) /* not big enough */
    {
      return 0;
    }
  /* check whether bdry1/2 are interior or nghb's of interior */
  for (j=0;(!hit1 && j<=pK_ptr[bdry1].num);j++) hit1++;
  for (j=0;(!hit2 && j<=pK_ptr[bdry2].num);j++) hit2++;
  if (!hit1 || !hit2)
    {
      sprintf(msgbuf,"Given vertices %d and %d are not in region.",
	      bdry1,bdry2);
      emsg();
      return 0;
    }

  /* build p_light packing and repack */
  if (!(pack_light=convert_to_p_light(p)))
    {
      sprintf(msgbuf,"Didn't succeed in building p_light packing.");
      emsg();
      return 0;
    }
  if (!e_pack_light_uniform(pack_light,passes,tolr,0))
    {
      sprintf(msgbuf,"Packing of p_light didn't work.");
      emsg();
      return 0;
    }

  /* label generations from bdry of patch region for blending */
  for (i=1;i<=p->nodecount;i++)
    {
      if (pK_ptr[i].util_flag>0) pK_ptr[i].util_flag=0;
      else pK_ptr[i].util_flag=1;
    }
  
  


} /* patch_pack */


