#include "cp_types.h"
#include "cp_proto.h"

/* draw various hyperbolic objects */

/* Drawing flag scheme: flags indicate drawing instructions
   for objects -- circles/lines/faces. Bits set as follows:
      1  ->  draw object?
      2  ->  fill? (4 and 16 imply 2, also)
      4  ->  off = foreground, on = background 
             (applies to interior, not border, overriden by bit 16)
      8  ->  border color? (off = foreground, on = recorded color)
      16 ->  interior color? (default set by bit 4, on --> recorded color)
      32 ->  display label?

Eg.  flag=3: filled object, in foreground
     flag=9: open object, border in (recorded) color
             (for 'edge', this gives colored edge)
     flag=19: filled in color, border in foreground
     flag=27: filled, border and interior in color
     flag=15: filled with background, border in color
     flag=32: label only (face or circle)

Normally, flag for each type of object; often, when passed on to
subroutine, you may need to pass color code too:
Eg. (cflag, ecol, ccol) for circle flag, border color code, int color 
code. */

int alist[300];

int h_triangle(struct s_data *q,complex p1,complex p2,complex p3,
	       int fflag,int ecol,int fcol,int show)
{
  int numpts,N[1],i,tlist[600];
  complex normpt;
  hyp_geodesic hg1,hg2,hg3;
  XPoint pts[200];

  h_geodesic(p1,p2,&hg1);
  h_geodesic(p2,p3,&hg2);
  h_geodesic(p3,p1,&hg3); /* set triangle structures */

  if (!geo_ck(hg1,q->box) && !geo_ck(hg2,q->box) && 
      !geo_ck(hg3,q->box)) return 1; 
  /* first edge */
  if (hg1.line_flag) /* use straight line */
    {
      r_to_pix(p1,&normpt,q->pix_box,q->box);
      tlist[0]=normpt.re;tlist[1]=normpt.im;
      r_to_pix(p2,&normpt,q->pix_box,q->box);
      tlist[2]=normpt.re;tlist[3]=normpt.im;
      numpts=2;
    }
  else 
    {
      numpts = polyarc(q,hg1.rad,hg1.c,hg1.arg1,hg1.arg2); 
      /* subroutine fills alist */
      if (hg1.z1.re==p1.re && hg1.z1.im==p1.im) 
	/* arc is drawn starting at p1 */
	for (i=0;i<2*numpts;i++) tlist[i]=alist[i];
      else 
	for (i=0;i<numpts;i++) 
	  {
	    tlist[2*i]=alist[2*numpts-2-2*i];
	    tlist[2*i+1]=alist[2*numpts-1-2*i];
	  }
      /* arc went wrong way */
    }
  N[0]=numpts;
  /* second edge */
  if (hg2.line_flag) /* use straight line */
    {
      r_to_pix(p3,&normpt,q->pix_box,q->box);
      tlist[2*N[0]]=normpt.re;tlist[2*N[0]+1]=normpt.im;
      numpts=1;
    }
  else 
    {
      numpts = polyarc(q,hg2.rad,hg2.c,hg2.arg1,hg2.arg2)-1; 
      if (hg2.z1.re==p2.re && hg2.z1.im==p2.im) 
	/* arc is drawn starting at p2 */
	for (i=0;i<2*numpts;i++) tlist[2*N[0]+i]=alist[2+i];
      else 
	for (i=0;i<numpts;i++) 
	  {
	    tlist[2*N[0]+2*i]=alist[2*numpts-2-2*i];
	    tlist[2*N[0]+2*i+1]=alist[2*numpts-1-2*i];
	  }
      /* arc went wrong way */
    }
  N[0] += numpts;
  /* third edge */
  if (hg3.line_flag) /* use straight line */
    {
      r_to_pix(p1,&normpt,q->pix_box,q->box);
      tlist[2*N[0]]=normpt.re;tlist[2*N[0]+1]=normpt.im;
      numpts=1;
    }
  else
    {
      numpts = polyarc(q,hg3.rad,hg3.c,hg3.arg1,hg3.arg2)-1; 
      if (hg3.z1.re==p3.re && hg3.z1.im==p3.im) 
	/* arc is drawn starting at p3 */
	for (i=0;i<2*numpts;i++) tlist[2*N[0]+i]=alist[2+i];
      else 
	for (i=0;i<numpts;i++) 
	  {
	    tlist[2*N[0]+2*i]=alist[2*numpts-2-2*i];
	    tlist[2*N[0]+2*i+1]=alist[2*numpts-1-2*i];
	  }
      /* arc went wrong way */
    }
  N[0] += numpts;
  for (i=0;i<N[0];i++)
    {
      pts[i].x=(short)tlist[i*2];
      pts[i].y=(short)tlist[i*2+1];
    }
  if (fflag & 2)
    {
      if (!(fflag & 16))
	{
	  fcol=FG_COLOR;
	  if (fflag & 4) fcol=BG_COLOR;
	}
      FillPolygon(q->xpm,pts,N[0],colors[fcol]);
    }
  if (!(fflag & 8)) ecol=FG_COLOR;
  DrawLines(q->xpm,pts,N[0],colors[ecol]);

  if (show) refresh_canvas(q);
  return 1;
} /* h_triangle */

int h_polygon(struct p_data *p,struct Vertlist *vertlist,
	      int fflag,int ecol,int fcol,int show)
     /* draws hyp polygon through verts. Code has limit on length.*/
{
  int numpts,N[1],i,tlist[10000],v,w;
  complex a,b,normpt;
  hyp_geodesic hg;
  XPoint pts[10000];
  struct Vertlist *vtrace;
  struct R_data *pR_ptr;

  pR_ptr=p->packR_ptr;
  N[0]=0;
  if (!(vtrace=vertlist) || !(vtrace->next)) return 0;
  /* build up tlist */
  while (vtrace && vtrace->next
	 && (v=vtrace->v)>0 && v<=p->nodecount
	 && (w=vtrace->next->v)>0 && w<=p->nodecount
	 && N[0] < 4500 )
    {
      if (v!=w) /* eat repeats */
	{
	  a=pR_ptr[v].center;	
	  b=pR_ptr[w].center;
	  h_geodesic(a,b,&hg);
	  if (hg.line_flag) /* use straight line */
	    {
	      r_to_pix(a,&normpt,p->screen->pix_box,
		       p->screen->box);
	      alist[0]=normpt.re;alist[1]=normpt.im;
	      r_to_pix(b,&normpt,p->screen->pix_box,
		       p->screen->box);
	      alist[2]=normpt.re;alist[3]=normpt.im;
	      numpts = 2;
	    }
	  else numpts=polyarc(p->screen,hg.rad,hg.c,hg.arg1,hg.arg2);
	  /* subroutine fills alist */
	  if (hg.z1.re==a.re && hg.z1.im==a.im)
	    /* arc starts at p1 */
	    for (i=0;i<2*numpts;i++) tlist[2*N[0]+i]=alist[i];
	  else
	    for (i=0;i<numpts;i++)
	      {
		tlist[2*N[0]+2*i]=alist[2*numpts-2-2*i];
		tlist[2*N[0]+2*i+1]=alist[2*numpts-1-2*i];
	      }
	  /* arc went opposite way */
	  N[0] += numpts;
	}
      vtrace=vtrace->next;
    } /* end of while */
  for (i=0;i<N[0];i++)
    {
      pts[i].x=(short)tlist[i*2];
      pts[i].y=(short)tlist[i*2+1];
    }
  if (fflag & 2)  /* want filled */
    {
      if (!(fflag & 16))
	{
	  fcol=FG_COLOR;
	  if (fflag & 4) fcol=BG_COLOR;
	}
      FillPolygon(p->screen->xpm,pts,N[0],colors[fcol]);
    }
  if (!(fflag & 8)) ecol=FG_COLOR;
  DrawLines(p->screen->xpm,pts,N[0],colors[ecol]);

  if (show) refresh_canvas(p->screen);
  return 1;
} /* h_polygon */

int hgeo(struct s_data *q,complex a,complex b,int col,int show)
     /* draws geodesic arc on screen q from a to b counterclockwise. 
Points are given as pts in plane. Returns 1 if on screen. */
{
  int diam;
  hyp_geodesic hg;
  complex cnr,normpt;

  h_geodesic(a,b,&hg);
  if (hg.line_flag) /* use straight line */
    return (kline(q,a,b,col,show));
  if (!geo_ck(hg,q->box)) return 0; /* geo is off screen */
  cnr.re=hg.c.re-hg.rad;cnr.im=hg.c.im+hg.rad;
  r_to_pix(cnr,&normpt,q->pix_box,q->box);
  diam=(int) 2*hg.rad*(q->pix_box.rx)/
    (q->box.rx-q->box.lx);
  if (diam<=0) diam=1;
  if (col!=FG_COLOR)
    DrawArc(q->xpm,(int)normpt.re,(int)normpt.im,diam,(int)(diam),
	    (int)(hg.arg1*degPI*(64.0)),
	    (int)((hg.arg2-hg.arg1)*degPI*(64.0)),colors[col]);
  else DrawArc(q->xpm,(int)normpt.re,(int)normpt.im,diam,(int)(diam),
		(int)(hg.arg1*degPI*(64.0)),
		(int)((hg.arg2-hg.arg1)*degPI*(64.0)),fgcolor);
  if (show) refresh_canvas(q);
  return 1;
} /* hgeo */
