#include "cp_types.h"
#include "cp_proto.h"

/* eucl scale by given factor. In hyp case, return 0 if some 
circles forced outside unit disc. In sph case, apply z->t*z Mobius. */

int eucl_scale(struct p_data *p,double factor)
{
  int flag=0,i,wflag=0;
  double e_rad;
  complex e_center;
  Mobius Mob;
  struct R_data *pR_ptr;
  struct RedList *trace;
	
  pR_ptr=p->packR_ptr;
  if (p->hes<-okerr) /* hyp */
    {
      for (i=1;i<=p->nodecount;i++)
	{
	  h_to_e_data(pR_ptr[i].center,pR_ptr[i].rad,
		      &e_center,&e_rad);
	  e_center.re*=factor;
	  e_center.im*=factor;
	  e_rad*=factor;
	  if (!e_to_h_data(e_center,e_rad,&pR_ptr[i].center,
			   &pR_ptr[i].rad)) flag++;
	}
      if ((trace=p->redfaces))
	while (trace!=p->redfaces || !(wflag++))
	  {
	    i=p->faces[trace->face].vert[trace->v_flag];
	    h_to_e_data(trace->center,trace->rad,
			&e_center,&e_rad);
	    e_center.re*=factor;
	    e_center.im*=factor;
	    e_rad*=factor;
	    if (!e_to_h_data(e_center,e_rad,&(trace->center),
			     &(trace->rad))) flag++;
	    trace=trace->next;
	  }
      fillcurves(p);
    }
  else 
    {
      Mob=ident_mob();
      Mob.flip=0;
      Mob.a.re=factor;
      apply_Mobius(p,"a",1,Mob);
    }
  return flag;
} /* eucl_scale */
