#include "cp_types.h"
#include "cp_proto.h"

/* links v2 (counterclockwise node) to v3 (clockwise node),
making v1 interior. Already verified, v1 is bdry node. */

int enfold(struct p_data *p,int v1)
{
  int n,v2,v3,i,*newflower;
  double *newoverlaps;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;
  pR_ptr=p->packR_ptr;
  n=pK_ptr[v1].num;
  v2=pK_ptr[v1].flower[0]; /* first neighbor */
  v3=pK_ptr[v1].flower[n]; /* second neighbor */
  /* adjust flower of v1 */
  newflower=(int *)calloc((size_t)(n+2),sizeof(int));
  for (i=0;i<=n;i++)
    newflower[i]=pK_ptr[v1].flower[i];
  newflower[n+1]=v2;
  free(pK_ptr[v1].flower);
  pK_ptr[v1].flower=newflower;
  if (pK_ptr[v1].overlaps)
    {
      newoverlaps=(double *)calloc((size_t)(n+2),sizeof(double));
      for (i=0;i<=n;i++)
	newoverlaps[i]=pK_ptr[v1].overlaps[i];
      newoverlaps[n+1]=pK_ptr[v1].overlaps[0];
      free(pK_ptr[v1].overlaps);
      pK_ptr[v1].overlaps=newoverlaps;
    }
  pK_ptr[v1].bdry_flag=0;
  pR_ptr[v1].aim=2.0*M_PI;
  pK_ptr[v1].num++;
  if (pR_ptr[v1].rad<=0) /* avoid infinity rad */
    {
      pR_ptr[v1].rad=.1; 
    } 
  /* add to flower of v2 */
  n=pK_ptr[v2].num;
  newflower=(int *)calloc((size_t)(n+2),sizeof(int));
  for (i=0;i<=n;i++) newflower[i]=pK_ptr[v2].flower[i];
  newflower[n+1]=v3;
  free(pK_ptr[v2].flower);
  pK_ptr[v2].flower=newflower;
  pK_ptr[v2].num++;
  if (pK_ptr[v2].overlaps)
    {
      newoverlaps=(double *)calloc((size_t)(n+2),sizeof(double));
      for (i=0;i<=n;i++)
	newoverlaps[i]=pK_ptr[v2].overlaps[i];
      newoverlaps[n+1]=1.0;
      free(pK_ptr[v2].overlaps);
      pK_ptr[v2].overlaps=newoverlaps;
    }
  if (pK_ptr[v2].flower[0]==v3) 
    {
      pK_ptr[v2].bdry_flag=0;
      if (pR_ptr[v2].rad<=0) /*avoid infinity*/
	{
	  pR_ptr[v2].rad=.1;
	}
      if (pK_ptr[v2].overlaps) 	
	pK_ptr[v2].overlaps[n+1]=pK_ptr[v2].overlaps[0];
      pR_ptr[v2].aim=2.0*M_PI;
    }
  /* add to flower of v3 */
  n=pK_ptr[v3].num;
  newflower=(int *)calloc((size_t)(n+2),sizeof(int));
  for (i=1;i<=n+1;i++) newflower[i]=pK_ptr[v3].flower[i-1];
  newflower[0]=v2;
  free(pK_ptr[v3].flower);
  pK_ptr[v3].flower=newflower;
  if (pK_ptr[v3].overlaps)
    {
      newoverlaps=(double *)calloc((size_t)(n+2),sizeof(double));
      for (i=1;i<=n+1;i++) newoverlaps[i]=pK_ptr[v3].overlaps[i-1];
      newoverlaps[0]=1.0;
      free(pK_ptr[v3].overlaps);
      pK_ptr[v3].overlaps=newoverlaps;
    }
  pK_ptr[v3].num++;
  if (pK_ptr[v3].flower[pK_ptr[v3].num]==v2) 
    {
      pK_ptr[v3].bdry_flag=0;
      if (pR_ptr[v3].rad<=0) /*avoid infinity*/
	{
	  pR_ptr[v3].rad=.1;
	}
      if (pK_ptr[v3].overlaps)
	pK_ptr[v3].overlaps[0]=pK_ptr[v3].overlaps[n+1];
      pR_ptr[v2].aim=2.0*M_PI;
    }
  /* update pack structures and beta after returning */
  return 1;
} /* enfold */
