#include "cp_types.h"
#include "cp_proto.h"

/* return count of bdry verts w/o int nghbs.
This can have two causes: vert in only one face (num=1) or vert
might be one end of separating edge. List last 5 found, put 
full list in /tmp/diagnostic_log. */

int diag_hanging_verts(struct p_data *p)
{
  int i,j,count=0,list[5],listcount=0,hitflag;
  char buf[16];
  FILE *diagfp;

  for (i=1;i<=p->nodecount;i++)
    if (p->packK_ptr[i].bdry_flag)
      {
	hitflag=0;
	for (j=1;!hitflag && j<p->packK_ptr[i].num;j++)
	  if (!p->packK_ptr[p->packK_ptr[i].flower[j]].bdry_flag)
	    hitflag=i;
	if (!hitflag) 
	  {
	    list[listcount]=i;
	    listcount = (listcount+1)%5;
	    count++;
	  }
      }
  if (count)
    {
      sprintf(msgbuf,"Diag: %d boundary vertices don't have interior neighbors; see '/tmp/diagnostic_log' for a list; here are the last few.",count);
      for (i=0;i<count && i<5;i++)
	{
	  sprintf(buf," %d ",list[i]);
	  strcat(msgbuf,buf);
	}
      msg();
      if (!(diagfp=fopen("/tmp/diagnostic_log","a")))
	{
	  sprintf(msgbuf,"couldn't open /tmp/diagnostic_log");
	  emsg();
	  return count;
	}
      fprintf(diagfp,"\nPacking %s, nodecount %d\n\n%d bdry verts without interior neighbors:\n\n   ",p->file_name,p->nodecount,count);
      for (i=1;i<=p->nodecount;i++)
	if (p->packK_ptr[i].bdry_flag)
	  {
	    hitflag=0;
	    for (j=1;!hitflag && j<p->packK_ptr[i].num;j++)
	      if (!p->packK_ptr[p->packK_ptr[i].flower[j]].bdry_flag)
		hitflag=i;
	    if (!hitflag) fprintf(diagfp,"%d  ",i);
	  }
      fprintf(diagfp,"\n\nEND\n\n");
      fclose(diagfp);
    }
  return count;
} /* diag_hanging_verts */
