/* cp_proto.h     procedure prototypes for circle packing library   */

#include "cp_types.h"

int fancy_comp_center(struct p_data *p,int vert,int n0,int n1,int n,
		 int flag,int opt,int npf,double crit);
int h_compcenter(complex z1,complex z2,complex *z3,
		 double s1,double s2,double *s3,
		 double o1,double o2,double o3);
int molify_call(struct p_data *p,char *datastr);
int molify_pack_centers(struct p_data *p,int flag,
			struct Vertlist *vertlist);
int molify_center(struct p_data *p,int v);
int incr_generations(struct p_data *p,struct Vertlist **seed_list,
		int *mark_count,int *min_gen,int target_size);
int print_call(FILE **FP,struct p_data *p,char *filename,
	       char *datastr,char *user_name,char *Message,
	       char *print_cmd);
int get_put_data(struct p_data *p,struct p_data *q,
	     char *datastr,char flag,int rev_flag,int trans_flag);
int color_circles(struct p_data *p,int f,char *datastr);
int color_faces(struct p_data *p,int f,char *datastr);
int r_to_pix(complex pt, complex *normpt, Pix_box pix_box, Box box);
int pix_to_r(int x, int y, complex *realpt, Pix_box pix_box, Box box);
int line_ck(complex end1, complex end2, Box box);
int cir_ck(complex ctr,double rad,Box box); 
int geo_ck(hyp_geodesic hg,Box box);
int fillcurves(struct p_data *p);
int crement_radii(struct p_data *p,double factor,char *datastr);
int h_changerad(struct p_data *p,int i,double newr);
int e_changerad(struct p_data *p,int i,double newr);
int s_changerad(struct p_data *p,int i,double newr);
int apply_pair_mobius(struct p_data *p,char *datastr);
int e_norm_scale(struct p_data *p,char *datastr);
int eucl_scale(struct p_data *p,double factor);
int pair_mobius(struct p_data *p,int n);
int e_norm_pack(struct p_data *p,complex a,complex g);
int update_pair_mob(struct p_data *p);
int apply_Mobius(struct p_data *p,char *datastr,int flag,Mobius Mob);
int rotate(struct p_data *p,double ang);
int center_point(struct p_data *p,complex ctr);
int spiral(struct p_data *p,double a,double b);
int h_norm_pack(struct p_data *p,complex c,complex d);
int fill_star_curves(struct p_data *p,int v);
int normalize_star(struct p_data *p,int v,double radius);
int any_compcenter(int hes,complex z1,complex z2,complex *z3,
		   double r1,double r2,double *r3,
		   double o1,double o2,double o3);
int bdry_dist(struct p_data *p,complex pt,double *b_dist,double *b_vert_dist);
int e_anglesum_overlap(struct p_data *p,int v,double r,double *c,int *flag);
int s_anglesum_overlap(struct p_data *p,int i,double r,double *c,int *flag);
int h_as_overlap(struct p_data *p,int i,double s,double *c,
		 int *flag,double *incompat_err);
int e_as_overlap(struct p_data *p,int v,double r,double *c,
		 int *flag,double *incompat_err);
int h_anglesum_overlap(struct p_data *p,int i,double s,double *c,int *flag);
int h_anglesum(struct p_data *p,int i,double s,double *c,int *flag);
int norm_any_pack(struct p_data *p,complex a,complex g);
int place_face(struct p_data *p,int face,int indx);
int comp_center_face(struct p_data *p,int f,int flag);
int max_pack(struct p_data *p,char *datastr);
int select_vertex(struct p_data *p,int *index,int aimnum);
int s_radcalc_norm(struct p_data *p,double valence);
int ck_s_compat(struct p_data *p,int nf);
int s_deriv_sign(struct p_data *p,int i,double r);
int branch_order(struct p_data *p);
int h_curvcalc(struct p_data *p,int i,double s,double *c,double *d);
int call_test_repack(struct p_data *p,char *datastr);
int test_riffle(struct p_data *p,int passes,int test_cycles,
		int cmd,double tol);
int ck_pack_status(struct p_data *p,double tol);
int comparison(char *datastr,double x,double y);
int paren_parse(char **datastr,int *v,int *w);
int path_wrap(struct p_data *p,complex pt);
int symb_to_value(struct p_data *p,char *datastr,int node,int cf,double *val);
int check_red_chain(struct p_data *p);
int diag_hanging_verts(struct p_data *p);
int diag_small_rads(struct p_data *p);
int diag_int_connected(struct p_data *p);
int cir_placement_data(struct p_data *p,int v);
int placement_err(struct p_data *p,double tolr);
int ideal_bdry_node(struct p_data *p,int v);
int complex_count(struct p_data *p,int flag);
int gen_mark(struct p_data *p,char *datastr);
int remove_edge(struct p_data *p,int v1,int v2);
int swap_nodes(struct p_data *p,int v,int w);
int reverse_orient(struct p_data *p);
int double_K(struct p_data *p,char *datastr);
int adjoin(struct p_data *p1,struct p_data *p2,
	   int v1,int v2,int n,int **Oldnew);
int close_up(struct p_data *p,int vert);
int set_radii(struct p_data *p,double rad,char *datastr);
int set_overlap(struct p_data *p,int v,int j,double angle);
int add_circles(struct p_data *p,char *datastr);
int seed_pack(struct p_data *p,int hes,int n);
int copy_pack(struct p_data *p1,struct p_data *p2);
int copy_redlist(struct p_data *p2,struct p_data *p1);
int set_default_overlaps(struct p_data *p);
int set_plot_flags(struct p_data *p,char *datastr);
int add_vert(struct p_data *p,int v);
int enfold(struct p_data *p,int p1);
int slit_complex(struct p_data *p,char *datastr);
int open_edge(struct p_data *p,int v,int w);
int add_layer(struct p_data *p,int v1,int v2,int n,int *flag);
int add_barys(struct p_data *p,char *datastr);
int add_barycenter(struct p_data *p,int f);
int split_flips(struct p_data *p,char *datastr,int flag);
int split_edge(struct p_data *p,int v,int w);
int flip_edge(struct p_data *p,int v,int w,int flag);
int hex_refine(struct p_data *q);
int vert_for_edge(struct p_data *p,int v,int j);
int gen_cut(struct p_data *p,int v,int gen);
int face_ready(struct p_data *p,int face,int *index);
int readpack(FILE *fp,struct p_data *p);
int writepack(FILE *fp,struct p_data *p,int act,int append);
int readpath(FILE *fp,struct Pathlist **pathlist,int *pathlength);
int writepath(FILE *fp,struct Pathlist *pathlist);
int read_light(FILE *fp,struct p_light **plight,int flag);
int write_light(FILE *fp,struct p_light *pl,int flag);
int read_parent_child(char *filename,struct p_data *parentpacking,
		      struct p_light ***plight);
int output_mobius(FILE *fp,Mobius mob);
int hex_parallel_call(struct p_data *p,int v,int w,int n,complex *cmod,
		      int show);
int reset_screen_box(struct s_data *q,int width,int height);
int post_any_geo(FILE *fp,struct p_data *p,complex a,complex b,
	       int eflag,int col);
int post_in_order(FILE *fp,struct p_data *p,int cflag,int fflag,int pl);
int post_shape(FILE *fp,char symb);
int post_any_polygon(FILE *fp,struct p_data *p,
		     struct Vertlist *vertlist,int eflag,int ecol,int col);
int e_compcenter(complex z1,complex z2,complex *z3,
		 double e1,double e2,double *e3,
		 double o1,double o2,double o3);
int e_to_h_data(complex e_center,double e_rad,
		complex *h_center,double *s_rad);
int h_to_e_data(complex h_center,double s_rad,
		complex *e_center,double *e_rad);
int circle_3(complex z1,complex z2,complex z3,complex *c,double *rad);
int h_compcenter(complex z1,complex z2,complex *z3,
		 double s1,double s2,double *s3,
		 double o1,double o2,double o3);
int h_horo_center(complex z1,complex z2,complex *z3,
		  double s1,double s2,double *s3,
		  double o1,double o2,double o3);
int h_geodesic(complex a,complex b,hyp_geodesic *hg);
int tangent(complex ctr1,complex ctr2,double *T);
int s_compcenter(complex z1,complex z2,complex *z3,
		 double r1,double r2,double *r3,
		 double o1,double o2,double o3);
int s_pt_to_vec(complex z,double *V);
int s_to_e_data(complex z,double r,complex *e,double *er);
int e_to_s_data(complex z,double r,complex *s,double *sr);
int pt_in_sph_tri(complex pt,complex z1,complex z2,complex z3);
int sph_rotation(double alpha,double beta,double gama,
		 double M[3][3],double invM[3][3]);
int mat_mult(double A[3][3],double B[3][3],double C[3][3]);
int s_to_matrix_data(complex center,double rad,Mobius *C);
int matrix_to_s_data(Mobius C,complex *center,double *rad);
int blue_to_red_ramp(int flag);
int find_path_int(struct p_data *p);
int comp_pack_centers(struct p_data *p,int errflag,int dflag,int opt,
		     double crit);
int writeeucldata(struct p_data *p,char *filename);
int NS_mobius(complex zN,complex zS,complex zE,
	      double rN,double rS,double rE,double factor,
	      int *errflag,Mobius *Mob);
int e_pack_light_uniform(struct p_light *pl,int passes,double tolr,
		      int repack_method,long *elapsetime);
int h_pack_light_uniform(struct p_light *pl,int passes,double tolr,
		      int repack_method,long *elapsetime);
int layer_decompose(struct p_data *p,struct p_light **grains,
		    int spread,int overlp,int mx,int max_grains);
int vert_draw_order(struct p_data *p);
int flat_hex(struct p_data *p,char *datastr);
int rect_ratio(struct p_data *p,char *datastr,double *aspect);
int adjacency(FILE *pf,struct p_data *p);
int build_j_function(struct p_data *p,int n0,int n1,int maxsize);
int identify_nghbs(struct p_data *p,int v,int *alive,int *dead);
int grab_one_vert(struct p_data *p,char **ptr);
int screen_focus(struct s_data *p,complex ctr);
int comb_deep_ck(struct p_data *p,int *vert);
int convert_from_p_light(struct p_data *p,struct p_light *pl,int flag);
int sphere_view(struct s_data *q,char *datastr);
int set_screen(struct p_data *p,char *datastr);
int fix_call(struct p_data *p,char *datastr);
int layout_report(struct p_data *p,int v,int flag);
int msg();
int emsg();
int time_to_hms(long elapsetime,int *hr,int *min,int *sec);
int set_cp_globals();

long get_time();

double check_red_layout(struct p_data *p);
double dot_prod(double V[3],double W[3]);
double cross_prod(double X[3],double Y[3],double Z[3]);
double vec_norm(double X[3]);
double aTan2(double y,double x);
double s_dist(complex z1,complex z2);
double s_comp_cos(double r1,double r2,double r3,int *flag);
double h_comp_cos(double s1,double s2,double s3);
double h_area(double s1,double s2,double s3);
double h_cos_overlap(double s1,double s2,double s3,
		     double t1,double t2,double t3,int *flag);
double h_cos_overlap_special(double s1,double s2,double s3,
			     double t1,double t2,double t3,int *flag,
			     double *incompat_err);
double h_edge_length(double s1,double s2,double ovlp);
double h_horo_rad(double s1,double ovlp);
double comp_single_angle(struct p_data *p,int v,int u,int w,int *flag);
double radius_pl(struct p_light *pl,int v);
double radius(struct p_data *p,int v);
double s_star_area(struct p_data *p,int v);
double gwrand();
double max_r_adjustment (struct p_data *p,int v);
double seg_dist(complex pt,complex p1,complex p2);
double comp_inv_dist(struct p_data *p,int v,int w);
double curv_aim_error(struct p_data *p);
double e_radcalc(struct p_data *p,int i,double r,double aim,int *chgflag);
double h_radcalc(struct p_data *p,int i,double s,double aim,int *chgflag);
double s_radcalc(struct p_data *p,int v,double r,double aim,int *chgflag);
double s_carrier_area(struct p_data *p);
double h_radcalc_binary(struct p_data *p,int i,double s,double aim,
			int *chgflag,int cmd);
double e_radcalc_binary(struct p_data *p,int i,double s,double aim,
			int *chgflag,int cmd);
double invdist_err(struct p_data *p,int v,int w);
double e_area(double r1,double r2,double r3);
double e_cos_overlap(double e1,double e2,double e3,
		     double t1,double t2,double t3,int *flag);
double R3_dist(complex z,complex w);
double e_cos_overlap_special(double e1,double e2,double e3,
			     double t1,double t2,double t3,
			     int *flag,double *incompat_err);
double Fx(double x,double y,double z);
double Fy(double x,double y,double z);
double Fz(double x,double y,double z);
double cAbs(complex z);
double Arg(complex w);
double inv_dist(complex z1,double r1,complex z2,double r2);

complex cadd(complex z1,complex z2);
complex cmult(complex z1,complex z2);
complex csub(complex z1,complex z2);
complex cconj(complex z1);
complex cdiv(complex z1,complex z2);
complex cexp(double r,double t);
complex cLog(complex w);
complex proj_pt_to_sph(double x,double y);
complex proj_vec_to_sph(double x,double y,double z);
complex ss_view(struct s_data *q,complex pt,int flag,int *front);
complex proj_to_sph(double a,double b);
complex s_pt_to_visual_plane(complex pt);
complex screen_to_s_pt(complex pt,int *hit);
complex sph_tri_center(complex z1,complex z2,complex z3);

char *pair_picking(char *datastr,char start_char,char end_char,char **endptr);

struct p_light *convert_to_p_light(struct p_data *p);

struct Vertlist *path_construct(struct p_data *p,int flag,char *datastr);
struct Vertlist *try_hex_pg(struct p_data *p,int v,int w,int n,
			    int *v1,int *v2,int *v3,int *v4);
struct Vertlist *Node_link_parse(struct p_data *p,char *dpoint,
				 char **endptr,int *hits,
				 struct Vertlist **Vlist,
				 struct Edgelist **Elist,
				 struct Vertlist **Flist,
				 Region *region,struct Pathlist *pathlist,
				 int pathlength);
struct Vertlist *Face_link_parse(struct p_data *p,char *dpoint,
				 char **endptr,int *hits,
				 struct Vertlist **Vlist,
				 struct Edgelist **Elist,
				 struct Vertlist **Flist,
				 Region *region,struct Pathlist *pathlist,
				 int pathlength);
struct Edgelist *Node_pair_link(struct p_data *p,char *dpoint,
				char **endptr,int *hits,
				struct Vertlist **Vlist,
				struct Edgelist **Elist,
				struct Vertlist **Flist,
				Region *region,struct Pathlist *pathlist,
				int pathlength);
struct Vertlist *brace_parse(struct p_data *p,char *datastr,
			     int *n_flag,char **lastptr,
			     struct p_data *pack_data);
struct Vertlist *path_follow(struct p_data *p,
			     struct Edgelist *edgelist,int flag);
struct Vertlist *extended_edge_verts(struct p_data *p,int v1,int v2,int lgth);
struct Edgelist *get_extended_edge(struct p_data *p,int v1,int v2,int lgth);
struct Edgelist *node_to_edge(struct p_data *p,struct Vertlist *vertlist);

struct Pathlist *s_geodesic(complex z1,complex z2,int num_plot);
struct Pathlist *full_s_geodesic(complex z1,complex z2,int num_plot);
struct Pathlist *s_circle_list(complex ctr,double r,int num_plot);
struct Pathlist *sph_tri_list(complex z0,complex z1,complex z2,int num_plot);
struct Pathlist *fix_convex_list(struct Pathlist *inlist);

struct RedList *build_gen_redlist(struct p_data *p,int seed,
				  int *vec_seed,int gen,int *count);

struct BdryData *organize_bdry_data(struct p_data *p,
				    struct RedList *redlist);
struct BdryData *drop_bd(struct BdryData **ptr,struct BdryData **bd_ptr);

XPoint *path_XPoints(struct s_data *q,struct Pathlist *path,int *length);

/* fix_Pages_stuff.c   for renumbering postscript Pages */

int renumber_ps_Pages(char *filename);
long find_Page(FILE *fp,long *start,int flag);
int count_Pages(FILE *fp);

/* simplify_redchain.c  for finding simply connect subcomplex */
int simplify_redchain(struct p_data *p,struct RedList **redlist,
		      struct Edgelist *lifeline,int keep_vert,
		      struct RedList *keep_ptr);
int ck_in_elist(struct Edgelist *elist,int v,int w);
struct RedList *build_fan(struct p_data *p,int vert,int indx1,
			  int indx2,int *flag,int *count);
int jump_down_red(struct p_data *p,struct RedList *start,int start_vert,
		  struct RedList **new_ptr,struct RedList *keep_ptr,
		  int *hit_flag);
struct RedList *upstream_red(struct p_data *p,int vert,
			     struct RedList *redlist,int *up_indx);
struct RedList *downstream_red(struct p_data *p,int vert,
			       struct RedList *redlist,int *down_indx);

/* remote_comm_stuff.c for commun between CirclePack and remote processes */
int r_msg(char *msg);
int r_emsg(char *msg);
int r_cmsg(char *msg);
int r_dmsg(char *msg);
int r_lock_set(int pnum);
int r_unlock(int pnum);
int r_pack_read(struct p_data *p,int pnum,int opt);
int r_pack_write(struct p_data *p,int qnum,int opt);
int r_path_read(struct Pathlist **pathlist,int *pathlength);
int r_path_write(struct Pathlist *pathlist,int pathlength);
int r_get_pack_size(FILE *fp,struct p_data *p);
int r_done_signal();

/* random_walk_stuff.c */
double G(double x,double y,double z);
double G1(double x,double y,double z);
double G2(double x,double y,double z);
double G3(double x,double y,double z);
double g(double x,double y,double z);
double g1(double x,double y,double z);
double g2(double x,double y,double z);
double g3(double x,double y,double z);
double area_div(struct p_data *p,int v);
double Av(double v,double u,double w);
double dtheta_dlog(struct p_data *p,int v);
double twin_conductance(struct p_data *p,int v);
double Cvw(double v,double u,double w,double a,int flag,int hes);
double node_conductance(struct p_data *p,int v);
double edge_conduct(struct p_data *p,int v,int indx);

/* gauss_curv_stuff.c Gaussian curvature stuff */
int kappa_calc(struct p_data *p,int v,double *kap);
double pos_k_angle_sum(double c,double *R,int m);
double neg_k_angle_sum(double c,double *R,int m);
int color_kappa(struct p_data *p,double base);

/* set_color_stuff.c */
int radius_col_comp(struct p_data *p);
int area_col_comp(struct p_data *p);
int h_compare_area(struct p_data *p,struct p_data *q);
int h_compare_cl(struct p_data *p,struct p_data *q);
int e_compare_cl(struct p_data *p,struct p_data *q);
int e_compare_area(struct p_data *p,struct p_data *q);

/* map_stuff.c */
int vertex_translation(struct Edgelist *vertex_map,int v);
int vertex_rev_translation(struct Edgelist *vertex_map,int w);
int face_translation(struct p_data *p,int nf,struct p_data *q);
int face_rev_translation(struct p_data *p,int nf,struct p_data *q);
int map_list(struct p_data *p,struct p_data *q,char *datastr,
	     int mode,int rev_flag);

/* weld_stuff.c */
int weldcall(char *datastr);
int weld(int pnum1,int pnum2,int v,int w,char *filename);

/* set_face_stuff.c setting technical parameters of faces */
int set_face_next(struct p_data *p,char *datastr);
int set_face_index(struct p_data *p,char *datastr);
int set_face_red(struct p_data *p,char *datastr);
int set_face_rnext(struct p_data *p,char *datastr);

/* s_draw_objs.c */
int s_triangle(struct s_data *q,complex p1,complex p2,complex p3,
	       int fflag,int ecol,int fcol,int show);
int s_polygon(struct p_data *p,struct Vertlist *vertlist,
	      int fflag,int ecol,int fcol,int show);
int s_draw_convex(struct s_data *q,struct Pathlist *list,int fflag,
		  int ecol,int col,int show);
struct Pathlist *sph_poly_list(struct p_data *p,struct Vertlist *v_list);
int sgeo(struct s_data *q,complex a,complex b,int col,int show);
int s_circle(struct s_data *q,complex ctr,double r,int cflag,
	     int ccol,int col,int show);
int equator(struct s_data *q);

/* s_post_objs.c */
int post_s_tri(FILE *fp,complex p1,complex p2,complex p3,
	       int fflag,int ecol,int col);
int post_s_convex(FILE *fp,struct Pathlist *slist,
		  int eflag,int ecol,int col);
int post_s_geo(FILE *fp,struct s_data *screen,complex z1,complex z2);
int post_s_cir(FILE *fp,double rad,complex ctr,int cflag,int ccol,int col);
int post_equator(FILE *fp,struct s_data *q);

/* h_draw_objs.c */
int h_triangle(struct s_data *q,complex p1,complex p2,complex p3,
	       int fflag,int ecol,int fcol,int show);
int h_polygon(struct p_data *p,struct Vertlist *vertlist,
	      int fflag,int ecol,int fcol,int show);
int hgeo(struct s_data *q,complex a,complex b,int col,int show);

/* eucl drawing routines in e_draw_objs.c */
int kline(struct s_data *q,complex end1,complex end2,int col,int show);
int e_triangle(struct s_data *q,complex p1,complex p2,complex p3,
	       int fflag,int ecol,int fcol,int show);
int e_polygon(struct p_data *p,struct Vertlist *vertlist,
	      int fflag,int ecol,int fcol,int show);

/* draw_text_stuff.c  routines for labels, etc. */
int draw_node_labels(struct p_data *p,int show);
int draw_cir_number(struct p_data *p,int v,int n,int show);
int write_at_pt(struct p_data *p,complex pt,char *datastr,int show);
int draw_face_labels(struct p_data *p,int show);
int draw_face_number(struct p_data *p,int face,int n,int show);
int shownumber(struct s_data *q,int n,complex pt,int show);

/* post_text_stuff.c */
int post_cir_label(FILE *fp,struct p_data *p,int v);
int post_caption(FILE *fp,char *datastr);
int post_face_label(FILE *fp,struct p_data *p,int face);
int post_num(FILE *fp,complex pt,int n,Box box);

/* draw_circle_stuff.c */
int draw_any_circle(struct p_data *p,int n,int cflag,
		    int ccol,int col,int show);
int draw_any_circle_data(struct s_data *q,int hes,double r,complex ctr,
			 int cflag,int ccol,int col,int label,int show);
int draw_any_dot(struct p_data *p,int v,double diam,int cf,
		 int shape_flag,int show);
int draw_circles(struct p_data *p,int cflag,int show);
int circle(struct s_data *q,complex ctr,double r,int cflag,
	   int ccol,int col,int show);
int polyarc(struct s_data *q,double rad,complex ctr,double a1,double a2);
int unitcircle(struct s_data *q);

/* post_circle_stuff.c */
int post_any_circle(FILE *fp,struct p_data *p,int vert,
		    int cflag,int ccol,int col);
int post_any_circle_data(FILE *fp,struct s_data *q,int hes,double r,
			 complex ctr,int cflag,int ccol,int col,int label);
int post_cir(FILE *fp,double rad,complex ctr,
	     int cflag,int ccol,int col);
int post_any_dot(FILE *fp,struct p_data *p,int v,double diam,
		 int cflag,int shape_flag);


/* draw_face_stuff.c   drawing edges, faces, complex, bdry, etc */
int layout_facelist(struct p_data *p,int fflag,struct Vertlist **facelist,
		    int fix,int l_face,int show);
int draw_complex(struct p_data *p,int fflag,int show);
int draw_edge_points(struct s_data *q,int hes,complex v_cent,
		     complex w_cent,int col,int show);
int draw_edge(struct p_data *p,int v1,int v2,int col,int show);
int draw_bdry_seg(struct p_data *p,int n,int eflag,int ecol);
int draw_bdry_seg_num(struct p_data *p,int n);
int draw_any_face(struct p_data *p,int face,int fflag,
	      int ecol,int fcol,int show);

/* post_face_stuff.c */
int post_facelist(FILE *fp,struct p_data *p,int fflag,
		  struct Vertlist **facelist,int fix,int l_face);
int post_bdry_seg(FILE *fp,struct p_data *p,int n,int eflag,int ecol);
int post_bdry_seg_num(FILE *fp,struct p_data *p,int n);
int post_any_face(FILE *fp,struct p_data *p,int face,
		  int fflag,int ecol,int col);

/* post_ops_stuff.c  opening/managing/closing postscript files */
int open_psfile(struct p_data *p,int flag,char *datastr,
		FILE **FP,char *filename,char *user_name,char *Message);
int close_psfile(FILE **FP);
int begin_page_info(FILE *fp,struct p_data *p,int n);
int position_after(FILE *fp,char *datastr);
int position_before(FILE *fp,char *datastr);
int post_size_settings(FILE *fp,struct p_data *p,int flag);
int custom_trailer(FILE *fp,int flag);

/* mobius_math.c */
Mobius ident_mob();
int matrix_conj(Mobius *M);
int matrix_transpose(Mobius *M);
Mobius matrix_product(Mobius A,Mobius B);
complex det(Mobius M);
Mobius inv_mob(Mobius M);
Mobius trans_abAB(complex a,complex b,complex A,complex B,
		  int *err_flag);
Mobius auto_abAB(complex a,complex b,complex A,complex B,
		 double *err,int *err_flag);
Mobius standard_mob(complex a,complex b,int *err_flag);
Mobius affine_mob(complex a,complex b,complex A,complex B,int *err_flag);
Mobius recip_mob();
int set_reflection(Mobius *M,complex ctr,double r);
Mobius cir_invert(complex ctr1,double rad1,complex ctr2,double rad2,
		  int *err_flag);
complex mobius(Mobius M,complex z,int flag);
complex mob_trans(complex z,complex a);
complex mob_rotate(complex z,double a);
complex mob_norm_inv(complex w,complex a,complex b);
complex mob_norm(complex z,complex a,complex b);
Mobius mult_mobius(Mobius M,Mobius C,int flag);
int mobius_of_circle(Mobius Mob,int hes,complex z,double r,
		     complex *newz,double *newr,int flag);

/*  alloc_stuff.c */
struct p_data *init_packing();
int alloc_pack_space(struct p_data *p,int new_size,int flag);
int alloc_faces_space(struct p_data *p);
int alloc_overlaps(struct p_data *p);
int alloc_edge_pair(struct p_data *p);

/* free_stuff.c */
int vert_free(struct Vertlist **vertlist);
int path_free(struct Pathlist **pathlist);
int edge_free(struct Edgelist **edgelist);
int free_redfaces(struct RedList **redlist);
int free_bdrydata(struct BdryData **bdrydata);
int free_overlaps(struct p_data *p);
int free_p_data(struct p_data **pack);
int free_p_light(struct p_light **plight);

/* grab_stuff.c */
int grab_next(char **ptr,char *next);
int grab_line(char *targ,char **sour,int n);
int stripsp(char *datastr);
int notspace(char *ptr);
char *after_char(char *datastr,char *target);


/* energy_comp_stuff.c */
int print_energy(struct p_data *p);
double comp_energy(struct p_data *p,double s);
double comp_min_dist(struct p_data *p);

/* generation_stuff.c */
int *label_generations(struct p_data *p,int max,int *last_vert,int *count);
int *label_seed_generations(struct p_data *p,int seed,int *vec_seed,
			    int max,int *far_vert,int *count);

/* geom_to_convert_stuff.c */
int geom_to_e_pack_convert(struct p_data *p);
int geom_to_h_pack_convert(struct p_data *p);
int geom_to_s_pack_convert(struct p_data *p);

/* pt_in_object_stuff.c */
struct Vertlist *cir_search(struct p_data *p,int x,int y);
int pt_in_cir(struct p_data *p,int n,int x,int y);
struct Vertlist *tri_search(struct p_data *p,int x,int y);
int pt_in_tri(struct p_data *p,int n,double x,double y);
double row_col(double x,double y,double xa,double xb,double ya,double yb);

/* set_abc_stuff.c */
int choose_alpha(struct p_data *p);
int choose_beta(struct p_data *p);
int choose_gamma(struct p_data *p);
int set_alpha(struct p_data *p,int i);
int set_beta(struct p_data *p,int i);
int set_gamma(struct p_data *p,int i);

/* set_aim_stuff.c */
int set_aim_current(struct p_data *p,int flag);
int set_aim_default(struct p_data *p);
int set_aims(struct p_data *p,char *datastr);

/* set_poison_stuff.c */
int outer_poison(struct p_data *p,struct Vertlist *facelist);
int set_poison(struct p_data *p,char *datastr);
int poison_patch(struct p_data *p,int seed,char *datastr);


/* cookie_stuff.c */
int cookie_cutter(struct p_data *p,char *datastr,int **newold);
int rationalize_subcomplex(struct p_data *p,int seed,
			   struct RedList *redlist,
			   struct Vertlist *fdo,int **newold);
int zero_duty_flags(struct BdryData *bdrydata);

/* e_riffle_stuff.c */
int e_riffle(struct p_data *p,int passes);
int old_e_riffle(struct p_data *p,int passes);
int new_e_riffle(struct p_data *p,int passes);
int e_riffle_vert(struct p_data *p,int i);

/* h_riffle_stuff.c */
int h_riffle(struct p_data *p,int passes);
int old_h_riffle(struct p_data *p,int passes);
int h_riffle_vert(struct p_data *p,int i);

/* s_riffle_stuff.c */
int s_riffle(struct p_data *p,int passes);
int s_riffle_vert(struct p_data *p,int i);

/* catalog_stuff.c */
int catalog_faces(struct p_data *p);
int destroy_catalog(int nodecount);

/* comb_util_stuff.c */
int nghb(struct p_data *p,int v,int w);
int find_index(struct p_data *p,int f,int v);
int nghb_tri(struct p_data *p,int m,int n);
int red_share_vert(struct p_data *p,struct RedList *redlist);
int check_face(struct p_data *p,int f,int v,int w);
int what_face(struct p_data *p,int a,int b,int c);
int cross_edge_vert(struct p_data *p,int v,int k);
int left_face(struct p_data *p,int v,int w,int *u);
int index_of_paired_edge(struct p_data *p,int n);
int hex_proj(struct p_data *p,int v,int w);
int hex_extend(struct p_data *p,int v,int w,int lgth);
int bdry_comp_count(struct p_data *p,int v);
int red_fan(struct p_data *p,struct RedList *redlist,int v,int *n1,int *n);
int common_nghbs(struct p_data *p,int v,int w);

/* consume_stuff.c */
int consume_one_index(struct Vertlist **vptr);
int consume_one_edge(struct Edgelist **eptr,int *v1,int *v2);

/* debug_stuff.c */
int showhandle(struct RedList *handle);
int showlist(struct Vertlist *vertlist);
int pfacered(struct p_data *p);
int print_redfaces(struct p_data *p,struct RedList *redfaces);
int print_flower(struct K_data *K,int v);
int pack_to_stderr(struct p_data *p);
int pack_face_draw_order(struct p_data *p);
int face_debug(struct p_data *p);
int list_non_plots(struct p_data *p);
int red_bug(struct RedList *redfaces);
int print_one_redface(FILE *fd,struct RedList *redface);
int print_redface(FILE *fd,struct RedList *redface);
int lightverts_q(struct p_light *pl);
int vertlist_q(struct p_data *p,struct Vertlist *vertlist);
int list_q(struct p_data *p,int *list);
int util_q(struct p_data *p);
int colorlist_q(struct p_data *p,int *list);
int redlist_q(struct p_data *p,struct RedList *redlist);
int record_redlist(struct RedList *redlist,int lim);
int record_bdrydata(struct p_data *p,struct BdryData *bdrydata,int **face_org);
int pford(struct p_data *p);
int ck_list(struct RedList *redlist);
int record_edge_pair(struct p_data *p);
int record_face_verts(struct p_data *p);
int print_pathlist(struct Pathlist *pathlist);

/* delete_vert_stuff.c */
int delete(struct p_data *p,int v);
int puncture(struct p_data *p,int v);
int remove_bdry_vert(struct p_data *p,int v);
int remove_tri_vert(struct p_data *p,int v);
int remove_quad_vert(struct p_data *p,char *datastr);
int remove_circle(struct p_data *p,char *datastr);

/* redchain_stuff.c */
struct RedList *build_redchain(struct p_data *p,int seed,
			       struct Vertlist *fdo);
int loop_vert(struct p_data *p,struct RedList **redlist,
	      struct Vertlist **fdo,struct RedList **stop_ptr,
	      int *tripflag,int mode,int *hit);
int redface_comb_info(struct p_data *p,struct RedList *redlist,
		      struct EdgePair *edge_pair);
int find_seg_start(struct p_data *p,struct RedList *redlist,
		   int indx,struct RedList **start_ptr,
		   int *start_indx,int *vert,int *flag);
int back_red_face(struct p_data *p,struct RedList **redlist,int vert);
int next_red_edge(struct p_data *p,struct RedList *spot_ptr,int indx,
		  struct RedList **down_ptr,int *down_indx,int dir);
int find_paired_start(struct p_data *p,struct RedList *redlist,int indx,
		      struct RedList **end_ptr,int *end_indx);
int add_face_to_redlist(struct p_data *p,int f,struct RedList **redptr);
int query_in_red(struct RedList *redlist,int face);
int add_face_order(struct p_data *p,struct Vertlist **fdo,
		   int face,int preface);

/* face_order_stuff.c */
int facedraworder(struct p_data *p,int pflag);
int final_order(struct p_data *p,struct Vertlist **fdo,
		int *lastface,struct RedList *redlist);
int wrapup_order(struct p_data *p,int lastface);
int position_redlist(struct RedList **redlist,int face);
int nice_index(struct p_data *p,int f,int index);

/* cp_X_draw.c  hooks to call Xlib drawing routines */
int SetForeground(unsigned long color,int fflag);
int DrawLines(Drawable xpm,XPoint *points,int npoints,
	      unsigned long color);
int DrawLine(Drawable xpm,int x1,int y1,int x2,int y2,
	     unsigned long color);
int DrawArc(Drawable xpm,int x,int y,
	    unsigned int width,unsigned int height,
	    int angle1,int angle2,unsigned long color);
int DrawString(Drawable xpm,int x,int y,char *text,int length);
int FillRectangle(Drawable xpm,int x,int y,
		  unsigned int width,unsigned int height);
int FillArc(Drawable xpm,int x,int y,
	    unsigned int width,unsigned int height,
	    int angle1,int angle2,
	    unsigned long color,int fflag);
int FillPolygon(Drawable xpm,XPoint *points,int npoints,
		unsigned long color);
int Flush();

/* blend_stuff.c */
int match(struct p_data *p,struct p_data *q,int v1,int v2,
	  int w1,int w2,double *err,int *err_flag,Mobius *M);
int comb_bdry_antip(struct p_data *p,int *v,int *w);
int blend(struct p_data *p,struct p_data *q,int bdry_vert,int depth);


