#ifndef TRACEMANAGER_H
#define TRACEMANAGER_H

#include <qdict.h>
#include <qdom.h>
#include <qlist.h>
#include <qlistview.h>
#include <qstring.h>

#include "TraceWindow.h"
#include "TraceModule.h"

class CTraceManager: public QObject
{
   Q_OBJECT
friend class CTraceModule;
private:
   CTraceWindowDlg *m_pWindow;
   QDict<CTraceModule> m_Modules;
   CTraceModule *m_pSelectedModule;

   int m_Indent;
   QString m_IndentString;
   QStringList m_FullText;
   bool m_ResetText;

   bool m_Visible;
   bool m_Mute;
   bool m_Output;
   bool m_CatchQDebug, m_CatchQWarning;
   bool m_AppendToFile;
   QString m_LogFileName;

   void OpenLog();
   void CloseLog();

   static void MessageHandler(QtMsgType type, const char *msg);

protected:
   CTraceManager();

   void IncIndent();
   void DecIndent();

protected slots:
   void ClickedListItem(QListViewItem *);
   void IncLogging();
   void DecLogging();

   void ToggledCatchQDebug(bool);
   void ToggledCatchQWarning(bool);
   void ToggledOutput(bool);
   void ToggledAppendToFile(bool);
   void SetLogFileName();

public:
   ~CTraceManager();

   static CTraceManager *Instance();
   CTraceModule *RegisterModule(const QString &module_name, int initial_value = 1);
   void Log(const QString &log_string);

   void GetConfiguration(QDomNode &);
   void SetConfiguration(const QDomNode &);

public slots:
   void Show();
   void Hide();
   void ClearText();
   void Mark();
   void SetMute(bool);
   void UseOutput(bool);
};

#endif
