#ifndef AUDIOSETTINGSDLG_HPP
#define AUDIOSETTINGSDLG_HPP

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qvector.h>

#include "AudioDevice.h"

#include "AudioSettings.h"

class CAudioSettingsDlg: public CAudioSettings
{
public:
   CAudioSettingsDlg(QWidget *parent = 0, const char *name = 0, bool modal = false);

   void PresetDevice(CAudioDevice *dev);

   const CAudioDevice *GetSelectedDevice() const;

protected:
   // Overloaded slots
   virtual void ChangedSelection(int);
   virtual void MixerButtonClicked();

   virtual void SamplerateChanged(int);
   virtual void BitdepthChanged(int);
   virtual void ChannelsChanged(int);

private:
   QVector<CAudioDevice *> m_Dropdown2Device;
   CAudioDevice *m_pCurrentDevice;
   CAudioRingBufferReader *m_pCurrentReader;

   void SetDevice(CAudioDevice *new_device);
   void EnableGUI(bool);
   void SetGUIFromDevice() const;

};


#endif
