# bug-triage -- bug triage and forward tool.
# Copyright (C) 2007  Gustavo R. Montesino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import pygtk
pygtk.require("2.0")
import gobject
import gtk

from config import packages
from msg_exception import errorhandler

class pkg_store(gtk.ListStore):
    """Data model for debian pkgs and related upstream data"""

    COLUMN_PACKAGE = 0
    COLUMN_TYPE = 1
    COLUMN_DATA = 2

    @errorhandler
    def __init__(self):
        
        gtk.ListStore.__init__(self,
            gobject.TYPE_STRING,
            gobject.TYPE_STRING,
            gobject.TYPE_STRING
            )

    @errorhandler
    def package_to_list(self, pkg):
        "Transform a package object into a list to use with ListStore methods"

        row = []
        row.append(pkg.get_package())
        row.append(pkg.get_type_str())
        row.append(", ".join(["%s=%s" % (k, v) for k,v in pkg.get_data().iteritems()]))

        return row

    @errorhandler
    def append(self, pkg):
        gtk.ListStore.append(self, self.package_to_list(pkg))
    
    @errorhandler
    def get(self, iter):
        """Returns the package pointed by a TreeIter"""

        pkg = packages.Package()
        pkg.set_package(gtk.ListStore.get(self, iter, self.COLUMN_PACKAGE)[0])
        pkg.set_type_str(gtk.ListStore.get(self, iter, self.COLUMN_TYPE)[0])

        data = {}
        options = gtk.ListStore.get(self, iter, self.COLUMN_DATA)[0].split(", ")
        for option in options:
            (field, value) = option.split("=")
            data[field] = value
        pkg.set_data(data)

        return pkg

# vim: tabstop=4 expandtab shiftwidth=4
