# bug-triage -- bug triage and forward tool.
# Copyright (C) 2007  Gustavo R. Montesino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade

import bt_exceptions
from config import btstype
from msg_exception import errorhandler

class dlg_package:
    """Dialog to fill package informations"""

    RESPONSE_CANCEL = 0
    RESPONSE_OK = 1

    @errorhandler
    def __init__(self, glade_path):
        self.xml = gtk.glade.XML(glade_path + "dlg_package.glade")
        self.xml.signal_autoconnect(self)

        self.dialog = self.xml.get_widget("dlg_package")

        self.xml.get_widget("cb_btstype").set_active(btstype.BUGZILLA)

    @errorhandler
    def btstype_changed(self, object=None):
        """When the current bts type is changed,
           flip the notebook tab to the right one"""
        
        nb_btsinfo = self.xml.get_widget("nb_btsinfo")
        cb_btstype = self.xml.get_widget("cb_btstype")

        nb_btsinfo.set_current_page(cb_btstype.get_active())

    @errorhandler
    def get_package(self):
        return self.xml.get_widget("entry_package").get_text()

    @errorhandler
    def set_package(self, package):
        self.xml.get_widget("entry_package").set_text(package)

    @errorhandler
    def get_type(self):
        return self.xml.get_widget("cb_btstype").get_active()

    @errorhandler
    def set_type(self, type):
        self.xml.get_widget("cb_btstype").set_active(type)

    @errorhandler
    def get_data(self):
        if self.get_type() == btstype.BUGZILLA:
            server = self.xml.get_widget("entry_server").get_text()
            product = self.xml.get_widget("entry_product").get_text()
            component = self.xml.get_widget("entry_component").get_text()
            data = { }

            if server != "":
                data["server"] = server

            if product != "":
                data["product"] = product

            if component != "":
                data["component"] = component

        else:
            raise bt_exceptions.InvalidBTSError("Invalid Upstream BTS Type")

        return data

    @errorhandler
    def set_bz_server(self, server):
        self.xml.get_widget("entry_server").set_text(server)
    
    @errorhandler
    def set_bz_product(self, product):
        self.xml.get_widget("entry_product").set_text(product)

    @errorhandler
    def set_bz_component(self, component):
        self.xml.get_widget("entry_component").set_text(component)

    @errorhandler
    def run(self):
        return self.dialog.run()

    @errorhandler
    def hide(self):
        return self.dialog.hide()
 
# vim: tabstop=4 expandtab shiftwidth=4
