# bug-triage -- bug triage and forward tool.
# Copyright (C) 2007  Gustavo R. Montesino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

from btsutils.soap import soap
from btsutils.html import html
import ConfigParser, os

class Config(ConfigParser.ConfigParser):
    """Class to handle the main configuration file"""

    def __init__(self):
        self.filename = os.path.expanduser("~/.bug-triage/bug-triage.conf")
        ConfigParser.ConfigParser.__init__(self)
        self.read([self.filename])

    def write(self):
        if not os.path.isdir(os.path.dirname(self.filename)):
            os.mkdir(os.path.dirname(self.filename))

        f = open(self.filename, 'w')
        ConfigParser.ConfigParser.write(self, f)

    def set(self, section, option, value):
        if not self.has_section(section):
            self.add_section(section)

        ConfigParser.ConfigParser.set(self, section, option, value)

    def get_soap_address(self):
        try:
            return self.get("soap", "address")
        except (ConfigParser.NoSectionError, ConfigParser.NoOptionError):
            return soap.DEFAULT_URL

    def set_soap_address(self, address):
        self.set("soap", "address", address)

    def get_soap_namespace(self):
        try:
            return self.get("soap", "namespace")
        except (ConfigParser.NoSectionError, ConfigParser.NoOptionError):
            return soap.DEFAULT_NS

    def set_soap_namespace(self, namespace):
        self.set("soap", "namespace", namespace)

    def get_soap_users(self):
        try:
            return self.get("soap", "users").split(", ")
        except (ConfigParser.NoSectionError, ConfigParser.NoOptionError):
            return []

    def set_soap_users(self, users):
        self.set("soap", "users", ", ".join(users))

    def get_html_address(self):
        try:
            return self.get("html", "address")
        except (ConfigParser.NoSectionError, ConfigParser.NoOptionError):
            return html.DEFAULT_URL

    def set_html_address(self, address):
        self.set("html", "address", address)

    def get_html_users(self):
        try:
            return self.get("html", "users").split(", ")
        except (ConfigParser.NoSectionError, ConfigParser.NoOptionError):
            return []

    def set_html_users(self, users):
        self.set("html", "users", ", ".join(users))

    def get_bts_method(self):
        try:
            return self.get("bts", "method")
        except (ConfigParser.NoSectionError, ConfigParser.NoOptionError):
            return "default"

    def set_bts_method(self, method):
        self.set("bts", "method", method)

# vim: tabstop=4 expandtab shiftwidth=4
