/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_DIFFVIEWER_H
#define INCLUDED_DIFFVIEWER_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class QTextBrowser;
class QPushButton;
class SystemCall;
class QHBoxLayout;
class QVBoxLayout;

/*------- class declaration:
-------------------------------------------------------------------*/
class DiffViewer : public QDialog
{
	Q_OBJECT
	
// ******* CONSTRUCTION *******
public:
	DiffViewer( QWidget* const, const QString&, const QString& );
	~DiffViewer();
private:
	DiffViewer( const DiffViewer& );
	DiffViewer& operator=( const DiffViewer& );

// ******* CONSTANTS *******
private:
	static const QString Caption;
	static const QString FileMusters;

// ******* MEMBERS *******
private:
	QVBoxLayout*  const d_main_layout;
	QHBoxLayout*  const d_btn_layout;
	QTextBrowser* const d_browser;
	QPushButton*  const d_save_btn;
	QPushButton*  const d_close_btn;
	SystemCall*         d_syscall;

// ******* METHODS *******
private:
	void polish    ();
private slots:
	void slot_save ();
	void finished  ( int );
};

#endif // INCLUDED_DIFFVIEWER_H
