
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>

#include "brightoninternals.h"

brightonKeyPress(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonKeyPress(%i)\n", event->key);

	if (event->key == 33)
		brightonXpmWrite(bwin, "/tmp/image.xpm");
	if (event->key == 24)
	{
		brightonRemoveInterface(bwin);
	}

	if ((bwin->activepanel = brightonPanelLocator(bwin, event->x, event->y))
		> 0)
	{
		if (bwin->activepanel->configure)
			bwin->activepanel->configure(bwin, bwin->activepanel, event);
	}
}

brightonKeyRelease(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonKeyRelease(%i): %x\n", event->key, bwin->activepanel);

	if ((bwin->activepanel = brightonPanelLocator(bwin, event->x, event->y))
		> 0)
	{
		if (bwin->activepanel->configure)
			bwin->activepanel->configure(bwin, bwin->activepanel, event);
	}
}

brightonButtonPress(brightonWindow *bwin, brightonEvent *event)
{
	int dev;

//	printf("brightonButtonPress(%i)\n", bwin->id);
	/*
	 * We need to determine which device is under the selection, and force
	 * statefull delivery of events to that device for further motion.
	 */
	bwin->activepanel = 0;

	if ((bwin->activepanel = brightonPanelLocator(bwin, event->x, event->y))
		> 0)
	{
		bwin->flags |= BRIGHTON_DEV_ACTIVE;

		event->command = BRIGHTON_BUTTONPRESS;

		if (bwin->activepanel->configure)
			bwin->activepanel->configure(bwin, bwin->activepanel, event);
	} else
		bwin->flags &= ~BRIGHTON_DEV_ACTIVE;
}

brightonButtonRelease(brightonWindow *bwin, brightonEvent *event)
{
	brightonIResource *panel;

//	printf("brightonButtonRelease(%x, %x, %x)\n", bwin, bwin->activepanel,
//		bwin->activepanel->configure);

	event->command = BRIGHTON_BUTTONRELEASE;

	if (bwin->activepanel && bwin->activepanel->configure)
		bwin->activepanel->configure(bwin, bwin->activepanel, event);

	/*
	 * We need to determine which device is under the selection, and force
	 * statefull delivery of events to that device for further motion.
	if ((panel = brightonPanelLocator(bwin, event->x, event->y)) > 0)
	{
		event->command = BRIGHTON_BUTTONRELEASE;

		if (bwin->activepanel->configure)
			bwin->activepanel->configure(bwin, bwin->activepanel, event);
	}
	 */

	bwin->flags &= ~BRIGHTON_DEV_ACTIVE;
	bwin->activepanel = 0;
}

brightonMotionNotify(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonMotionNotify(%i)\n", bwin->activepanel);

	if ((bwin->flags & BRIGHTON_DEV_ACTIVE) && (bwin->activepanel != 0))
	{
		if (bwin->activepanel->configure)
			bwin->activepanel->configure(bwin, bwin->activepanel, event);
	}
}

brightonEnterNotify(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonEnterNotify()\n");
}

brightonLeaveNotify(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonLeaveNotify()\n");
}

brightonFocusIn(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonFocusIn()\n");
}

brightonFocusOut(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonFocusOut()\n");
}

brightonKeymapNotify(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonKeymapNotify()\n");
}

brightonExpose(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonExpose(%i %i %i %i): %i\n",
//		event->x, event->y, event->w, event->h);

	BCopyArea(bwin->display, 
		event->x, event->y, event->w, event->h, event->x, event->y);
}

brightonGraphicsExpose(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonGraphicsExpose()\n");
}

brightonNoExpose(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonNoExpose()\n");
}

brightonVisibilityNotify(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonVisibilityNotify()\n");
}

brightonCreateNotify(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonCreateNotify()\n");
}

brightonDestroyNotify(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonDestroyNotify()\n");
}

brightonUnmapNotify(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonUnmapNotify()\n");
}

brightonMapNotify(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonMapNotify()\n");
}

brightonMapRequest(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonMapRequest()\n");
}

brightonReparentNotify(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonReparentNotify()\n");
}

brightonConfigureNotify(brightonWindow *bwin, brightonEvent *event)
{
//	printf("brightonConfigureNotify(%i, %i, %i, %i)\n",
//		event->x, event->y, event->w, event->h);

	if (bwin->flags & BRIGHTON_SET_SIZE)
	{
		bwin->flags &= ~BRIGHTON_SET_SIZE;
		return;
	}

	if ((bwin->width != event->w) || (bwin->height != event->h))
		brightonWorldChanged(bwin, event->w, event->h);

	if ((bwin->width != event->w) || (bwin->height != event->h))
		BResizeWindow(bwin->display, bwin, bwin->width, bwin->height);
}

brightonConfigureRequest(brightonWindow *bwin, brightonEvent *event)
{
	printf("brightonConfigureRequest()\n");
}

brightonGravityNotify(brightonWindow *bwin, brightonEvent *event)
{
	printf("brightonGravityNotify()\n");
}

brightonResizeRequest(brightonWindow *bwin, brightonEvent *event)
{
	printf("brightonResizeRequest()\n");

	if ((bwin->width != event->w) || (bwin->height != event->h))
	{
		/*
		 * Our size has changed. We need to re-render the background, and then 
		 * repaint it.
		 */
		brightonWorldChanged(bwin, event->w, event->h);

/*
		if ((bwin->width != event->w) || (bwin->height != event->h))
			BResizeWindow(bwin->display, bwin->win, bwin->width, bwin->height);
*/
	}
}

brightonCirculateNotify(brightonWindow *bwin, brightonEvent *event)
{
	printf("brightonCirculateNotify()\n");
}

brightonCirculateRequest(brightonWindow *bwin, brightonEvent *event)
{
	printf("brightonCirculateRequest()\n");
}

brightonPropertyNotify(brightonWindow *bwin, brightonEvent *event)
{
	printf("brightonPropertyNotify()\n");
}

brightonSelectionClear(brightonWindow *bwin, brightonEvent *event)
{
	printf("brightonSelectionClear()\n");
}

brightonSelectionRequest(brightonWindow *bwin, brightonEvent *event)
{
	printf("brightonSelectionRequest()\n");
}

brightonSelectionNotify(brightonWindow *bwin, brightonEvent *event)
{
	printf("brightonSelectionNotify()\n");
}

brightonColormapNotify(brightonWindow *bwin, brightonEvent *event)
{
	printf("brightonColormapNotify()\n");
}

brightonClientMessage(brightonWindow *bwin, brightonEvent *event)
{
	printf("brightonClientRequest()\n");
}

brightonMappingNotify(brightonWindow *bwin, brightonEvent *event)
{
	printf("brightonMappingNotify()\n");
}

brightonNullHandler(brightonWindow *bwin, brightonEvent *event)
{
	printf("brightonNullHandler()\n");
}

typedef int (*eventRoutine)(brightonWindow *, brightonEvent *);

eventRoutine defaultHandlers[BLASTEvent] = {
	brightonNullHandler,
	brightonNullHandler,
	brightonKeyPress,
	brightonKeyRelease,
	brightonButtonPress,
	brightonButtonRelease,
	brightonMotionNotify,
	brightonEnterNotify,
	brightonLeaveNotify,
	brightonFocusIn,
	brightonFocusOut,
	brightonKeymapNotify,
	brightonExpose,
	brightonGraphicsExpose,
	brightonNoExpose,
	brightonVisibilityNotify,
	brightonCreateNotify,
	brightonDestroyNotify,
	brightonUnmapNotify,
	brightonMapNotify,
	brightonMapRequest,
	brightonReparentNotify,
	brightonConfigureNotify,
	brightonConfigureRequest,
	brightonGravityNotify,
	brightonResizeRequest,
	brightonCirculateNotify,
	brightonCirculateRequest,
	brightonPropertyNotify,
	brightonSelectionClear,
	brightonSelectionRequest,
	brightonSelectionNotify,
	brightonColormapNotify,
	brightonClientMessage,
	brightonMappingNotify
};

void brightonInitDefHandlers(brightonWindow *bwin)
{
	int i;

	for (i = 0; i < BLASTEvent; i++)
		bwin->callbacks[i] = defaultHandlers[i];
}

void
brightonEventLoop(brightonDisplay **dlist)
{
	brightonDisplay *display;
	brightonEvent event;
	brightonWindow *bwin = (brightonWindow *) (*dlist)->bwin;

	while (1) {
		BNextEvent(bwin->display, &event);

		if (event.command == BRIGHTON_NONE)
			continue;

	//printf("event %i\n", event.command);
		/*
		 * Look for the right window.
		 */
		display = *dlist;

		while (display != 0)
		{
//printf("display %x, next %x\n", display, display->next);
			if ((brightonWindow *) event.wid ==
				((brightonWindow *) display->bwin)->win)
				break;

			display = display->next;
		}

		if ((display == 0 || (event.type < 0) || (event.type >= BLASTEvent)))
			continue;

		((brightonWindow *) display->bwin)->callbacks[event.type]
			(display->bwin, &event);
	}
}

