// *************************************************************************
//
// Copyleft 2004-2007 Bruno PAGES  .
//
// This file is part of the BOUML Uml Toolkit.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// e-mail : bouml@free.fr
// home   : http://bouml.free.fr
//
// *************************************************************************

#include <qcstring.h>

#include "util.h"

void conditional(QCString & s, const char * if_def, const char * end_if)
{
  if (if_def != 0) {
    const char * p = s;
    const char * p2 = p;
    
    while ((*p2 == ' ') || (*p2 == '\t'))
      p2 += 1;
    
    s.insert(p2 - p, QCString("#ifdef ") + if_def + "\n");
  }
  
  if (end_if != 0)
    s.append((((const char *) s)[s.length() - 1] == '\n')
	     ? "#endif\n"
	     : "\n#endif");
}

QCString java2Php(QCString s)
{
  int index;
  
  while ((index = s.find("JAVA")) != -1)
    s.replace(index, 4, "PHP");
  
  while ((index = s.find("Java")) != -1)
    s.replace(index, 4, "Php");
  
  while ((index = s.find("java")) != -1)
    s.replace(index, 4, "php");
  
  if ((index = s.find("produce a RuntimeException in Php")) != -1)
    s.replace(index + 30, 3, "Java");
  
  return s;
}

