var favoritesService=
{
	_BookmrksFolder:null,
	_FavoritesFolder:null,

	_RDFService:null,
	_DataSource:null,
	_Container:null,
	_urlArc:null,
	_nameArc:null,
	_descArc:null,

	_initInternal:function()
	{
		this._RDFService = Components.classes["@mozilla.org/rdf/rdf-service;1"]
											.getService(Components.interfaces.nsIRDFService);
		this._Container = Components.classes["@mozilla.org/rdf/container;1"]
										.getService(Components.interfaces.nsIRDFContainer);
		this._DataSource=this._RDFService.GetDataSource( "rdf:bookmarks" );
		this._DataSource.QueryInterface(Components.interfaces.nsIBookmarksService);
		this._RDFCUtils = Components.classes['@mozilla.org/rdf/container-utils;1']
						.getService(Components.interfaces.nsIRDFContainerUtils);
		this._Container.Init(this._DataSource,this._RDFService.GetResource("NC:BookmarksRoot"));

		this._urlArc=this._RDFService.GetResource( "http://home.netscape.com/NC-rdf#URL");
		this._nameArc=this._RDFService.GetResource( "http://home.netscape.com/NC-rdf#Name");
		this._descArc=this._RDFService.GetResource("http://home.netscape.com/NC-rdf#Description");
	},
	_init:function(aFile)
	{
		this._BookmrksFolder=this._RDFService.GetResource( getFolderId());
		this._FavoritesFolder=aFile;
	},

	exportFiles:function(aFolder)
	{
		this._initInternal();
		this._init(aFolder);
		var stream = Components.classes['@mozilla.org/network/file-output-stream;1']
    		                 .createInstance(Components.interfaces.nsIFileOutputStream);

		var foldersets=[[this._FavoritesFolder.clone(),this._BookmrksFolder]];

		while(foldersets.length>0)
		{
			var folderset= foldersets.shift();
			var folder=folderset[1];
			folder.QueryInterface(Components.interfaces.nsIRDFResource);
			this._Container.Init(this._DataSource, folder);
			var elements=this._Container.GetElements();
			while(elements.hasMoreElements())
			{
				var resource=elements.getNext();
				resource.QueryInterface(Components.interfaces.nsIRDFResource).Value;
				var name=this._getLiteral(resource,this._nameArc);
				name=name.replace(/\"/g,"\'");
				name=name.replace(/[\\\/\*:<>\?\|]/g,"-");
				var tempFile=folderset[0].clone();
				try{
				if(this._RDFCUtils.IsContainer(this._DataSource,resource))
				{
					tempFile.append(name);
					if(!tempFile.exists())
						tempFile.create(1,0666);
					foldersets.push([tempFile,resource]);
				}
				else if(this._DataSource.hasArcOut(resource,this._urlArc))
				{
					var url=this._getLiteral(resource,this._urlArc);
					var fileContents="[InternetShortcut]\r\nURL="+url+"\r\n";
					tempFile.append(name+".url");
      		stream.init(tempFile, 0x20|0x02|0x08, 0666, 0);
      		stream.write(fileContents, fileContents.length);
      		stream.close();
				}
				}catch(e){alert(e+"\n"+tempFile.path+"\n"+name)}
			}
		}
	},

	_getLiteral:function(resource,arc)
	{
		var target=this._DataSource.GetTarget(resource, arc, true);					
		if(target) return target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
		else return "blank";
	}
};

function exportFavorites()
{
	var fp = Components.classes["@mozilla.org/filepicker;1"]
			.createInstance(Components.interfaces.nsIFilePicker);
	fp.init(window, 'Bookmarks Synchronizer', Components.interfaces.nsIFilePicker.modeGetFolder);

	var ret = fp.show();
	if (ret == Components.interfaces.nsIFilePicker.returnCancel)
		return;
	try{
  favoritesService.exportFiles(fp.fileURL.file);
	}catch(e){alert(e);}
}
