function BookmarksSynchronizerSettings(){
  this._init();
}

BookmarksSynchronizerSettings.prototype=
{
  _stringbundle:null,
  _ioService:null,

  _init:function(){
    var sbSvc = Components.classes["@mozilla.org/intl/stringbundle;1"]
                .getService(Components.interfaces.nsIStringBundleService);
    this._stringbundle=sbSvc.createBundle(this._sbURI);
    this._ioService=Components.classes["@mozilla.org/network/io-service;1"]
               .getService(Components.interfaces.nsIIOService);
  },
  
  get _sbURI(){
    return "chrome://bookmarksftp/locale/bookmarksftp.properties";
  },

  get _host(){
    return "about:blank";
  },

  get title(){
    return this.getString("title");
  },

  get _user(){
    return "Bookmarks Synchronizer";
  },

  get _prefroot(){
    return "bookmarksftp.";
  },

  get user(){
    return nsPreferences.copyUnicharPref(this._prefroot+"username","");
  },

  get host(){
    return nsPreferences.copyUnicharPref(this._prefroot+"host","");
  },

  get path(){
    return nsPreferences.copyUnicharPref(this._prefroot+"path","/xbel.xml");
  },

  get protocol(){
    return nsPreferences.copyUnicharPref(this._prefroot+"protocol","ftp");
  },

  set user(aStr){
    nsPreferences.setUnicharPref(this._prefroot+"username",aStr);
  },

  set host(aStr){
    nsPreferences.setUnicharPref(this._prefroot+"host",aStr);
  },

  set path(aStr){
    if(!aStr.match(/^\//))
      aStr="/"+aStr;
    if(aStr.match(/\/$/))
      aStr += "xbel.xml";
    nsPreferences.setUnicharPref(this._prefroot+"path",aStr);
  },

  set protocol(aStr){
    if(!aStr)
      aStr="ftp";
    nsPreferences.setUnicharPref(this._prefroot+"protocol",aStr);
  },

  get password(){
    var host= new Object();
    var user= new Object();
    var pass= new Object();
    try{
      var pmInternal = Components.classes["@mozilla.org/passwordmanager;1"]
                      .createInstance(Components.interfaces.nsIPasswordManagerInternal);
      pmInternal.findPasswordEntry(this._host,this._user,"",host,user,pass);
      return pass.value;
    }catch(e){}
    return "";
  },

  set password(aStr){
    var passwordManager = Components.classes["@mozilla.org/passwordmanager;1"]
            .createInstance(Components.interfaces.nsIPasswordManager);
    try{ 
      passwordManager.removeUser(this._host,this._user);
    }catch(e){}
    passwordManager.addUser(this._host,this._user,aStr);
  },

  get _uploadURI(){
    if( ! this.host )
      return "";
    var userpass=this.user +((this.password)? ":":"")+this.password;
    if(userpass)
      userpass += "@";
    return this.protocol + "://" + userpass + this.host + this.path;
  },

  get _downloadURI(){
    return (this.dlurl)? this.dlurl : this._uploadURI;
  },

  get maskedDownloadURI(){
    if(this.dlurl)
      return this.dlurl;
    var length=this.password.length;
    var userpass=this.user;
    userpass += (length>0)? ":" : "";
    for(var i=0; i< length;i++)
      userpass += "*";
    if(userpass)
      userpass +="@";
    return this.protocol + "://"+ userpass + this.host + this.path;
  },

  get dlurl(){
    return nsPreferences.copyUnicharPref(this._prefroot+"dlurl","");
  },

  set dlurl(aStr){
    if(aStr.match(/[a-z]+:\/\//))
      nsPreferences.setUnicharPref(this._prefroot+"dlurl", aStr);
    else
      nsPreferences.setUnicharPref(this._prefroot+"dlurl", "");
  },

  get charset(){
    var charset=nsPreferences.copyUnicharPref(this._prefroot+"charset","UTF-8");
    return (charset)? charset:"UTF-8";
  },

  set charset(aStr){
    nsPreferences.setUnicharPref(this._prefroot+"charset",aStr);
  },

  get tags(){
    return nsPreferences.copyUnicharPref(this._prefroot+"addtag","");
  },

  set tags(aStr){
    nsPreferences.setUnicharPref(this._prefroot+"addtag",aStr);
  },

  get selectedFolder(){
    var folder= nsPreferences.copyUnicharPref(this._prefroot+"folderId","");
      return (folder)? folder:"NC:BookmarksRoot";
  },

  set selectedFolder(aStr){
    nsPreferences.setUnicharPref(this._prefroot+"folderId",aStr);
  },

  get cacheFolder(){
      return nsPreferences.copyUnicharPref(this._prefroot+"session.root","");
  },

  set cacheFolder(aStr){
    nsPreferences.setUnicharPref(this._prefroot+"session.root",aStr);
  },

  get cacheToolbar(){
      return nsPreferences.copyUnicharPref(this._prefroot+"session.toolbar","");
  },

  set cacheToolbar(aStr){
    nsPreferences.setUnicharPref(this._prefroot+"session.toolbar",aStr);
  },

  get _file(){
    var ds = Components.classes['@mozilla.org/file/directory_service;1']
                       .getService(Components.interfaces.nsIProperties);
    var file = ds.get('ProfD', Components.interfaces.nsIFile);
    file.append("bookmarks.xml");
    return file;
  },

  get _backupfile(){
    var ds = Components.classes['@mozilla.org/file/directory_service;1']
                       .getService(Components.interfaces.nsIProperties);
    var file = ds.get('ProfD', Components.interfaces.nsIFile);
    file.append("bookmarks_backup_.xml");
    return file;
  },

  get _undoFile(){
    var ds = Components.classes['@mozilla.org/file/directory_service;1']
                       .getService(Components.interfaces.nsIProperties);
    var file = ds.get('ProfD', Components.interfaces.nsIFile);
    file.append("bmsync__undo__.xml");
    return file;
  },

  get _redoFile(){
    var ds = Components.classes['@mozilla.org/file/directory_service;1']
                       .getService(Components.interfaces.nsIProperties);
    var file = ds.get('ProfD', Components.interfaces.nsIFile);
    file.append("bmsync__redo__.xml");
    return file;
  },

  get undoable(){
    return this._undoFile.exists() && this.cacheFolder &&
           this.selectedFolder==this.cacheFolder &&
           this.getBool("session.enabled",false);
  },

  get redoable(){
    return this._redoFile.exists() && this.cacheFolder &&
           this.selectedFolder==this.cacheFolder &&
           this.getBool("session.enabled",false);
  },

  set undoCache(aStr){
    if(aStr)
      this.write(this._undoFile,aStr);
    else if(this._undoFile.exists())
      this._undoFile.remove(false);
  },

  set redoCache(aStr){
    if(aStr)
      this.write(this._redoFile,aStr);
    else if(this._redoFile.exists())
      this._redoFile.remove(false);
  },

  get redoCache(){
    return (this._redoFile.exists())? this.read(this._redoFile): "";
  },

  get undoCache(){
    return (this._undoFile.exists())? this.read(this._undoFile): "";
  },

  get doMerge()
  {
    return this.getBool("merge",false)
  },

  getString :function(aName)
  {
    try{
      if(this._stringbundle)
        return this._stringbundle.GetStringFromName(aName);
    }catch(e){ alert(e+"\n\n"+aName);}
    return aName;
  },

  getBool:function(aPrefName,aDefaultValue){
    return nsPreferences.getBoolPref(this._prefroot+aPrefName,aDefaultValue);
  },

  setBool:function(aPrefName,aValue){
    nsPreferences.setBoolPref(this._prefroot+aPrefName,aValue);
  },

  read:function(aFile)
  {
    var fs = Components.classes['@mozilla.org/network/file-input-stream;1']
            .createInstance(Components.interfaces.nsIFileInputStream);
    var ss = Components.classes['@mozilla.org/scriptableinputstream;1']
            .createInstance(Components.interfaces.nsIScriptableInputStream);
    try{
      fs.init(aFile, 0x01, 0000, false);
      ss.init(fs);
      var str = ss.read(-1);
      ss.close();
      fs.close();
      return str;
    }catch(e){alert(e);}
    return "";
  },

  get mimetype(){
    if(!this.charset)
      return "text/xml";
    else
      return "text/xml; charset=" + this.charset;
  },

  write:function(aFile,aStr)
  {
    var output=Components.classes['@mozilla.org/network/file-output-stream;1']
               .createInstance(Components.interfaces.nsIFileOutputStream);
    var input = Components.classes["@mozilla.org/io/string-input-stream;1"]
              .createInstance(Components.interfaces.nsIStringInputStream);
    input.setData(aStr, -1);
    var length=input.available();
    input.close();
    output.init(aFile, 0x20|0x02|0x08, 0666, 0);
    output.write(aStr, length);
    output.close();
  },

  get cache()
  {
    return (this._file.exists())? this.read(this._file): "";
  },

  set cache(aStr)
  {
    this.write(this._file,aStr);
  },

  set backup(aStr)
  {
    this.write(this._backupfile,aStr);
  },

  get fileURI()
  {
    return this._ioService.newFileURI(this._file);
  },

  get downloadURI()
  {
    var uri=this._downloadURI;
    return (uri)? this._ioService.newURI(uri,this.charset,null) : null;
  },

  get uploadURI()
  {
    var uri=this._uploadURI;
    return (uri)? this._ioService.newURI(uri,this.charset,null) : null;
  },

  getErrorMsg:function(aStatus)
  {
    if(aStatus==0)
      return  this.getString("ok");

    status=aStatus % 0x804b0000;
    var error="unexpected";
    switch(status)
    {
      case 1:
        error="unexpected";
        break;
      case 2:
        error="usercancel";
        break;
      case 13:
        error="refused";
        break;
      case 14:
        error="netTimeout";
        break;
      case 16:
        error="netOffline";
        break;
      case 21:
        error="loginfailure"
        break;
      case 22:
        error="ftpcwd"
        break;
      case 23:
        error="ftppasv"
        break;
      case 24:
        error="ftppwd"
        break;
      case 25:
        error="ftplist"
        break;
      case 30:
        error="unknown"
        break;
      case 201:
        error="created"
        break;
      case 401:
        error="loginfailure"
        break;
      case 405:
        error="methodNotAllowed"
        break;
      default:
        error="unexpected";
        break;
    }

    var formatted= (aStatus<0x804b0000)?
            aStatus.toString(10) : "0x" + aStatus.toString(16).toUpperCase();
    return formatted + ": " + this.getString(error)+"\n";
  }
};
