/*
** Copyright (C) 2003-2006 Teus Benschop.
** ** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_UNDO_H
#define INCLUDED_UNDO_H


#include "libraries.h"
#include <gtk/gtk.h>
#include "editorobject.h"
#include "editor.h"


class Undo
{
public:
  Undo (int dummy);
  ~Undo ();
  void clear (Editor& editor);
  bool tick ();
  void store_snapshot (Editor& editor);
  void text_changed (Editor& editor);
  void undo (Editor& editor);
  void redo (Editor& editor);
  bool can_undo ();
  bool can_redo ();
private:
  void clear_internal ();
  void store_cursorpositions (Editor& editor);
  void cursorpositions_set (Editor& editor, int textposition, int notesposition);
  int previous_cursorposition_text;
  vector <int> cursorpositions_text;
  int previous_cursorposition_notes;
  vector <int> cursorpositions_notes;
  ustring previous_snapshot;
  vector <ustring> snapshots;
  unsigned int pointer;
  unsigned int timer;
};


#endif
