/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "MvcListView.h"
#include "MvcListModel.h"
#include <wx/string.h>
#include <cassert>

void
MvcListView::setModel(ModelPtr const& model)
{
	assert(model);

	IntrusiveListNode::unlink();
	m_ptrModel = model;
	model->attachView(*this);

	long row_count = model->getRowCount();
	onRowCountChanging();
	SetItemCount(row_count);
	RefreshItems(0, row_count - 1);
	onRowCountChanged();
}

void
MvcListView::onRowCountChanging()
{
	// can be implemented by subclasses
}

void
MvcListView::onRowCountChanged()
{
	// can be implemented by subclasses
}

wxString
MvcListView::OnGetItemText(long row, long col) const
{
	if (MvcListModel* model = m_ptrModel.get()) {
		return model->getCellText(row, col);
	} else {
		return wxEmptyString;
	}
}

int
MvcListView::OnGetItemImage(long row) const
{
	if (MvcListModel* model = m_ptrModel.get()) {
		return model->getRowImage(row);
	} else {
		return -1;
	}
}

wxListItemAttr*
MvcListView::OnGetItemAttr(long row) const
{
	if (MvcListModel* model = m_ptrModel.get()) {
		return model->getRowAttr(row);
	} else {
		return 0;
	}
}
