// resource.cc for bbsload - an tool to display the load in X11.
//
//  Copyright (c) 1998-2000 John Kennis, jkennis@chello.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//


#include "resource.hh"
#include "blackboxstyle.hh"


Resource::Resource(ToolWindow *toolwindow):
                   BaseResource(toolwindow) {
  frame.font=0;
  label.font=0;
  Load();
}


Resource::~Resource()
{
    Clean();
}

void Resource::Clean()
{
    if (label.font)
        XFreeFont(bbtool->getXDisplay(), label.font);
    if (frame.font)
        XFreeFont(bbtool->getXDisplay(), frame.font);
}

void Resource::LoadBBToolResource(void)
{
    XrmValue value;
    char *value_type;

    if (XrmGetResource(resource_db, "bbsload.autoConfig",
                           "Bbsload.Autoconfig", &value_type, &value))
    {
        if (! strncasecmp("true", value.addr, value.size))
            style.auto_config = True;
        else
            style.auto_config = False;
    }
    else
        style.auto_config = False;


    SizeAndPosition();

    Frame();

    Show();

    if (show.label)
        Label();

    if (show.loadbar)
        LoadBar();

    CheckSettings();
}


void 	Resource::Frame() {
  XrmValue value;
  char *value_type;


  readTexture("bbsload.frame","Bbsload.Frame",BB_FRAME,"Toolbar",
              "slategrey","darkslategrey",
              "Raised Gradient Vertical Bevel1",&frame.texture);
  int default_bevel=4;
  if (bbtool->withdrawn) default_bevel=0;
     
  if (XrmGetResource(resource_db, "bbsload.bevelWidth",
                     "bbsload.BevelWidth", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &frame.bevelWidth) != 1)
      frame.bevelWidth = default_bevel;
    else if (frame.bevelWidth == 0)
      frame.bevelWidth = default_bevel;
  }
  else if (XrmGetResource(resource_db, BB_BEVELWIDTH,
                          "TitleFont", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &frame.bevelWidth) != 1)
      frame.bevelWidth = 4;
    else if (frame.bevelWidth == 0)
      frame.bevelWidth = 4;
  } 
  else
    frame.bevelWidth = 4;
}

void	Resource::SizeAndPosition() {
  XrmValue value;
  char *value_type;
  unsigned int w,h;
  char positionstring[11];

  if (!(bbtool->withdrawn)) {
    if (XrmGetResource(resource_db, "bbsload.withdrawn",
      		     "Bbsload.Withdrawn", &value_type, &value)) {
      if (! strncasecmp("true", value.addr, value.size))
	  	  bbtool->withdrawn = True;
	    else
		  	bbtool->withdrawn = False;
    }	
	  else
		  bbtool->withdrawn = False;
  }

  if (!(bbtool->shape)) {
    if (XrmGetResource(resource_db, "bbsload.shape",
    		       "Bbsload.Shape", &value_type, &value)) {
  	  if (! strncasecmp("true", value.addr, value.size))
	  	  bbtool->shape = True;
	    else
		  	bbtool->shape = False;
  	}	
	  else
		  bbtool->shape = bbtool->withdrawn;
  }
    
  if (!(bbtool->position)) {
    if (!(XrmGetResource(resource_db, "bbsload.position",
                                 "Bbsload.Position", &value_type, &value)))
      strncpy(positionstring, "-0-0", 5);
    else
      strncpy(positionstring, value.addr, strlen(value.addr)+1);
  }
  else
    strncpy(positionstring, bbtool->position, strlen(bbtool->position)+1);

  position.mask=XParseGeometry(positionstring, &position.x, &position.y,
                                 &w, &h);

  if (!(position.mask & XValue))
    position.x=0;
  if (!(position.mask & YValue))
    position.y=0;

  /* need this to compute the height */
  const char *defaultFont = "-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*";

  if (frame.font) {
    XFreeFont(bbtool->getXDisplay(), frame.font);
    frame.font = 0;
  }

  if (XrmGetResource(resource_db, "bbsload.heightBy.font",
                        "bbsload.heightBy.Font", &value_type, &value)) {
    if ((frame.font = XLoadQueryFont(bbtool->getXDisplay(), value.addr)) == NULL) {
      fprintf(stderr, " blackbox: couldn't load font '%s'\n"
                      " ...  reverting to default font.", value.addr);
      if ((frame.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) == NULL) {
        fprintf(stderr,
                "blackbox: couldn't load default font.  please check to\n"
                "make sure the necessary font is installed '%s'\n",
                defaultFont);
         exit(2);
      }
    }
  }
  else if (XrmGetResource(resource_db, BB_FONT,"TitleFont",
                          &value_type,&value)) {
    if ((frame.font = XLoadQueryFont(bbtool->getXDisplay(), value.addr)) == NULL) {
      fprintf(stderr, " blackbox: couldn't load font '%s'\n"
                      " ...  reverting to default font.", value.addr);
      if ((frame.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) == NULL) {
        fprintf(stderr,
                "blackbox: couldn't load default font.  please check to\n"
                "make sure the necessary font is installed '%s'\n",
                 defaultFont);
         exit(2);
      }
    }
  }else {
    if ((frame.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) == NULL) {
      fprintf(stderr,
              "blackbox: couldn't load default font.  please check to\n"
              "make sure the necessary font is installed '%s'\n", defaultFont);
       exit(2);
    }
  }
}




void	Resource::CheckSettings() {
  XrmValue value;
  char *value_type;

  if (XrmGetResource(resource_db, "bbsload.checkDelay",
                     "Bbsload.CheckDelay", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &report.check_delay) != 1)
      report.check_delay = 5;
    else
      if (report.check_delay == 0)
        report.check_delay = 5;
  }
  else
    report.check_delay = 5;


  if (XrmGetResource(resource_db, "bbsload.raised",
                     "Bbsload.Raised", &value_type, &value)) {
    if (! strncasecmp("true", value.addr, value.size))
      bbtool->raised = True;
    else
      bbtool->raised = False;
  }
  else
    bbtool->raised = True;

  // These are the network card settings... there is nowhere else
  // for them to go but here.
  if (XrmGetResource(resource_db, "bbsload.netcard.name",
                     "Bbsload.Netcard.Name", &value_type, &value)){
   sscanf(value.addr,"%s", report.netname);
  }
  else  // if bbsload.netcard.name is not set, default to "eth0"
   strcpy(report.netname,"eth0");
  //  printf("DEBUG: %s\n",report.netname);
  
  if (XrmGetResource(resource_db, "bbsload.netcard.speed",
                     "Bbsload.Netcard.Speed", &value_type, &value)){
   sscanf(value.addr,"%d", &report.netspeed);
  }
  else // if bbsload.netcard.speed is not set, default to 10MBits/sec
   report.netspeed=10;
}


void	Resource::Label(void) {
  XrmValue value;
  char *value_type;

  /* text-label resources */
  if (XrmGetResource(resource_db, "bbsload.label.transparent",
                     "Bbsload.label.Transparent", &value_type, &value)) {
    if (! strncasecmp("true", value.addr, value.size))
      label.transparent = True;
    else
      label.transparent = False;
  }
  else
    label.transparent = False;

  readTexture("bbsload.label", "Bbsload.Label",BB_LABEL,"Toolbar.Label",
              "slategrey","darkslategrey",
              "Sunken Gradient Vertical Bevel1",&label.texture);

  if (show.running_counter) {
  	readColor("bbsload.runningCounter.label.textColor",
      	    	"Bbsload.RunningCounter.Label.TextColor",
              BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
              "LightGrey",&label.running_textColor);
  }
  if (show.task_counter) {
    readColor("bbsload.taskCounter.label.textColor",
      	  		"Bbsload.TaskCounter.Label.TextColor",
              BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
              "LightGrey",&label.task_textColor);
  }
  if (show.label_load1m) {
    readColor("bbsload.1m.label.textColor","Bbsload.1M.Label.TextColor",
              BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
              "LightGrey",&label.load1m_textColor);
  }
  if (show.label_load5m) {
    readColor("bbsload.5m.label.textColor","Bbsload.5M.Label.TextColor",
               BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
              "LightGrey",&label.load5m_textColor);
  }
  if (show.label_load15m) {
    readColor("bbsload.15m.label.textColor","Bbsload.15M.Label.TextColor",
               BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
              "LightGrey",&label.load15m_textColor);
  }
  if (show.label_totalused) {
  	readColor("bbsload.totalUsed.label.textColor",
              "Bbsload.TotalUsed.Label.TextColor",
               BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
              "LightGrey",&label.totalUsed_textColor);
  }
  if (show.label_swapused) {
    readColor("bbsload.swapUsed.label.textColor",
              "Bbsload.SwapUsed.Label.TextColor",
               BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
              "LightGrey",&label.swapUsed_textColor);
  }
  if (show.label_memused) {
    readColor("bbsload.memUsed.label.textColor",
      				"Bbsload.MemUsed.Label.TextColor",
               BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
              "LightGrey",&label.memUsed_textColor);
  }
  
  readColor("bbsload.seperator.textColor",
	      		"Bbsload.Seperator.TextColor",
             BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
            "LightGrey",&label.seperator_textColor);


  const char *defaultFont = "-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*";

  if (label.font) {
    XFreeFont(bbtool->getXDisplay(), label.font);
    label.font = 0;
  }

  if (XrmGetResource(resource_db, "bbsload.label.font",
                     "Bbsload.Label.Font", &value_type, &value)) {
    if ((label.font = XLoadQueryFont(bbtool->getXDisplay(), value.addr)) == NULL) {
      fprintf(stderr, " blackbox: couldn't load font '%s'\n"
                      " ...  reverting to default font.", value.addr);
      if ((label.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) == NULL) {
        fprintf(stderr,
                "blackbox: couldn't load default font.  please check to\n"
                "make sure the necessary font is installed '%s'\n",
                defaultFont);
        exit(2);
      }
    }
  }
  else if  (XrmGetResource(resource_db, BB_FONT,"TitleFont", 
                            &value_type, &value)) {
    if ((label.font = XLoadQueryFont(bbtool->getXDisplay(), value.addr)) == NULL) {
      fprintf(stderr, " blackbox: couldn't load font '%s'\n"
                      " ...  reverting to default font.", value.addr);
      if ((label.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) == NULL) {
        fprintf(stderr,
                "blackbox: couldn't load default font.  please check to\n"
                "make sure the necessary font is installed '%s'\n",
                 defaultFont);
         exit(2);
      }
    }
  } else {
    if ((label.font = XLoadQueryFont(bbtool->getXDisplay(), defaultFont)) == NULL) {
      fprintf(stderr,
              "blackbox: couldn't load default font.  please check to\n"
              "make sure the necessary font is installed '%s'\n", defaultFont);
      exit(2);
    }
  }
}


bool Resource::showLabel(char *dbname,char *dbclass,bool default_show)
{
  bool show_label;
  XrmValue value;
  char *value_type;

  
  if (XrmGetResource(resource_db,dbname,dbclass,&value_type, &value)) {
    if (! strncasecmp("true", value.addr, value.size))
      show_label = True;
    else
      show_label = False;
  }
  else
    show_label = default_show;

  if (show_label)
    show.label = True;
  
  return show_label;
}

bool Resource::showGauge(char *dbname,char *dbclass, bool default_show)
{
  bool show_gauge;
  XrmValue value;
  char *value_type;

  
  if (XrmGetResource(resource_db,dbname,dbclass,&value_type, &value)) {
    if (! strncasecmp("true", value.addr, value.size))
      show_gauge = True;
    else
      show_gauge = False;
  }
  else
    show_gauge = default_show;

  if (show_gauge) 
    show.loadbar=True;

  return show_gauge;
}

void	Resource::Show() {
  XrmValue value;
  char *value_type;
  show.label=False;
  show.loadbar=False;

  if (XrmGetResource(resource_db, "bbsload.show.vertical",
                     "Bbsload.Show.Show.Vertical", 
                      &value_type, &value)) {
    if (! strncasecmp("true", value.addr, value.size)) 
      show.vertical = True;
    else
      show.vertical = False;
  }
  else
    show.vertical = False;

  /* what to show.resources */
  if (XrmGetResource(resource_db, "bbsload.show.runningCounter.label",
                     "Bbsload.Show.RunningCounter.Label", 
                      &value_type, &value)) {
    if (! strncasecmp("true", value.addr, value.size)) {
      show.running_counter = True;
      show.label=True;
    }
    else
      show.running_counter = False;
  }
  else
    show.running_counter = False;

  if (XrmGetResource(resource_db, "bbsload.show.taskCounter.label",
                     "Bbsload.Show.TaskCounter.Label", &value_type, &value)) {
    if (! strncasecmp("true", value.addr, value.size)) {
      show.task_counter = True;
      show.label=True;
    }
    else
      show.task_counter = False;
  }
  else
    show.task_counter = False;

  show.label_load1m = showLabel("bbsload.show.1m.label",
                                "Bbsload.Show.1m.Label",True);
  show.load1m = showGauge("bbsload.show.1m.gauge",
                          "Bbsload.Show.1m.Gauge",True);
  show.label_load5m = showLabel("bbsload.show.5m.label",
                                "Bbsload.Show.5m.Label",False);
  show.load5m = showGauge("bbsload.show.5m.gauge",
                          "Bbsload.Show.5m.Gauge",False);
  show.label_load15m = showLabel("bbsload.show.15m.label",
                                 "Bbsload.Show.15m.Label",False);
  show.load15m = showGauge("bbsload.show.15m.gauge",
                           "Bbsload.Show.15m.Gauge",False);
  show.label_usercpu = showLabel("bbsload.show.cpuUser.label",
                                 "Bbsload.Show.CpuUser.Label",False);
  show.usercpu = showGauge("bbsload.show.cpuUser.gauge",
                           "Bbsload.Show.CpuUser.Gauge",False);
  show.label_nicecpu = showLabel("bbsload.show.cpuNice.label",
                                 "Bbsload.Show.CpuNice.Label",False);
  show.nicecpu = showGauge("bbsload.show.cpuNice.gauge",
                           "Bbsload.Show.CpuNice.Gauge",False);
  show.label_systemcpu = showLabel("bbsload.show.cpuSystem.label",
                                   "Bbsload.Show.CpuSystem.Label",False);
  show.systemcpu = showGauge("bbsload.show.cpuSystem.gauge",
                             "Bbsload.Show.CpuSystem.Gauge",False);
  show.label_idlecpu = showLabel("bbsload.show.cpuIdle.label",
                                   "Bbsload.Show.CpuIdle.Label",False);
  show.idlecpu = showGauge("bbsload.show.cpuIdle.gauge",
                             "Bbsload.Show.CpuIdle.Gauge",False);
  show.label_networkin = showLabel("bbsload.show.networkin.label",
                                   "Bbsload.Show.Networkin.Label",False);
  show.networkin = showGauge("bbsload.show.networkin.gauge",
                             "Bbsload.Show.Networkin.Gauge",False);
  show.label_networkout = showLabel("bbsload.show.networkout.label",
                                   "Bbsload.Show.Networkout.Label",False);
  show.networkout = showGauge("bbsload.show.networkout.gauge",
                             "Bbsload.Show.Networkout.Gauge",False);
  show.label_memused = showLabel("bbsload.show.memUsed.label",
                                 "Bbsload.Show.MemUsed.Label",False);
  show.memused = showGauge("bbsload.show.memUsed.gauge",
                           "Bbsload.Show.MemUsed.Gauge",False);
  show.label_swapused = showLabel("bbsload.show.swapUsed.label",
                                  "Bbsload.Show.SwapUsed.Label",False);
  show.swapused = showGauge("bbsload.show.swapUsed.gauge",
                            "Bbsload.Show.SwapUsed.Gauge",False);
  show.label_totalused = showLabel("bbsload.show.totalUsed.label",
                                   "Bbsload.Show.TotalUsed.Label",False);
  show.totalused = showGauge("bbsload.show.totalUsed.gauge",
                             "Bbsload.Show.TotalUsed.Gauge",False);
}


void	Resource::LoadBar() {
  XrmValue value;
  char *value_type;
  int i;

  readTexture("bbsload.gauge.active","Bbsload.Gauge.Active",
                      BB_BUTTON_PRESSED,"Toolbar.Button.Pressed",
                      "red1","green","Vertical Gradient Flat Bevel2",
                      &gauge.active_texture);

  readTexture("bbsload.gauge.inactive","Bbsload.Gauge.Inactive",
                          BB_BUTTON,"Toolbar.Button",
                          "black","black","Solid Flat Bevel2",
                          &gauge.inactive_texture);

  if (XrmGetResource(resource_db, "bbsload.gauge.background",
                           "Bbsload.Gauge.Background", &value_type, &value)) {
    readTexture("bbsload.gauge.background",
                "Bbsload.Gauge.Background","0","0","black","black",
                "Solid Flat Bevel2",&gauge.background_texture);
    gauge.background=True;
  }
  else
    gauge.background=False;
 
  if (XrmGetResource(resource_db, "bbsload.gauge.width",
                     "Bbsload.Gauge.Width", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &gauge.width) != 1)
      gauge.width = 20;
  }
  else
    gauge.width = 20;

  if (XrmGetResource(resource_db, "bbsload.gauge.left.stepWidth",
                     "Bbsload.Gauge.Left.StepWidth", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &gauge.left_step_width) != 1)
      gauge.left_step_width = 2;
  }
  else
    gauge.left_step_width = 2;

  if (XrmGetResource(resource_db, "bbsload.gauge.right.stepWidth",
                     "Bbsload.Gauge.Right.StepWidth", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &gauge.right_step_width) != 1)
      gauge.right_step_width = 0;
  }
  else
    gauge.right_step_width = 0;

  if (XrmGetResource(resource_db,"bbsload.gauge.tickmarks",
                     "Bbsload.Gauge.Tickmarks",&value_type,&value)) {
    if (! strncasecmp("false", value.addr, value.size)) {
      gauge.tickmarks = False;
      gauge.background = False;
    }
    else
      gauge.tickmarks = True;
  }
  else
    gauge.tickmarks=True;

  if (XrmGetResource(resource_db, "bbsload.gauge.numberOf.bars",
                     "Bbsload.Gauge.NumberOf.Bars", &value_type, &value)) {
    if (sscanf(value.addr, "%u", &gauge.number_of_bars) != 1)
      gauge.number_of_bars = 6;
  }
  else
    gauge.number_of_bars = 6;

  if (XrmGetResource(resource_db, "bbsload.gauge.maximum.load",
                     "Bbsload.Gauge.Maximum.Load", &value_type, &value)) {
    if (sscanf(value.addr, "%f", &gauge.max_load) != 1)
      gauge.max_load = 1.0;
  }
  else
    gauge.max_load = 1.0;

  gauge.level = new float [gauge.number_of_bars];
  char *resource_name= new char [40];
  char *resource_class= new char [40];
  gauge.levels_defined=True;
   

  for (i=1;i<=gauge.number_of_bars;i++) {
    sprintf(resource_name,"bbsload.gauge.segment.%d.scale",i);
    sprintf(resource_class,"Bbsload.Gauge.Segment.%d.scale",i);
    if (XrmGetResource(resource_db, resource_name,resource_class
                       ,&value_type, &value)) {
      if (sscanf(value.addr, "%f", (float *) &gauge.level[i-1]) != 1) {
        gauge.levels_defined=False;
        break;
      }
    } else {
      gauge.levels_defined=False;
      break;
    }
  }
  
  if (XrmGetResource(resource_db,"bbsload.gauge.multiColor",
                     "Bbsload.Gauge.multiColor",&value_type,&value)) {
    if (! strncasecmp("true", value.addr, value.size)) 
      gauge.use_simple_color=True;
    else
      gauge.use_simple_color = False;
  }
  else
    gauge.use_simple_color= False;
    
  if (gauge.use_simple_color) {
    gauge.segment_texture = new BTexture [gauge.number_of_bars];
    for (i=1;i<=gauge.number_of_bars;i++) {
      sprintf(resource_name,"bbsload.gauge.segment.%d",i);
      sprintf(resource_class,"Bbsload.Gauge.Segment.%d",i);

      readTexture(resource_name,resource_class,
                  "0","0","green","green","Solid Flat Bevel1",
                   &gauge.segment_texture[i-1]);
    }
  }
  delete [] resource_class;
  delete [] resource_name;

}
