# Copyright (C) 1999, 2000 Jay Beale
# Copyright (C) 2001-2003 Hewlett Packard Company
# Licensed under the GNU General Public License


package Bastille::Apache;
use lib "/usr/lib";

use Bastille::API;
use Bastille::TestAPI;

@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

# TO DO:
#
# 1. Write ConfigureSSL

#######################################################################
##                              HTTP/APACHE                          ##
#######################################################################

&DeactivateApacheServer;
&DeactivateHPApache2;
&LimitListeningInterfaces;
&ChrootApache1_3;
&ChrootApache2_0;
&ChrootHPWSApache2_0;
#&ModifyAccessconf;
#&ConfigureSSL;


sub DeactivateApacheServer {

    if ( &getGlobalConfig("Apache","apacheoff") eq "Y" ) {

	&ActionLog("# sub DeactivateApacheServer\n");
	&B_chkconfig_off ("httpd");
	
    }
}


sub DeactivateHPApache2 {

    if ( &getGlobalConfig("Apache","deactivate_hpapache2") eq "Y" ) {

	my $isApache2Off =  &B_is_service_off('apache');
	my $isHPWSApacheOff =  &B_is_service_off('hpws_apache');
	                    
	&ActionLog("# sub DeactivateHPApache2\n");
	# if the apache running is the apache2 version, turn it off
	if(defined $isApache2Off && $isApache2Off == 0) {
	    my $exportpath = "export PATH=/usr/bin; ";
	    &B_ch_rc ('APACHE2_START',$exportpath . &getGlobal('FILE', 'apachectl2'));
	}
	# if the apache running is the hpws version, turn it off
	if(defined $isHPWSApacheOff && $isHPWSApacheOff == 0) {
	    my $exportpath = "export PATH=/usr/bin; ";

	    # stop the service using the stopall switch
	    &B_System($exportpath . &getGlobal('FILE', 'hpws_apachectl') . " stopall", 
		      $exportpath . &getGlobal('FILE', 'hpws_apachectl') . " start");

	    # set parameter, so that service will stay off after reboots
            &B_set_rc("HPWS_APACHE_START",0);
	} 
	
    }

}


sub LimitListeningInterfaces {

    if ((&getGlobalConfig("Apache","bindapachelocal") eq "Y") or (&getGlobalConfig("Apache","bindapachenic") eq "Y")) {
	
	&ActionLog("# sub LimitListeningInterfaces\n");

	# First, figure out which configuration file to modify...
	
	my $httpd_file=&getGlobal('FILE', "httpd.conf");

	# Bind Apache to a particular interface or to the loopback device.

	if (&getGlobalConfig("Apache","bindapachenic") and (&getGlobalConfig("Apache","bindapacheaddress") =~ /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/) ) {
	    my $listen_ip=&getGlobalConfig("Apache","bindapacheaddress");
	    if (! ($listen_ip =~ /\:/) ) {
		# user did not specify port number
		&ErrorLog("Binding Apache to a particular IP address: no port specified, defaulting to :80\n");
		$listen_ip .= ":80";
	    }
	    
	    &B_replace_line($httpd_file,'^\s*Listen\s',"Listen ${listen_ip}\n");
	}
	elsif (&getGlobalConfig("Apache","bindapachelocal") eq "Y") {
	    &B_replace_line($httpd_file,'^\s*Listen\s',"Listen 127.0.0.1:80\n");
	}
	else {
	    &ErrorLog("ERROR:   Invalid address specified when trying to limit Apache's listening interfaces.  Probably, you tried to bind Apache to a particular interface, but did not specify a valid interface number...\n");
	}

    }
}

sub ModifyAccessconf {

    if ( (&getGlobalConfig("Apache","symlink") eq "Y") or (&getGlobalConfig("Apache","ssi") eq "Y") or (&getGlobalConfig("Apache","cgi") eq "Y") or (&getGlobalConfig("Apache","apacheindex") eq "Y" ) ) {
	
	&ActionLog("# sub ModifyAccessconf\n");
	# Editting access.conf for safer settings
	
	# Disable FollowSymLinks to prevent users linking world readable/user 
	# readable files to allow viewing/access by the server.
	#
	# Deactivate Server Side includes
	# Deactivate CGI scripts
	# Deactivate generation of indexes for directories that don't have them


	my $access_file = &getGlobal('FILE', "httpd_access.conf");
	my $new_options_line="Options ";

	unless (&getGlobalConfig("Apache","apacheindex") eq "Y") {
	    $new_options_line .= "Indexes ";
	}
	unless (&getGlobalConfig("Apache","ssi") eq "Y" ) {
	    $new_options_line .= "Includes ";
	}
	unless (&getGlobalConfig("Apache","symlink") eq "Y" ) {
	    $new_options_line .= "FollowSymLinks ";
	}
	$new_options_line .= "\n";

	&B_replace_line ($access_file,'^\s*Options\s.*\bIncludes\b',$new_options_line);
	if (&getGlobalConfig("Apache","cgi") eq "Y") {
	    &B_hash_comment_line($access_file,"Options.*ExecCGI");
	}
    }

}


################################################################################
#  &ChrootApache1_3;
#     This subroutine uses the chroot script that comes with Apache 1.3.19
#     or greater.  It makes modifications to httpd.conf so that when
#     Apache starts it will chroot itself into the jail that the above
#     mentions script creates.
#
#     uses B_replace_line B_create_dir B_System B_TODO
###############################################################################
sub ChrootApache1_3 {
    &ActionLog("# sub ChrootApache\n");

    if(&getGlobalConfig('Apache','chrootapache') eq "Y"){
	my $exportpath = "export PATH=/usr/bin;";
	my $ps = &getGlobal('BIN',"ps");
	my $isRunning = 0;
	my $todo_header = 0;
	# checking for the 1.3.x version of the chroot script.
	if(-e  &getGlobal('FILE',"chroot_os_cp.sh")) {

	    if(open HTTPD, &getGlobal('FILE',"httpd.conf")) {
		while (my $line = <HTTPD>){
		    if($line =~ /^\s*Chroot/) {
			&ActionLog("Apache is already running in a chroot as specified by the following line:\n$line\n" . 
				   "which appears in the httpd.conf file.  No Apache Chroot action was taken.\n");
			return;
		    }
		}
		close(HTTPD);
	    }

	    if(`$ps -ef` =~ /\/opt\/apache\/bin\/httpd/) {
		$isRunning=1;
		&B_System("$exportpath " . &getGlobal('FILE',"apachectl"). " stop","$exportpath " . &getGlobal('FILE',"apachectl"). " start");
	    }

	    &B_replace_line(&getGlobal('FILE',"httpd.conf"), '^\s*#\s*Chroot' ,
			    "Chroot " . &getGlobal('BDIR',"apachejail"));
	    if(-d &getGlobal('BDIR',"jail")){
		&ActionLog("Jail directory already exists. No action taken.\n");
	    }
	    else{
		&ActionLog("Jail directory was created.\n");
		&B_create_dir( &getGlobal('BDIR','jail'));
	    }
	    
	    if(-d &getGlobal('BDIR',"apachejail")){
		&ActionLog("Apache jail already exists. No action taken.\n");
	    }
	    else{
		&B_System(&getGlobal('BIN',"umask") . " 022; $exportpath " . &getGlobal('FILE',"chroot_os_cp.sh"),
			  &getGlobal('BIN',"echo") . " \"Your 1.3.x Apache Server is now running outside of it's\\n" . 
			  "chroot jail.  You must manually migrate your web applications\\n" .
			  "back to your Apache server's httpd.conf defined location(s).\\n".
			  "After you have completed this, feel free to remove the jail directories\\n" .
			  "from your machine.  Your apache jail directory is located in\\n" . 
			  &getGlobal('BDIR',"jail") . "\\n\" >> " . &getGlobal('BFILE',"TOREVERT"));
		
	    }
	    if($isRunning){
		&B_System("$exportpath " . &getGlobal('FILE',"apachectl"). " start","$exportpath " . &getGlobal('FILE',"apachectl"). " stop");
		&ActionLog("Apache is now running in an chroot jail.\n");
		$isRunning=0;
	    }
	    &ActionLog("The jail is located in " . &getGlobal('BDIR',"apachejail") . "\n");
	    
	    $todo_header=1;
	    
	    &B_TODO("\n---------------------------------\nApache Chroot:\n" . 
		    "---------------------------------\n" .
		    "APACHE 1.3.x JAIL:\n" . 
		    "httpd.conf contains the Apache dependencies.  You should\n" .
		    "review this file to ensure that the dependencies made it\n" .
		    "into the jail.  Otherwise, you run a risk of your Apache server\n" .
		    "not having access to all its modules and functionality.\n");
	}
    }
}

################################################################################
#  &ChrootApache2_0;
#     This subroutine uses the chroot script that comes with Apache 2.0
#     or greater.  It makes modifications to httpd.conf so that when
#     Apache starts it will chroot itself into the jail that the above
#     mentions script creates.
#
#     uses B_replace_line B_create_dir B_System B_TODO
###############################################################################
sub ChrootApache2_0 {
    &ActionLog("# sub ChrootApache\n");

    if(&getGlobalConfig('Apache','chrootapache') eq "Y"){
	my $exportpath = "export PATH=/usr/bin;";
	my $ps = &getGlobal('BIN',"ps");
	my $isRunning = 0;
	my $todo_header = 0;
	# checking for a 2.0 version of the apache chroot script.
	if(-e  &getGlobal('FILE',"chroot_os_cp.sh2")) {

	    if(open HTTPD, &getGlobal('FILE',"httpd.conf2")) {
		while (my $line = <HTTPD>){
		    if($line =~ /^\s*Chroot/) {
			&ActionLog("Apache is already running in a chroot as specified by the following line:\n$line\n" . 
				   "which appears in the httpd.conf file.  No Apache Chroot action was taken.\n");
			return;
		    }
		}
		close(HTTPD);
	    }
	    
	    if(`$ps -ef` =~ /\/opt\/hpapache2\/bin\/httpd/) {
		$isRunning=1;
		&B_System("$exportpath " . &getGlobal('FILE',"apachectl2"). " stop","$exportpath " . &getGlobal('FILE',"apachectl2"). " start");
	    }
	    &B_replace_line(&getGlobal('FILE',"httpd.conf2"), '^\s*#\s*Chroot' ,
			    "Chroot " . &getGlobal('BDIR',"apachejail2"));
	    if(-d &getGlobal('BDIR',"jail")){
		&ActionLog("Jail directory already exists. No action taken.\n");
	    }
	    else{
		&ActionLog("Jail directory was created.\n");
		&B_create_dir( &getGlobal('BDIR','jail'));
	    }
	    
	    if(-d &getGlobal('BDIR',"apachejail2")){
		&ActionLog("Apache jail already exists. No action taken.\n");
	    }
	    else{
		&B_System(&getGlobal('BIN',"umask") . " 022; $exportpath " . &getGlobal('FILE',"chroot_os_cp.sh2"),
			  &getGlobal('BIN',"echo") . " \"Your 2.x Apache Server is now running outside of it's\\n" . 
			  "chroot jail.  You must manually migrate your web applications\\n" .
			  "back to your Apache server's httpd.conf defined location(s).\\n".
			  "After you have completed this, feel free to remove the jail directories\\n" .
			  "from your machine.  Your apache jail directory is located in\\n" . 
			  &getGlobal('BDIR',"jail") . "\\n\" >> " . &getGlobal('BFILE',"TOREVERT"));
		
	    }
	    if($isRunning){
		&B_System("$exportpath " . &getGlobal('FILE',"apachectl2"). " start","$exportpath " . &getGlobal('FILE',"apachectl2"). " stop");
		&ActionLog("Apache 2.x is now running in an chroot jail.\n");
	    }
	    &ActionLog("The jail is located in " . &getGlobal('BDIR',"apachejail2") . "\n");
	    
	    if ($todo_header !=1){
		&B_TODO("\n---------------------------------\nApache Chroot:\n" .
			"---------------------------------\n");
	    }
	    &B_TODO("APACHE 2.x JAIL:\n" . 
		    "httpd.conf contains the Apache dependencies.  You should\n" .
		    "review this file to ensure that the dependencies made it\n" .
		    "into the jail.  Otherwise, you run a risk of your Apache server\n" .
		    "not having access to all its modules and functionality.\n");

	    
	}
	
    }
}



################################################################################
#  &ChrootHPWSApache2_0;
#     This subroutine uses the chroot script that comes with Apache 2.0
#     or greater.  It makes modifications to httpd.conf so that when
#     Apache starts it will chroot itself into the jail that the above
#     mentions script creates.
#
#     uses B_replace_line B_create_dir B_System B_TODO
###############################################################################
sub ChrootHPWSApache2_0 {
    &ActionLog("# sub ChrootHPWSApache\n");

    if(&getGlobalConfig('Apache','chrootapache') eq "Y"){
	my $exportpath = "export PATH=/usr/bin;";
	my $ps = &getGlobal('BIN',"ps");
	my $isRunning = 0;
	my $todo_header = 0;
	# checking for a 2.0 version of the apache chroot script.
	if(-e  &getGlobal('FILE',"hpws_chroot_os_cp.sh")) {

	    if(open HTTPD, &getGlobal('FILE',"hpws_httpd.conf")) {
		while (my $line = <HTTPD>){
		    if($line =~ /^\s*Chroot/) {
			&ActionLog("Apache is already running in a chroot as specified by the following line:\n$line\n" . 
				   "which appears in the httpd.conf file.  No Apache Chroot action was taken.\n");
			return;
		    }
		}
		close(HTTPD);
	    }
	    my $httpd=&getGlobal('BIN',"hpws_httpd");
	    if(`$ps -ef` =~ "$httpd") {
		$isRunning=1;
		&B_System("$exportpath " . &getGlobal('FILE',"hpws_apachectl"). " stop","$exportpath " . &getGlobal('FILE',"hpws_apachectl"). " start");
	    }
	    &B_replace_line(&getGlobal('FILE',"hpws_httpd.conf"), '^\s*#\s*Chroot' ,
			    "Chroot " . &getGlobal('BDIR',"hpws_apachejail"));
	    if(-d &getGlobal('BDIR',"jail")){
		&ActionLog("Jail directory already exists. No action taken.\n");
	    }
	    else{
		&ActionLog("Jail directory was created.\n");
		&B_create_dir( &getGlobal('BDIR','jail'));
	    }
	    
	    if(-d &getGlobal('BDIR',"hpws_apachejail")){
		&ActionLog("Apache jail already exists. No action taken.\n");
	    }
	    else{
		&B_System(&getGlobal('BIN',"umask") . " 022; $exportpath " . &getGlobal('FILE',"hpws_chroot_os_cp.sh"),
			  &getGlobal('BIN',"echo") . " \"Your HPWS 2.x Apache Server is now running outside of it's\\n" . 
			  "chroot jail.  You must manually migrate your web applications\\n" .
			  "back to your Apache server's httpd.conf defined location(s).\\n".
			  "After you have completed this, feel free to remove the jail directories\\n" .
			  "from your machine.  Your apache jail directory is located in\\n" . 
			  &getGlobal('BDIR',"jail") . "\\n\" >> " . &getGlobal('BFILE',"TOREVERT"));
		
	    }
	    if($isRunning){
		&B_System("$exportpath " . &getGlobal('FILE',"hpws_apachectl"). " start","$exportpath " . &getGlobal('FILE',"hpws_apachectl"). " stop");
		&ActionLog("HPWS Apache 2.x is now running in an chroot jail.\n");
	    }
	    &ActionLog("The jail is located in " . &getGlobal('BDIR',"hpws_apachejail") . "\n");
	    
	    if ($todo_header !=1){
		&B_TODO("\n---------------------------------\nApache Chroot:\n" .
			"---------------------------------\n");
	    }
	    &B_TODO("HPWS APACHE 2.x JAIL:\n" . 
		    "httpd.conf contains the Apache dependencies.  You should\n" .
		    "review this file to ensure that the dependencies made it\n" .
		    "into the jail.  Otherwise, you run a risk of your Apache server\n" .
		    "not having access to all its modules and functionality.\n");

	    
	}
	
    }
}

1;
