/***************************************************************************
 *   Copyright (C) 2006 by Bjorn Hansen                                    *
 *   holomorph@users.sourceforge.net                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PLAYERSETUPMENU_H
#define PLAYERSETUPMENU_H

#include "submenu.h"

namespace Balder
{
    class AIListModel;
    class SampleProbeWidget;
    class KeyBindButton;

    class PlayerSetupMenu:public SubMenu
    {
    public:
        PlayerSetupMenu(gcn::Container* top, SubMenu* parent);
        virtual ~PlayerSetupMenu();
        void action(const std::string& action);
        void BindKey(const gcn::Key& key);
    private:
        void RefreshKeys();
        gcn::Button* backButton;
        gcn::Button* nextPlayerButton;
        gcn::Button* prevPlayerButton;
        gcn::Label* currentPlayerLabel;
        int currentPlayer;
        bool bindNextKey;
        const char* actionToBind;
        KeyBindButton* setRotateRightButton;
        gcn::Label* rotateRightLabel;
        KeyBindButton* setRotateLeftButton;
        gcn::Label* rotateLeftLabel;
        KeyBindButton* setStickPushButton;
        gcn::Label* stickPushLabel;
        KeyBindButton* setFireButton;
        gcn::Label* fireLabel;
        gcn::Label* aiLabel;
        AIListModel* ailistModel;
        gcn::ScrollArea* aiScrollArea;
        gcn::ListBox* aiListBox;
        gcn::DropDown* aiDropDown;
        gcn::Image* redImage;
        gcn::Icon* redIcon;
        gcn::Slider* redSlider;
        gcn::Image* greenImage;
        gcn::Icon* greenIcon;
        gcn::Slider* greenSlider;
        gcn::Image* blueImage;
        gcn::Icon* blueIcon;
        gcn::Slider* blueSlider;
        SampleProbeWidget* sampleProbe;
        int colorTop;
        int colorLeft;

    };
    
    class KeyBindButton:public gcn::Button
    {
        private: 
            PlayerSetupMenu* menu;
        public:
            KeyBindButton(const std::string& caption, PlayerSetupMenu* m):
                gcn::Button(caption), menu(m){}
            void keyPress(const gcn::Key& key)
            {
                menu->BindKey(key);
            }
    };
}
#endif // PLAYERSETUPMENU_H
