/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import nz.net.catalyst.ELog;
import nz.net.catalyst.IPackage;
import nz.net.catalyst.ISocketClientFactory;
import nz.net.catalyst.Log;
import nz.net.catalyst.SocketClient;
import nz.net.catalyst.Util;

public class SocketListener
implements Runnable,
IPackage {
    protected static final int SUSPEND = 1;
    protected static final int QUIT = 2;
    protected static final int RUN = 3;
    protected int state = 3;
    protected ServerSocket listenerSocket;
    private final int port;
    protected Thread listenerThread;
    protected int failureLimit = 0;
    protected int failureCount = 0;
    private final ISocketClientFactory clientFactory;

    public SocketListener(int port, ISocketClientFactory clientFactory) {
        this.port = port;
        this.clientFactory = clientFactory;
    }

    public void bind() throws IOException {
        this.listenerSocket = new ServerSocket(this.port);
    }

    public void startListener() {
        this.listenerThread = new Thread((Runnable)this, this.getListenerThreadName());
        this.listenerThread.start();
    }

    public int getPort() {
        return this.port;
    }

    public ServerSocket getListenerSocket() {
        return this.listenerSocket;
    }

    public String getListenerThreadName() {
        return "TCP listener on port " + this.port;
    }

    public Thread getListenerThread() {
        return this.listenerThread;
    }

    public void run() {
        try {
            this.listenerSocket.setSoTimeout(1000);
        }
        catch (SocketException e) {
            throw new RuntimeException("Error trying to set Socket timeout in thread " + this.getListenerThreadName(), e);
        }
        while (!this.terminating()) {
            try {
                Socket clientSocket = this.listenerSocket.accept();
                clientSocket.setSoTimeout(30000);
                this.newConnection(clientSocket);
            }
            catch (InterruptedIOException e) {
                this.acceptTimeout();
            }
            catch (IOException e) {
                this.connectionFailed(e);
            }
        }
    }

    protected void connectionFailed(IOException e) {
        this.reportConnectionFailure(e);
        this.signalConnectionFailure(e);
    }

    protected void signalConnectionFailure(IOException e) {
        if (this.failureLimit >= 0 && ++this.failureCount > this.failureLimit) {
            throw new RuntimeException(e);
        }
    }

    protected void acceptTimeout() {
    }

    protected void reportConnectionFailure(IOException e) {
        Log.log(ELog.ERROR, String.valueOf(this.getListenerThreadName()) + ": Error accepting socket connection:" + e);
    }

    protected String getConnectionName(Socket clientSocket) {
        return Util.name(clientSocket);
    }

    protected void newConnection(Socket socketClient) {
        String name = this.getConnectionName(socketClient);
        Log.debug("Client Connected. About to process request.");
        new Thread((Runnable)new SocketClient(socketClient), name).start();
    }

    protected ISocketClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public synchronized void shutDown() {
        this.state = 2;
    }

    protected synchronized boolean terminating() {
        while (this.getState() == 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.getState() == 2;
    }

    protected int getState() {
        return this.state;
    }
}

