/*
				Popup List
 */

#ifndef PULIST_H
#define PULIST_H

#include <gtk/gtk.h>


typedef struct _pulistbox_struct	pulistbox_struct;
#define PULISTBOX(p)			((pulistbox_struct *)(p))
typedef struct _pulist_struct		pulist_struct;
#define PULIST(p)			((pulist_struct *)(p))


/*
 *	Popup Relative:
 */
typedef enum {
	PULIST_RELATIVE_CENTER,
	PULIST_RELATIVE_UP,
	PULIST_RELATIVE_DOWN,
	PULIST_RELATIVE_ABOVE,
	PULIST_RELATIVE_BELOW
} pulist_relative;


/*
 *	Shadow Styles:
 */
typedef enum {
	PULIST_SHADOW_NONE,
	PULIST_SHADOW_DITHERED,
	PULIST_SHADOW_BLACK,
	PULIST_SHADOW_DARKENED
} pulist_shadow_style;


/*
 *	Popup List:
 */
struct _pulist_struct {

	GtkWidget	*toplevel;

	gint		freeze_count,
			main_level;

	GtkWidget	*main_vbox,
			*scrolled_window,
			*vscrollbar,
			*hscrollbar,
			*clist,
			*shadow;

	GdkPixmap	*shadow_pm;

	GtkWidget	*map_widget;	/* Shared */

	pulist_shadow_style	shadow_style;

	/* Copy of last value */
	gchar		*last_value;

	/* Marks that the first button_press_event was sent to the
	 * clist if TRUE. This member is set FALSE at the beginning of
	 * each call to PUListMapQuery()
	 */
	gboolean	initial_list_button_press_sent;

};


/*
 *	Popup List Box:
 */
struct _pulistbox_struct {

	GtkWidget       *toplevel;
	gint		freeze_count;

	GtkWidget	*frame,		/* GtkFrame around the drawing area */
			*da,		/* GtkDrawingArea */
			*map_btn;	/* Map GtkButton */

	pulist_struct	*pulist;	/* Popup List */

	gint		nlines_visible;

	void	(*changed_cb)(
		pulistbox_struct *,	/* Popup List Box */
		gint,			/* Item */
		gpointer		/* Data */
	);
	gpointer	changed_data;

};


/* Popup List */
extern gint PUListFindItemFromValue(
	pulist_struct *list, const gchar *value
);
extern gpointer PUListGetDataFromValue(
	pulist_struct *list, const gchar *value
);
extern GtkWidget *PUListGetToplevel(pulist_struct *list);
extern GtkWidget *PUListGetCList(pulist_struct *list);

extern gint PUListAddItem(
	pulist_struct *list, const gchar *value
);
extern gint PUListAddItemPixText(
	pulist_struct *list, const gchar *value,
	GdkPixmap *pixmap, GdkBitmap *mask
);
extern void PUListClear(pulist_struct *list);

extern void PUListSetItemText(
	pulist_struct *list, const gint i,
	const gchar *value  
);
extern void PUListSetItemPixText(
	pulist_struct *list, const gint i,
	const gchar *value,
	GdkPixmap *pixmap, GdkBitmap *mask
);
extern void PUListSetItemData(
	pulist_struct *list, const gint i,
	gpointer data
);
extern void PUListSetItemDataFull(
	pulist_struct *list, const gint i,
	gpointer data, GtkDestroyNotify destroy_cb
);

extern gint PUListGetTotalItems(pulist_struct *list);
extern void PUListGetItemText(
	pulist_struct *list, const gint i,
	gchar **value
);
extern void PUListGetItemPixText(
	pulist_struct *list, const gint i,
	gchar **value,
	GdkPixmap **pixmap, GdkBitmap **mask
);
extern gpointer PUListGetItemData(pulist_struct *list, const gint i);

extern gint PUListGetSelectedLast(pulist_struct *list);
extern void PUListSelect(pulist_struct *list, const gint i);
extern void PUListUnselectAll(pulist_struct *list);

extern gboolean PUListIsQuery(pulist_struct *list);
extern void PUListBreakQuery(pulist_struct *list);
extern const gchar *PUListMapQuery(
	pulist_struct *list,
	const gchar *value,		/* Initial value */
	const gint lines_visible,	/* Can be -1 for default */
	const pulist_relative relative,	/* One of PULIST_RELATIVE_* */
	GtkWidget *rel_widget,		/* Map relative to this widget */
	GtkWidget *map_widget		/* Widget that mapped this list */
);

extern pulist_struct *PUListNew(void);
extern void PUListSetShadowStyle(
	pulist_struct *list, const pulist_shadow_style shadow_style
);
extern void PUListDelete(pulist_struct *list);


/* Map Button */
extern GtkWidget *PUListNewMapButton(
	void (*map_cb)(GtkWidget *, gpointer),
	gpointer client_data
);
extern GtkWidget *PUListNewMapButtonArrow(
	GtkArrowType arrow_type, GtkShadowType shadow_type,
	void (*map_cb)(GtkWidget *, gpointer),
	gpointer client_data
);


/* Popup List Box */
extern GtkWidget *PUListBoxGetToplevel(pulistbox_struct *box);
extern pulist_struct *PUListBoxGetPUList(pulistbox_struct *box);

extern pulistbox_struct *PUListBoxNew(
	GtkWidget *parent,
	const gint width, const gint height
);
extern void PUListBoxSetLinesVisible(
	pulistbox_struct *box, const gint nlines_visible
);
extern void PUListBoxSetChangedCB(
	pulistbox_struct *box,
	void (*func)(
		pulistbox_struct *,	/* Popup List Box */
		gint,			/* Item */         
		gpointer		/* Data */ 
	),
	gpointer data
);
extern void PUListBoxSelect(pulistbox_struct *box, const gint i);
extern gint PUListBoxGetSelected(pulistbox_struct *box);
extern void PUListBoxMap(pulistbox_struct *box);
extern void PUListBoxUnmap(pulistbox_struct *box);
extern void PUListBoxDelete(pulistbox_struct *box);


#endif	/* PULIST_H */
