
/* autopano-sift, Automatic panorama image creation
 * Copyright (C) 2004 -- Sebastian Nowozin
 *
 * This program is free software released under the GNU General Public
 * License, which is included in this software package (doc/LICENSE).
 */

/* ShowOne.cs
 *
 * Show the keypoints in one image.
 *
 * (C) Copyright 2004 -- Sebastian Nowozin (nowozin@cs.tu-berlin.de)
 *
 * "This software is provided for non-commercial use only. The University of
 * British Columbia has applied for a patent on the SIFT algorithm in the
 * United States. Commercial applications of this software may require a
 * license from the University of British Columbia."
 * For more information, see the LICENSE file supplied with the distribution.
 */

using Gtk;
using GtkSharp;
using System;
using System.IO;
using System.Collections;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;


public class ShowOne
{
	public static void Main (string[] args)
	{
		if (args.Length < 1 || args.Length > 1) {
			Console.WriteLine ("Display keypoints for one image\n");
			Console.WriteLine ("usage: showtwo.exe keyfile\n");
			Console.WriteLine ("keyfile: The keypoint file to display. (Can be compressed.)\n");

			return;
		}

		Application.Init ();

		Window win = new Window ("Image keypoint display program");
		win.DefaultSize = new Gdk.Size (400, 300);
		win.DeleteEvent += new DeleteEventHandler (Window_Delete);

		KeypointXMLList keys1 = KeypointXMLReader.ReadComplete (args[0]);
		Console.WriteLine ("Keyset loaded.");

		string file1 = keys1.ImageFile;
		Console.WriteLine ("file1: {0}", file1);

		DisplayImage pic = new DisplayImage (file1);
		foreach (KeypointN kp in keys1.Arr) {
			pic.DrawCircle ((int)(kp.X + 0.5), (int)(kp.Y + 0.5),
				(int)((((3.0 * kp.Scale) * 3.0) / 2.0) + 0.5), 255, 0, 0);
			/*
			Console.WriteLine ("({0},{1}) ({2},{3}) {4}, 2nd: {5}, weight {6}",
				(int)(m.Kp1.X + 0.5), (int)(m.Kp1.Y + 0.5),
				(int)(m.Kp2.X + 0.5), (int)(m.Kp2.Y + 0.5),
				m.Dist1, m.Dist2, mw.OverallFitness (m));

			pic.DrawLine ((int) (m.Kp1.X + 0.5), (int) (m.Kp1.Y + 0.5),
				(int) (pic.XDiv + m.Kp2.X + 0.5), (int) (pic.YDiv + m.Kp2.Y + 0.5),
				255, 0, 0);
				*/
		}

		win.Add (new Image (pic.Pbuf));
		win.ShowAll ();
		Application.Run ();
	}

	static void Window_Delete (object obj, DeleteEventArgs args)
	{
		Application.Quit ();
		args.RetVal = true;
	}
}


