
using Gtk;
using GtkSharp;
using System;


public class TestGaussian
{
	public static int Main (string[] args)
	{
		Application.Init ();

		Window win = new Window ("Gaussian filter test program");
		win.DefaultSize = new System.Drawing.Size (400, 300);
		win.DeleteEvent += new DeleteEventHandler (Window_Delete);

		GaussianTest gt = new GaussianTest ("test.jpg");
		gt.CreateDisplay ();
		win.Add (gt.Display);

		win.ShowAll ();
		Application.Run ();

		return (0);
	}

	static void Window_Delete (object obj, DeleteEventArgs args)
	{
		Application.Quit ();
		args.RetVal = true;
	}
}

public class GaussianTest
{
	Gtk.VBox gaussianDisplay;
	public Gtk.Widget Display {
		get {
			return ((Gtk.Widget) gaussianDisplay);
		}
	}

	private GaussianTest ()
	{
	}


	string filename;

	public GaussianTest (string filename)
	{
		this.filename = filename;
	}

	public void CreateDisplay ()
	{
		gaussianDisplay = new Gtk.VBox (false, 0);

		DisplayImage pic = new DisplayImage (filename);
		gaussianDisplay.Add (new Image (pic.Pbuf));

		ImageMap picMap = pic.ConvertToImageMap (null);

		double sigma = 0.5;
		GaussianConvolution gaussian;
		do {
			gaussian = new GaussianConvolution (sigma);

			ImageMap blurred = gaussian.Convolve (picMap);

			gaussianDisplay.Add (new Image
				((new DisplayImage (blurred, 1.0)).Pbuf));

			sigma += 4.0;
		} while (sigma < 32.0);
	}
}

