#ifndef PLAYER_HEADER_
#define PLAYER_HEADER_

/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


#include "main.h"
#include "menu.h"


enum playerType {
	HUMAN_PLAYER,
	USELESS_PLAYER,
	GUESSER_PLAYER,
	RANGEFINDER_PLAYER,
	TARGETTER_PLAYER,
	DEADLY_PLAYER,
	LAST_PLAYER_TYPE,
        PART_TIME_BOT         // normally a human, but acting as a deadly computer
};
//player weapon preference type
//ALWAYS_PREF - only choose weapon preferences once on player creation
//PERPLAY_PREF - choose weapon preferences once per game
enum playerPrefType {
	PERPLAY_PREF,
	ALWAYS_PREF
};
enum turnStages {
	SELECT_WEAPON,
	SELECT_TARGET,
	CALCULATE_ATTACK,
	AIM_WEAPON,
	FIRE_WEAPON,
};

#define	NUM_ROULETTE_SLOTS (THINGS * 100)
#define	MAX_WEAP_PROBABILITY	10000

class TANK;
class PLAYER {
	private:
	char	_name[NAME_LENGTH];
	int	_currTank;
	GLOBALDATA *_global;
	ENVIRONMENT *_env;
	char	_turnStage;
	TANK	*_target;
	int	_targetAngle;
	int	_targetPower;
	int	_overshoot;
	int	_weaponPreference[THINGS];
	int	_rouletteWheel[NUM_ROULETTE_SLOTS];
	double	*_targetMatrix;
	int	_targetX;
	int	_targetY;

	public:
	double	type;
	double preftype;
	char* preftypeText[ALWAYS_PREF + 1];
        char *tank_type[2];
        char *teamText[3];

	PLAYER	*revenge;
	int	vengeful;	// 0-100 chance of retaliation
	double	vengeanceThreshold;	// Damage required to warrant revenge
					//   (% of max armour)
	double	defensive;	// -1.0 - 1.0, offense - defense
	double	annoyanceFactor;
	double	selfPreservation;	// Lengths gone to to avoid self-harm
	double	painSensitivity;	// How sensitive to damage
	int	rangeFindAttempts;
	int	retargetAttempts;
	double	focusRate;
	double	errorMultiplier;
	int	score;
	double	played, won;
	double	selected;
	int	money;
	double	damageMultiplier;
	TANK	*tank;
	int	color;
	int	color2;
	int 	nm[WEAPONS], ni[ITEMS];
	MENUENTRY	*menuopts;
	MENUDESC	*menudesc;
	char *typeText[LAST_PLAYER_TYPE];
        bool changed_weapon;
        bool gloating;
        double tank_bitmap;      // which type of tank do we have
        double team;

	PLAYER (GLOBALDATA *global, ENVIRONMENT *env);
	PLAYER (GLOBALDATA *global, ENVIRONMENT *env, FILE *file, bool text_file);
	~PLAYER	();
	void	setName (char *name);
	char	*getName () {return (_name);};
	void	exitShop ();
	void	newRound ();
	void	initialise ();
	TANK	*nextTank ();
	TANK	*currTank ();
	int	controlTank (TANK *ctank);
	int	humanControls (TANK *ctank);
	int	computerControls (TANK *ctank);
	int	traceShellTrajectory (TANK *ctank, int *estimateX, int *estimateY, double targetX, double targetY, double x, double y, double xv, double yv);
	int	rangeFind (TANK *ctank, int *estimateX, int *estimateY, int maxAttempts);
	int	calculatePowerGivenAngle (int dx, int dy, int angle);
	int	calculateAngle (int dx, int dy);
	int	calculateDirectAngle (int dx, int dy);
	int	adjustAngleGivenClearance (TANK *ctank, int xdist, int ydist, int clearance);
	int	addTankDamageToMatrix (TANK *ctank, TANK *ltank, int weapNum);
	void	calcDamageMatrix (TANK *ctank, int weapNum);
	double	calcDefenseValue (TANK *ctank, TANK *ltank);
	double	selectTarget (); // select x to aim for
	double	selectTarget (int *targetXCoord, int *targetYCoord); // select x to aim for
	int	computerSelectItem (TANK *ctank); // Choose weapon to fire
	int	chooseItemToBuy ();
	void	generatePreferences ();
	void	setComputerValues ();
	int	selectRandomItem ();
	char	*selectRevengePhrase (double scale);
	char	*selectGloatPhrase (double scale);
        char    *selectSuicidePhrase (double scale);
	int	saveToFile (FILE *file);
	int	loadFromFile (FILE *file);
        int     saveToFile_Text (FILE *file);
        int     loadFromFile_Text (FILE *file);
	void	initMenuDesc ();
        char    *Get_Team_Name();
};

#endif

