/* :: ascii-jump project
   :: $Id: scrmain.c,v 1.2 2003/03/02 21:20:25 loth Exp $
   
   :: copyright (c) 2003 :: grzegorz moskal, g.moskal@opengruop.org
   :: license gnu gpl v 2						*/

#define SCRMAIN_C
#include "scrmain.h"

char *help_text = 
"\n"
" :: asciijump project\n"
"\n"
"    shortcuts  ::\n"
"    enter -  jump\n"
"    enter -  telemark\n"
"    right -  move right                  ::\n"
"    left  -  move left\n"
"    up    -  scroll menu up              ::\n"
"    down  -  scroll menu down            ::\n"
"    space -  select position\n"
"    tab   -  next widget\n"
"    q     -  leave hill\n"
"\n"
"\n"
" ::  copyright (c) 2003,\n"
" ::  grzegorz moskal, g.moskal@opengroup.org\n\n"
"     michal moskal, malekith@pld-linux.org\n"
" ::  przemyslaw niezborala, finburson@o2.pl";

static struct widget* scr_main;
static struct widget* win_main;
static struct widget* menu_main;
static struct widget* win_help;

void scrmain_show(void)
{
	status = MENU;
	screen = scr_main;
	scr_main->current = win_main;
	screen_hideall(scr_main);
}

static void helpwin_show()
{
	win_help->hidden = 0;
	scr_main->current = win_help;
	sl_cls();
}

static void scrmain_init(void)
{
	int uw = WIDTH/10;
	int uh = HEIGHT/10;
	scr_main = screen_add();
	win_main = window_add(scr_main, PACKAGE" "VERSION, uw*3, uh*2, uw*4, 10);
	menu_main = menu_add(win_main, 1, 1, uw*4-2, 10, 0);
	menuobj_add(menu_main, "world cup", 'w', scrcup_show, OBJ_DOWN);
	menuobj_add(menu_main, "training", 't',scrtrain_show, 0);
	menuobj_add(menu_main, "help", 'h', helpwin_show, 0);
	menuobj_add(menu_main, "quit", 'q',quit, OBJ_DOWN);
	win_help = window_add(scr_main, "_he_lp", 5, 0, 49, 24);
	menuobj_add(menu_add(win_help, 1, 22, 47, 3, 0), "<<<",'<', scrmain_show, 0);
	win_help->hidden = 1;
	textbox_add(win_help, help_text);
}

void main_init()
{
	scrmain_init();
	scrmain_show();
}
