/* $Id: Network.h,v 1.5 2002/04/15 16:50:29 nekeme Exp $
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the ArkRPG Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef SERVER_NETWORK_H
#define SERVER_NETWORK_H

#include <Ark/ArkSocket.h>
#include <Ark/ArkNetwork.h>

namespace Server
{

   struct Result 
   {
	 int m_Msg;
	 bool m_Error;
	 Ark::String m_Reason;

      public:
	 Result(int msg = 0): m_Msg(msg), m_Error (false) {}
	 Result(int msg, const Ark::String &errreason) :
	     m_Msg(msg), m_Error(true), m_Reason(errreason) {}	 
   };

   struct Client
   {
      protected:
	 friend class Network;

	 Ark::Socket *m_Socket;
	 Ark::Entity *m_Entity;
	 bool m_Dead;
	 Ark::Packet *m_OutPacket;

      private:
	 void HandlePacket (Ark::ReadStream *packet, Result *result);

      public:
	 Client (Ark::Socket *socket = NULL);
	 ~Client ();

	 void HandleMessages ();
	 void SendUpdate (Ark::Packet *delta_packet);
   };
   
   typedef std::vector<Client*> ClientList;
   typedef std::vector<Client*>::iterator ClientLI;

   class Network
   {
      protected:
	 Ark::Socket *m_AcceptSocket;
	 ClientList m_Clients;

      public:
	 Network (const Ark::String &port);
	 ~Network ();
	 
	 bool Accept();
	 bool Receive();
	 bool Update ();
   };
}


#endif
